% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.abund.r
\name{print.abund}
\alias{print.abund}
\title{Print abundance estimates}
\usage{
\method{print}{abund}(x, ...)
}
\arguments{
\item{x}{An object output by \code{abundEstim}.  This is a distance 
function object augmented with abundance estimates, and has 
class \code{c("abund", "dfunc")}.}

\item{\dots}{Included for compatibility to other print methods.
Ignored here.}
}
\value{
0 is invisibly returned
}
\description{
Print an object of class \code{c("abund","dfunc")} 
produced by \code{abundEstim}.
}
\examples{
# Load example sparrow data (line transect survey type)
data(sparrowDetectionData)
data(sparrowSiteData)

# Fit half-normal detection function
dfunc <- dfuncEstim(formula=dist ~ 1 + offset(groupsize)
                  , detectionData=sparrowDetectionData)

# Estimate abundance given a detection function
# Note: a person should do more than R=20 bootstrap iterations
fit <- abundEstim(dfunc
                , detectionData = sparrowDetectionData
                , siteData = sparrowSiteData
                , area = units::set_units(4105, "km^2")
                , ci = NULL)
print(fit)

}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{abundEstim}}, 
\code{\link{summary.dfunc}}, \code{\link{print.dfunc}}, 
\code{\link{summary.abund}}
}
\keyword{models}
