% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_ANMM.R
\name{do.anmm}
\alias{do.anmm}
\title{Average Neighborhood Margin Maximization}
\usage{
do.anmm(
  X,
  label,
  ndim = 2,
  preprocess = c("null", "center", "scale", "cscale", "decorrelate", "whiten"),
  No = ceiling(nrow(X)/10),
  Ne = ceiling(nrow(X)/10)
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{No}{neighborhood size for same-class data points; either a constant number or
a vector of length-\eqn{n} can be provided, as long as the values reside in \eqn{[2,n]}.}

\item{Ne}{neighborhood size for different-class data points; either a constant number or
a vector of length-\eqn{n} can be provided, as long as the values reside in \eqn{[2,n]}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Average Neighborhood Margin Maximization (ANMM) is a supervised method
for feature extraction. It aims to find a projection mapping in the following manner;
for each data point, the algorithm tries to pull the neighboring points in the
same class while pushing neighboring points of different classes far away. It is known
that ANMM does suffer less from small sample size problem, which is bottleneck for LDA.
}
\examples{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.factor(iris$Species)

## perform ANMM on different choices of neighborhood size
out1 = do.anmm(X, label, No=6, Ne=6)
out2 = do.anmm(X, label, No=2, Ne=10)
out3 = do.anmm(X, label, No=10,Ne=2)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(out1$Y, main="(No,Ne)=(6,6)",  pch=19, cex=0.5, col=label)
plot(out2$Y, main="(No,Ne)=(2,10)", pch=19, cex=0.5, col=label)
plot(out3$Y, main="(No,Ne)=(10,2)", pch=19, cex=0.5, col=label)
par(opar)

}
\references{
\insertRef{wang_feature_2007}{Rdimtools}
}
\author{
Kisung You
}
\concept{linear_methods}
