% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concepts.R
\name{union.SNOMEDconcept}
\alias{union.SNOMEDconcept}
\alias{union}
\alias{union.default}
\alias{intersect.SNOMEDconcept}
\alias{intersect}
\alias{intersect.default}
\alias{setdiff.SNOMEDconcept}
\alias{setdiff}
\alias{setdiff.default}
\title{Set operations for SNOMEDconcept vectors}
\usage{
\method{union}{SNOMEDconcept}(x, y)

union(x, y)

\method{union}{default}(x, y)

\method{intersect}{SNOMEDconcept}(x, y)

intersect(x, y)

\method{intersect}{default}(x, y)

\method{setdiff}{SNOMEDconcept}(x, y)

setdiff(x, y)

\method{setdiff}{default}(x, y)
}
\arguments{
\item{x}{SNOMEDconcept vector}

\item{y}{SNOMEDconcept vector, or an object that can be coerced
to SNOMEDconcept by as.SNOMEDconcept}
}
\value{
an integer64 vector of SNOMEDconcept class
}
\description{
The default set functions in the base package do not handle integer64
vectors correctly, so this package also provides new generic functions
for union, intersect and setdiff, which enable the appropriate
object-specific function to be called according to the class of the
vector. This means that SNOMEDconcept vectors will remain as 
SNOMEDconcept vectors when these functions are used.
}
\examples{
sys_acute <- SNOMEDconcept(c('Systolic heart failure',
  'Acute heart failure'), SNOMED = sampleSNOMED())
acute_left_right <- SNOMEDconcept(c('Acute heart failure',
  'Left heart failure', 'Right heart failure'),
  SNOMED = sampleSNOMED())
union(sys_acute, acute_left_right) 
intersect(sys_acute, acute_left_right)
setdiff(sys_acute, acute_left_right)
}
\seealso{
Other SNOMEDconcept functions: 
\code{\link{as.data.frame.SNOMEDconcept}()},
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}

Other SNOMEDconcept functions: 
\code{\link{as.data.frame.SNOMEDconcept}()},
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}

Other SNOMEDconcept functions: 
\code{\link{as.data.frame.SNOMEDconcept}()},
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}

Other SNOMEDconcept functions: 
\code{\link{as.data.frame.SNOMEDconcept}()},
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}

Other SNOMEDconcept functions: 
\code{\link{as.data.frame.SNOMEDconcept}()},
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}

Other SNOMEDconcept functions: 
\code{\link{as.data.frame.SNOMEDconcept}()},
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}

Other SNOMEDconcept functions: 
\code{\link{as.data.frame.SNOMEDconcept}()},
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}

Other SNOMEDconcept functions: 
\code{\link{as.data.frame.SNOMEDconcept}()},
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}
}
\concept{SNOMEDconcept functions}
