% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNOMEDcodelist.R
\name{expandSNOMED}
\alias{expandSNOMED}
\alias{contractSNOMED}
\title{Expand or contract a SNOMEDcodelist}
\usage{
expandSNOMED(x, SNOMED = getSNOMED())

contractSNOMED(x, SNOMED = getSNOMED())
}
\arguments{
\item{x}{SNOMEDcodelist to expand or contract}

\item{SNOMED}{environment containing a SNOMED dictionary}
}
\value{
An object of class 'SNOMEDcodelist' with attribute
   Expanded = TRUE
}
\description{
SNOMEDcodelist is an S3 class for sets of SNOMED concepts.
In the 'contracted' form, it may contain only parents and not
child terms (to create a more succinct list). The 'Expanded'
form contains all concepts.
}
\examples{
SNOMED <- sampleSNOMED()

my_concepts <- SNOMEDconcept('Heart failure')
my_codelist <- SNOMEDcodelist(data.frame(conceptId = my_concepts,
  include_desc = TRUE))
expanded_codelist <- expandSNOMED(my_codelist)
contractSNOMED(expanded_codelist)
}
\seealso{
Other SNOMEDcodelist functions: 
\code{\link{SNOMEDcodelist}()},
\code{\link{is.SNOMEDcodelist}()}

Other SNOMEDcodelist functions: 
\code{\link{SNOMEDcodelist}()},
\code{\link{is.SNOMEDcodelist}()}
}
\concept{SNOMEDcodelist functions}
