\name{initGHMM}
\alias{initGHMM}

\title{
Random Initialization for a Hidden Markov Model with Continuous Emissions
}

\description{
Function used to generate a continuous hidden Markov model with random parameters. This method allows using the univariate version of a Gaussian Mixture Model when setting m = 1. The code for the methods with categorical values or discrete data can be viewed in \code{"\link{initHMM}"} and \code{"\link{initPHMM}"}, respectively.  
}

\usage{
initGHMM(n,m)
}

\arguments{
  \item{n}{it sets the number of hidden states to use.}
  \item{m}{it sets the number of variables generated by the hidden states (Observed vector dimensionality).}
}

\value{
A \code{"\link{list}"} that contains all the required values to especify the model.
\item{Model}{it especifies that the observed values are modeled by a Gaussian mixture model.}
\item{StateNames}{the set of hidden state names.}
\item{A}{the transition matrix.} 
\item{Mu}{a matrix that has the mean of each observed variable (rows) for each state (columns).} 
\item{Sigma}{a 3d matrix that has the covariance matrix of each state. The number of slices is equal to the maximum number of hidden states.} 
\item{Pi}{the initial probability vector.}
}

\references{
Cited references are listed on the \link{RcppHMM} manual page.
}

\examples{
n <- 3
m <- 5
model <- initGHMM(n, m)
print(model)
}

\keyword{initialization}
