# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Black-Scholes valuation and first derivatives via Automatic Differentiation
#'
#' This example illustrate how to use automatic differentiation to
#' calculate the delte of a Black-Scholes call and put. It is based
#' on the same example in the FastAD sources.
#' @param spot A double with the spot price, default is 105 as in Boost example
#' @param strike A double with the strike price, default is 100 as in Boost example
#' @param vol A double with the (annualized) volatility (in percent), default is 5
#' (for 500 per cent) as in Boost example
#' @param r A double with the short-term risk-free rate, default is 0.0125 as in Boost example
#' @param tau A double with the time to expiration (in fractional years), default is 30/365
#' as in Boost example
#' @return A matrix with rows for the call and put variant, and columns
#' for option value, delta and vega
#' @examples
#' black_scholes()
black_scholes <- function(spot = 105, strike = 100, vol = 5, r = 1.25 / 100, tau = 30.0 / 365) {
    .Call('_RcppFastAD_black_scholes', PACKAGE = 'RcppFastAD', spot, strike, vol, r, tau)
}

#' Evaluate a squared-loss linear regression at a given parameter value
#'
#' Not that this function does not actually fit the model. Rather it evaluates
#' the squared sum of residuals and \sQuote{gradient} of parameters.
#'
#' @param X Matrix with independent explanatory variables
#' @param y Vector with dependent variable
#' @param theta_hat Vector with initial \sQuote{guess} of parameter values
#' @param initial_lr [Optional] Scalar with initial step-size value,
#' default is 1e-4
#' @param max_iter [Optional] Scalar with maximum number of iterations,
#' default is 100
#' @param tol [Optional] Scalar with convergence tolerance, default is 1e-7
#' @return A list object with the \sQuote{loss}, \sQuote{theta} (parameters),
#' \sQuote{gradient} and \sQuote{iter} for iterations
#' @examples
#' data(trees)   # also used in help(lm)
#' X <- as.matrix(cbind(const=1, trees[, c("Girth", "Height")]))
#' y <- trees$Volume
#' linear_regression(X, y, rep(0, 3), tol=1e-12)
#' coef(lm(y ~ X - 1))  # for comparison
linear_regression <- function(X, y, theta_hat, initial_lr = 1e-4, max_iter = 100L, tol = 1e-7) {
    .Call('_RcppFastAD_linear_regression', PACKAGE = 'RcppFastAD', X, y, theta_hat, initial_lr, max_iter, tol)
}

#' Compute the value and derivate of a quadratic expression X' * Sigma * X
#'
#' @param X A 2 element vector
#' @param Sigma A 2 x 2 matrix
#' @return A list with two elements for the expression evaluated for X and Sigma as well as
#' @examples
#' X <- c(0.5, 0.6)
#' S <- matrix(c(2, 3, 3, 6), 2, 2)
#' quadratic_expression(X, S)
quadratic_expression <- function(X, Sigma) {
    .Call('_RcppFastAD_quadratic_expression', PACKAGE = 'RcppFastAD', X, Sigma)
}

