% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppCWB_package.R
\name{cl_wrapper_functions}
\alias{cl_wrapper_functions}
\alias{get_count_vector}
\alias{decode_s_attribute}
\alias{get_region_matrix}
\alias{regions_to_count_matrix}
\alias{get_cbow_matrix}
\alias{regions_to_ids}
\title{Higher-level functions using the corpus library (CL).}
\arguments{
\item{corpus}{character}

\item{s_attribute}{character}

\item{p_attribute}{character}

\item{registry}{character}

\item{strucs}{integer}
}
\description{
Higher-level functions using the corpus library (CL).
}
\section{Functions}{

\describe{
  \item{\code{decode_s_attribute(corpus, s_attribute, registry)}}{decode s-attributes}
  \item{\code{get_count_vector(corpus, p_attribute, registry)}}{count tokens in corpus}
  \item{\code{get_region_matrix(corpus, s_attribute, strucs, registry)}}{get region matrix for strucs}
  \item{\code{regions_to_count_matrix(corpus, p_attribute, registry, matrix)}}{get matrix with ids and counts}
  \item{\code{get_cbow_matrix(corpus, p_attribute, registry = registry, matrix, window = window)}}{get matrix with CBOW}
  \item{\code{regions_to_count_matrix(corpus, p_attribute, registry, matrix)}}{get counts for regions}
  \item{\code{regions_to_ids(corpus, p_attribute, registry, matrix)}}{get ids for regions}
}
}

\examples{
Sys.setenv(CORPUS_REGISTRY = system.file(package = "RcppCWB", "extdata", "cwb", "registry"))

decode_s_attribute("REUTERS", "places", registry = Sys.getenv("CORPUS_REGISTRY"))

get_count_vector(
  "REUTERS", p_attribute = "word",
  registry = Sys.getenv("CORPUS_REGISTRY")
  )
get_cbow_matrix(
  "REUTERS", p_attribute = "word", matrix = matrix(c(1,10), nrow = 1),
  window = 5L, registry = Sys.getenv("CORPUS_REGISTRY")
  )
regions_to_count_matrix(
  "REUTERS", p_attribute = "word", matrix = matrix(c(1,10), ncol = 2),
  registry = Sys.getenv("CORPUS_REGISTRY")
  )
}
