% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleBuilding.R
\name{loadPreprocessFile}
\alias{loadPreprocessFile}
\title{Preprocessing loading}
\usage{
loadPreprocessFile(file.config, ...)
}
\arguments{
\item{file.config}{character vector specifying the name of a csv file with preprocessing instructions.}

\item{...}{parameters adressed to read.csv functions.}
}
\value{
operations character matrix describing all preprocessing operations.
}
\description{
Load a csv file configuration with instruction to remove bad observations and builds object config that describes all preprocessings to apply.
}
\details{
loadPreprocessFile reads a csv file configuration with instruction to remove bad particles and builds object config that describes all preprocessings done
}
\examples{
instr <- rbind(c("select","x","log",""), c("select","y","log",""))
tf <- tempfile()
write.table(instr, tf, sep=",", col.names = FALSE, row.names = FALSE)

operations <- loadPreprocessFile(tf)

}
\seealso{
\code{\link{applyPreprocessing}}
}
