% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{saveCounts}
\alias{saveCounts}
\title{Count saving}
\usage{
saveCounts(filename.csv, counts, dir)
}
\arguments{
\item{filename.csv}{character vector specifying the path and the name of the csv file.}

\item{counts}{vector of counts.}

\item{dir}{character vector specifying the directory where to save the csv file.}
}
\value{
csv file containing count result.
}
\description{
Save a count result in a csv file.
}
\details{
saveCounts saves a count result in a csv file
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf1 <- tempfile()
write.table(dat, tf1, sep=",", dec=".")

x <- importSample(file.features=tf1, dir.save=tempdir())
res <- KmeansQuick(x$features$initial$x, K=3)

tf2 <- tempfile()
saveCounts(basename(tf2), table(res$cluster), tempdir())
 

}
