% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaPlot.R
\name{RaPlot}
\alias{RaPlot}
\title{Visualize the feature ranking results of a fitted RaSE object.}
\usage{
RaPlot(
  object,
  main = NULL,
  xlab = "feature",
  ylab = "selected percentage",
  ...
)
}
\arguments{
\item{object}{fitted \code{'RaSE'} model object.}

\item{main}{title of the plot. Default = \code{NULL}, which makes the title following the orm 'RaSE-base' with subscript i (rounds of iterations), where base represents the type of base classifier. i is omitted when it is zero.}

\item{xlab}{the label of x-axis. Default = 'feature'.}

\item{ylab}{the label of y-axis. Default = 'selected percentage'.}

\item{...}{additional arguments.}
}
\value{
a \code{'ggplot'} object.
}
\description{
This function plots the feature ranking results from a fitted \code{'RaSE'} object via \code{ggplot2}. In the figure, x-axis represents the feature number and y-axis represents the selected percentage of each feature in B1 subspaces.
}
\examples{
set.seed(0, kind = "L'Ecuyer-CMRG")
train.data <- RaModel("classification", 1, n = 100, p = 50)
xtrain <- train.data$x
ytrain <- train.data$y

# fit RaSE classifier with QDA base classifier
fit <- Rase(xtrain, ytrain, B1 = 50, B2 = 50, iteration = 1, base = 'qda',
cores = 2, criterion = 'ric')

# plot the selected percentage of each feature appearing in B1 subspaces
RaPlot(fit)

}
\seealso{
\code{\link{Rase}}.
}
