/*
 * Decompiled with CFR 0.152.
 */
package weka.core.scripting;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class Groovy
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -2628766602043134673L;
    public static final String CLASS_GROOVYCLASSLOADER = "groovy.lang.GroovyClassLoader";
    protected static boolean m_Present = false;
    protected Object m_ClassLoader = Groovy.newClassLoader();

    public Object getClassLoader() {
        return this.m_ClassLoader;
    }

    public Object invoke(String methodName, Class<?>[] paramClasses, Object[] paramValues) {
        Object result = null;
        if (this.getClassLoader() != null) {
            result = Groovy.invoke(this.getClassLoader(), methodName, paramClasses, paramValues);
        }
        return result;
    }

    public static boolean isPresent() {
        return m_Present;
    }

    public static Object newClassLoader() {
        Object result = null;
        if (Groovy.isPresent()) {
            try {
                Class<?> cls = Class.forName(CLASS_GROOVYCLASSLOADER);
                Constructor<?> constr = cls.getConstructor(ClassLoader.class);
                result = constr.newInstance(Groovy.class.getClassLoader());
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
        }
        return result;
    }

    public static Object newInstance(File file, Class<?> template) {
        Object result = null;
        if (!Groovy.isPresent()) {
            return result;
        }
        Object interpreter = Groovy.newClassLoader();
        if (interpreter == null) {
            return result;
        }
        try {
            Class cls = (Class)Groovy.invoke(interpreter, "parseClass", new Class[]{File.class}, new Object[]{file});
            result = cls.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Object invoke(Object o, String methodName, Class<?>[] paramClasses, Object[] paramValues) {
        Object result = null;
        try {
            Method m = o.getClass().getMethod(methodName, paramClasses);
            result = m.invoke(o, paramValues);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10203 $");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Groovy present: " + Groovy.isPresent());
        } else {
            Groovy groovy = new Groovy();
            if (groovy.getClassLoader() == null) {
                System.err.println("Cannot instantiate Groovy ClassLoader!");
            } else {
                Object groovyObject = Groovy.newInstance(new File(args[0]), Object.class);
                Groovy.invoke(groovyObject, "run", new Class[0], new Object[0]);
            }
        }
    }

    static {
        try {
            Class.forName(CLASS_GROOVYCLASSLOADER);
            m_Present = true;
        }
        catch (Exception e) {
            m_Present = false;
        }
    }
}

