/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Color;
import java.io.LineNumberReader;
import java.io.Reader;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class ReaderToTextPane
extends Thread {
    protected LineNumberReader m_Input;
    protected JTextPane m_Output;
    protected Color m_Color;

    public ReaderToTextPane(Reader input, JTextPane output) {
        this(input, output, Color.BLACK);
    }

    public ReaderToTextPane(Reader input, JTextPane output, Color color) {
        this.setDaemon(true);
        this.m_Color = color;
        this.m_Input = new LineNumberReader(input);
        this.m_Output = output;
        StyledDocument doc = this.m_Output.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        style = doc.addStyle(this.getStyleName(), style);
        StyleConstants.setFontFamily(style, "monospaced");
        StyleConstants.setForeground(style, this.m_Color);
    }

    public Color getColor() {
        return this.m_Color;
    }

    protected String getStyleName() {
        return "" + this.m_Color.hashCode();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    StyledDocument doc = this.m_Output.getStyledDocument();
                    doc.insertString(doc.getLength(), this.m_Input.readLine() + '\n', doc.getStyle(this.getStyleName()));
                    this.m_Output.setCaretPosition(doc.getLength());
                }
            }
            catch (Exception ex) {
                try {
                    ReaderToTextPane.sleep(100L);
                }
                catch (Exception exception) {
                }
                continue;
            }
            break;
        }
    }
}

