/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Comparator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceComparator
implements Comparator<Instance>,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -6589278678230949683L;
    protected boolean m_IncludeClass;

    public InstanceComparator() {
        this(true);
    }

    public InstanceComparator(boolean includeClass) {
        this.setIncludeClass(includeClass);
    }

    public void setIncludeClass(boolean includeClass) {
        this.m_IncludeClass = includeClass;
    }

    public boolean getIncludeClass() {
        return this.m_IncludeClass;
    }

    @Override
    public int compare(Instance o1, Instance o2) {
        Instance inst1 = o1;
        Instance inst2 = o2;
        int classindex = inst1.classIndex() == -1 ? inst1.numAttributes() - 1 : inst1.classIndex();
        int result = 0;
        for (int i = 0; i < inst1.numAttributes(); ++i) {
            if (!this.getIncludeClass() && i == classindex) continue;
            if (inst1.isMissing(i) || inst2.isMissing(i)) {
                if (inst1.isMissing(i) && inst2.isMissing(i)) continue;
                if (inst1.isMissing(i)) {
                    result = -1;
                    break;
                }
                result = 1;
                break;
            }
            if (Utils.eq(inst1.value(i), inst2.value(i))) continue;
            if (inst1.value(i) < inst2.value(i)) {
                result = -1;
                break;
            }
            result = 1;
            break;
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            return;
        }
        Instances inst = new Instances(new BufferedReader(new FileReader(args[0])));
        inst.setClassIndex(inst.numAttributes() - 1);
        InstanceComparator comp = new InstanceComparator();
        System.out.println("\nIncluding the class");
        System.out.println("comparing 1. instance with 1.: " + comp.compare(inst.instance(0), inst.instance(0)));
        System.out.println("comparing 1. instance with 2.: " + comp.compare(inst.instance(0), inst.instance(1)));
        System.out.println("comparing 2. instance with 1.: " + comp.compare(inst.instance(1), inst.instance(0)));
        comp = new InstanceComparator(false);
        System.out.println("\nExcluding the class");
        System.out.println("comparing 1. instance with 1.: " + comp.compare(inst.instance(0), inst.instance(0)));
        System.out.println("comparing 1. instance with 2.: " + comp.compare(inst.instance(0), inst.instance(1)));
        System.out.println("comparing 2. instance with 1.: " + comp.compare(inst.instance(1), inst.instance(0)));
    }
}

