/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class Ridor
extends AbstractClassifier
implements AdditionalMeasureProducer,
WeightedInstancesHandler {
    static final long serialVersionUID = -7261533075088314436L;
    private int m_Folds = 3;
    private int m_Shuffle = 1;
    private Random m_Random = null;
    private int m_Seed = 1;
    private boolean m_IsAllErr = false;
    private boolean m_IsMajority = false;
    private Ridor_node m_Root = null;
    private Attribute m_Class;
    private double m_Cover;
    private double m_Err;
    private double m_MinNo = 2.0;

    public String globalInfo() {
        return "An implementation of a RIpple-DOwn Rule learner.\n\nIt generates a default rule first and then the exceptions for the default rule with the least (weighted) error rate.  Then it generates the \"best\" exceptions for each exception and iterates until pure.  Thus it performs a tree-like expansion of exceptions.The exceptions are a set of rules that predict classes other than the default. IREP is used to generate the exceptions.\n\nFor more information about Ripple-Down Rules, see:\n\n";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int i;
        this.getCapabilities().testWithFail(instances);
        Instances data = new Instances(instances);
        data.deleteWithMissingClass();
        int numCl = data.numClasses();
        this.m_Root = new Ridor_node();
        this.m_Class = instances.classAttribute();
        int index = data.classIndex();
        this.m_Cover = data.sumOfWeights();
        this.m_Random = new Random(this.m_Seed);
        FastVector<String> binary_values = new FastVector<String>(2);
        binary_values.addElement("otherClasses");
        binary_values.addElement("defClass");
        Attribute attr = new Attribute("newClass", binary_values);
        data.insertAttributeAt(attr, index);
        data.setClassIndex(index);
        Instances[] dataByClass = new Instances[numCl];
        for (i = 0; i < numCl; ++i) {
            dataByClass[i] = new Instances(data, data.numInstances());
        }
        for (i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            inst.setClassValue(0.0);
            dataByClass[(int)inst.value(index + 1)].add(inst);
        }
        for (i = 0; i < numCl; ++i) {
            dataByClass[i].deleteAttributeAt(index + 1);
        }
        this.m_Root.findRules(dataByClass, 0);
    }

    public double classifyInstance(Instance datum) {
        return this.classify(this.m_Root, datum);
    }

    private double classify(Ridor_node node, Instance datum) {
        double classValue = node.getDefClass();
        RidorRule[] rules = node.getRules();
        if (rules != null) {
            Ridor_node[] excepts = node.getExcepts();
            for (int i = 0; i < excepts.length; ++i) {
                if (!rules[i].isCover(datum)) continue;
                classValue = this.classify(excepts[i], datum);
                break;
            }
        }
        return classValue;
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(5);
        newVector.addElement(new Option("\tSet number of folds for IREP\n\tOne fold is used as pruning set.\n\t(default 3)", "F", 1, "-F <number of folds>"));
        newVector.addElement(new Option("\tSet number of shuffles to randomize\n\tthe data in order to get better rule.\n\t(default 1)", "S", 1, "-S <number of shuffles>"));
        newVector.addElement(new Option("\tSet flag of whether use the error rate \n\tof all the data to select the default class\n\tin each step. If not set, the learner will only use\tthe error rate in the pruning data", "A", 0, "-A"));
        newVector.addElement(new Option("\t Set flag of whether use the majority class as\n\tthe default class in each step instead of \n\tchoosing default class based on the error rate\n\t(if the flag is not set)", "M", 0, "-M"));
        newVector.addElement(new Option("\tSet the minimal weights of instances\n\twithin a split.\n\t(default 2.0)", "N", 1, "-N <min. weights>"));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String numFoldsString = Utils.getOption('F', options);
        this.m_Folds = numFoldsString.length() != 0 ? Integer.parseInt(numFoldsString) : 3;
        String numShuffleString = Utils.getOption('S', options);
        this.m_Shuffle = numShuffleString.length() != 0 ? Integer.parseInt(numShuffleString) : 1;
        String seedString = Utils.getOption('s', options);
        this.m_Seed = seedString.length() != 0 ? Integer.parseInt(seedString) : 1;
        String minNoString = Utils.getOption('N', options);
        this.m_MinNo = minNoString.length() != 0 ? Double.parseDouble(minNoString) : 2.0;
        this.m_IsAllErr = Utils.getFlag('A', options);
        this.m_IsMajority = Utils.getFlag('M', options);
    }

    public String[] getOptions() {
        String[] options = new String[8];
        int current = 0;
        options[current++] = "-F";
        options[current++] = "" + this.m_Folds;
        options[current++] = "-S";
        options[current++] = "" + this.m_Shuffle;
        options[current++] = "-N";
        options[current++] = "" + this.m_MinNo;
        if (this.m_IsAllErr) {
            options[current++] = "-A";
        }
        if (this.m_IsMajority) {
            options[current++] = "-M";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String foldsTipText() {
        return "Determines the amount of data used for pruning. One fold is used for pruning, the rest for growing the rules.";
    }

    public void setFolds(int fold) {
        this.m_Folds = fold;
    }

    public int getFolds() {
        return this.m_Folds;
    }

    public String shuffleTipText() {
        return "Determines how often the data is shuffled before a rule is chosen. If > 1, a rule is learned multiple times and the most accurate rule is chosen.";
    }

    public void setShuffle(int sh) {
        this.m_Shuffle = sh;
    }

    public int getShuffle() {
        return this.m_Shuffle;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data.";
    }

    public void setSeed(int s) {
        this.m_Seed = s;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String wholeDataErrTipText() {
        return "Whether worth of rule is computed based on all the data or just based on data covered by rule.";
    }

    public void setWholeDataErr(boolean a) {
        this.m_IsAllErr = a;
    }

    public boolean getWholeDataErr() {
        return this.m_IsAllErr;
    }

    public String majorityClassTipText() {
        return "Whether the majority class is used as default.";
    }

    public void setMajorityClass(boolean m) {
        this.m_IsMajority = m;
    }

    public boolean getMajorityClass() {
        return this.m_IsMajority;
    }

    public String minNoTipText() {
        return "The minimum total weight of the instances in a rule.";
    }

    public void setMinNo(double m) {
        this.m_MinNo = m;
    }

    public double getMinNo() {
        return this.m_MinNo;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureNumRules");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.numRules();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (Ripple down rule learner)");
    }

    private double numRules() {
        int size = 0;
        if (this.m_Root != null) {
            size = this.m_Root.size();
        }
        return size + 1;
    }

    public String toString() {
        if (this.m_Root == null) {
            return "RIpple DOwn Rule Learner(Ridor): No model built yet.";
        }
        return "RIpple DOwn Rule Learner(Ridor) rules\n--------------------------------------\n\n" + this.m_Root.toString() + "\nTotal number of rules (incl. the default rule): " + (int)this.numRules();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] args) {
        Ridor.runClassifier(new Ridor(), args);
    }

    private class NominalAntd
    extends Antd {
        static final long serialVersionUID = -256386137196078004L;
        private double[] accurate;
        private double[] coverage;
        private double[] infoGain;

        public NominalAntd(Attribute a) {
            super(a);
            int bag = this.att.numValues();
            this.accurate = new double[bag];
            this.coverage = new double[bag];
            this.infoGain = new double[bag];
        }

        public Instances[] splitData(Instances data, double defAcRt, double cl) {
            int x;
            int bag = this.att.numValues();
            Instances[] splitData = new Instances[bag];
            for (x = 0; x < bag; ++x) {
                this.infoGain[x] = 0.0;
                this.coverage[x] = 0.0;
                this.accurate[x] = 0.0;
                splitData[x] = new Instances(data, data.numInstances());
            }
            for (x = 0; x < data.numInstances(); ++x) {
                Instance inst = data.instance(x);
                if (inst.isMissing(this.att)) continue;
                int v = (int)inst.value(this.att);
                splitData[v].add(inst);
                int n = v;
                this.coverage[n] = this.coverage[n] + inst.weight();
                if (!Utils.eq(inst.classValue(), cl)) continue;
                int n2 = v;
                this.accurate[n2] = this.accurate[n2] + inst.weight();
            }
            int count = 0;
            for (int x2 = 0; x2 < bag; ++x2) {
                double t = this.coverage[x2];
                if (!Utils.grOrEq(t, Ridor.this.m_MinNo)) continue;
                double p = this.accurate[x2];
                if (!Utils.eq(t, 0.0)) {
                    this.infoGain[x2] = p * (Utils.log2(p / t) - Utils.log2(defAcRt));
                }
                ++count;
            }
            if (count < 2) {
                return null;
            }
            this.value = Utils.maxIndex(this.infoGain);
            this.cover = this.coverage[(int)this.value];
            this.accu = this.accurate[(int)this.value];
            this.accuRate = !Utils.eq(this.cover, 0.0) ? this.accu / this.cover : 0.0;
            this.maxInfoGain = this.infoGain[(int)this.value];
            return splitData;
        }

        public boolean isCover(Instance inst) {
            boolean isCover = false;
            if (!inst.isMissing(this.att) && Utils.eq(inst.value(this.att), this.value)) {
                isCover = true;
            }
            return isCover;
        }

        public String toString() {
            return this.att.name() + " = " + this.att.value((int)this.value);
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5928 $");
        }
    }

    private class NumericAntd
    extends Antd {
        static final long serialVersionUID = 1968761518014492214L;
        private double splitPoint;

        public NumericAntd(Attribute a) {
            super(a);
            this.splitPoint = Double.NaN;
        }

        public double getSplitPoint() {
            return this.splitPoint;
        }

        public Instances[] splitData(Instances insts, double defAcRt, double cl) {
            Instance inst;
            Instances data = new Instances(insts);
            data.sort(this.att);
            int total = data.numInstances();
            int split = 1;
            int prev = 0;
            int finalSplit = split;
            this.maxInfoGain = 0.0;
            this.value = 0.0;
            double minSplit = 0.1 * data.sumOfWeights() / 2.0;
            if (Utils.smOrEq(minSplit, Ridor.this.m_MinNo)) {
                minSplit = Ridor.this.m_MinNo;
            } else if (Utils.gr(minSplit, 25.0)) {
                minSplit = 25.0;
            }
            double fstCover = 0.0;
            double sndCover = 0.0;
            double fstAccu = 0.0;
            double sndAccu = 0.0;
            for (int x = 0; x < data.numInstances(); ++x) {
                inst = data.instance(x);
                if (inst.isMissing(this.att)) {
                    total = x;
                    break;
                }
                sndCover += inst.weight();
                if (!Utils.eq(inst.classValue(), cl)) continue;
                sndAccu += inst.weight();
            }
            if (Utils.sm(sndCover, 2.0 * minSplit)) {
                return null;
            }
            if (total == 0) {
                return null;
            }
            this.splitPoint = data.instance(total - 1).value(this.att);
            while (split < total) {
                if (!Utils.eq(data.instance(split).value(this.att), data.instance(prev).value(this.att))) {
                    for (int y = prev; y < split; ++y) {
                        inst = data.instance(y);
                        fstCover += inst.weight();
                        sndCover -= inst.weight();
                        if (!Utils.eq(data.instance(y).classValue(), cl)) continue;
                        fstAccu += inst.weight();
                        sndAccu -= inst.weight();
                    }
                    if (Utils.sm(fstCover, minSplit) || Utils.sm(sndCover, minSplit)) {
                        prev = split;
                    } else {
                        double coverage;
                        double accurate;
                        double accRate;
                        double infoGain;
                        boolean isFirst;
                        double sndInfoGain;
                        double fstAccuRate = 0.0;
                        double sndAccuRate = 0.0;
                        if (!Utils.eq(fstCover, 0.0)) {
                            fstAccuRate = fstAccu / fstCover;
                        }
                        if (!Utils.eq(sndCover, 0.0)) {
                            sndAccuRate = sndAccu / sndCover;
                        }
                        double fstInfoGain = Utils.eq(fstAccuRate, 0.0) ? 0.0 : fstAccu * (Utils.log2(fstAccuRate) - Utils.log2(defAcRt));
                        double d = sndInfoGain = Utils.eq(sndAccuRate, 0.0) ? 0.0 : sndAccu * (Utils.log2(sndAccuRate) - Utils.log2(defAcRt));
                        if (Utils.gr(fstInfoGain, sndInfoGain) || Utils.eq(fstInfoGain, sndInfoGain) && Utils.grOrEq(fstAccuRate, sndAccuRate)) {
                            isFirst = true;
                            infoGain = fstInfoGain;
                            accRate = fstAccuRate;
                            accurate = fstAccu;
                            coverage = fstCover;
                        } else {
                            isFirst = false;
                            infoGain = sndInfoGain;
                            accRate = sndAccuRate;
                            accurate = sndAccu;
                            coverage = sndCover;
                        }
                        boolean isUpdate = Utils.gr(infoGain, this.maxInfoGain);
                        if (isUpdate) {
                            this.splitPoint = (data.instance(split).value(this.att) + data.instance(prev).value(this.att)) / 2.0;
                            this.value = !isFirst ? 1 : 0;
                            this.accuRate = accRate;
                            this.accu = accurate;
                            this.cover = coverage;
                            this.maxInfoGain = infoGain;
                            finalSplit = split;
                        }
                        prev = split;
                    }
                }
                ++split;
            }
            Instances[] splitData = new Instances[]{new Instances(data, 0, finalSplit), new Instances(data, finalSplit, total - finalSplit)};
            return splitData;
        }

        public boolean isCover(Instance inst) {
            boolean isCover = false;
            if (!inst.isMissing(this.att)) {
                if (Utils.eq(this.value, 0.0)) {
                    if (Utils.smOrEq(inst.value(this.att), this.splitPoint)) {
                        isCover = true;
                    }
                } else if (Utils.gr(inst.value(this.att), this.splitPoint)) {
                    isCover = true;
                }
            }
            return isCover;
        }

        public String toString() {
            String symbol = Utils.eq(this.value, 0.0) ? " <= " : " > ";
            return this.att.name() + symbol + Utils.doubleToString(this.splitPoint, 6);
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5928 $");
        }
    }

    private abstract class Antd
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 5317379013858933369L;
        protected Attribute att;
        protected double value;
        protected double maxInfoGain;
        protected double accuRate;
        protected double cover;
        protected double accu;

        public Antd(Attribute a) {
            this.att = a;
            this.value = Double.NaN;
            this.maxInfoGain = 0.0;
            this.accuRate = Double.NaN;
            this.cover = Double.NaN;
            this.accu = Double.NaN;
        }

        public abstract Instances[] splitData(Instances var1, double var2, double var4);

        public abstract boolean isCover(Instance var1);

        public abstract String toString();

        public Attribute getAttr() {
            return this.att;
        }

        public double getAttrValue() {
            return this.value;
        }

        public double getMaxInfoGain() {
            return this.maxInfoGain;
        }

        public double getAccuRate() {
            return this.accuRate;
        }

        public double getAccu() {
            return this.accu;
        }

        public double getCover() {
            return this.cover;
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5928 $");
        }
    }

    private class RidorRule
    implements WeightedInstancesHandler,
    Serializable,
    RevisionHandler {
        static final long serialVersionUID = 4375199423973848157L;
        private double m_Class = -1.0;
        private Attribute m_ClassAttribute;
        protected FastVector m_Antds = null;
        private double m_WorthRate = 0.0;
        private double m_Worth = 0.0;
        private double m_CoverP = 0.0;
        private double m_CoverG = 0.0;
        private double m_AccuG = 0.0;

        private RidorRule() {
        }

        public void setPredictedClass(double cl) {
            this.m_Class = cl;
        }

        public double getPredictedClass() {
            return this.m_Class;
        }

        public void buildClassifier(Instances instances) throws Exception {
            this.m_ClassAttribute = instances.classAttribute();
            if (!this.m_ClassAttribute.isNominal()) {
                throw new UnsupportedClassTypeException(" Only nominal class, please.");
            }
            if (instances.numClasses() != 2) {
                throw new Exception(" Only 2 classes, please.");
            }
            Instances data = new Instances(instances);
            if (Utils.eq(data.sumOfWeights(), 0.0)) {
                throw new Exception(" No training data.");
            }
            data.deleteWithMissingClass();
            if (Utils.eq(data.sumOfWeights(), 0.0)) {
                throw new Exception(" The class labels of all the training data are missing.");
            }
            if (data.numInstances() < Ridor.this.m_Folds) {
                throw new Exception(" Not enough data for REP.");
            }
            this.m_Antds = new FastVector();
            Ridor.this.m_Random = new Random(Ridor.this.m_Seed);
            data.randomize(Ridor.this.m_Random);
            data.stratify(Ridor.this.m_Folds);
            Instances growData = data.trainCV(Ridor.this.m_Folds, Ridor.this.m_Folds - 1, Ridor.this.m_Random);
            Instances pruneData = data.testCV(Ridor.this.m_Folds, Ridor.this.m_Folds - 1);
            this.grow(growData);
            this.prune(pruneData);
        }

        public Instances[] coveredByRule(Instances insts) {
            Instances[] data = new Instances[]{new Instances(insts, insts.numInstances()), new Instances(insts, insts.numInstances())};
            for (int i = 0; i < insts.numInstances(); ++i) {
                Instance datum = insts.instance(i);
                if (this.isCover(datum)) {
                    data[0].add(datum);
                    continue;
                }
                data[1].add(datum);
            }
            return data;
        }

        public boolean isCover(Instance datum) {
            boolean isCover = true;
            for (int i = 0; i < this.m_Antds.size(); ++i) {
                Antd antd = (Antd)this.m_Antds.elementAt(i);
                if (antd.isCover(datum)) continue;
                isCover = false;
                break;
            }
            return isCover;
        }

        public boolean hasAntds() {
            if (this.m_Antds == null) {
                return false;
            }
            return this.m_Antds.size() > 0;
        }

        private void grow(Instances data) {
            Instances growData = new Instances(data);
            this.m_AccuG = this.computeDefAccu(growData);
            this.m_CoverG = growData.sumOfWeights();
            double defAcRt = this.m_AccuG / this.m_CoverG;
            boolean[] used = new boolean[growData.numAttributes()];
            for (int k = 0; k < used.length; ++k) {
                used[k] = false;
            }
            int numUnused = used.length;
            boolean isContinue = true;
            while (isContinue) {
                double maxInfoGain = 0.0;
                Antd oneAntd = null;
                Instances coverData = null;
                Enumeration enumAttr = growData.enumerateAttributes();
                int index = -1;
                while (enumAttr.hasMoreElements()) {
                    double infoGain;
                    Instances coveredData;
                    Attribute att = (Attribute)enumAttr.nextElement();
                    Antd antd = null;
                    antd = att.isNumeric() ? new NumericAntd(att) : new NominalAntd(att);
                    if (used[++index] || (coveredData = this.computeInfoGain(growData, defAcRt, antd)) == null || !Utils.gr(infoGain = antd.getMaxInfoGain(), maxInfoGain)) continue;
                    oneAntd = antd;
                    coverData = coveredData;
                    maxInfoGain = infoGain;
                }
                if (oneAntd == null) {
                    return;
                }
                if (!oneAntd.getAttr().isNumeric()) {
                    used[oneAntd.getAttr().index()] = true;
                    --numUnused;
                }
                this.m_Antds.addElement(oneAntd);
                growData = coverData;
                defAcRt = oneAntd.getAccuRate();
                if (!Utils.eq(growData.sumOfWeights(), 0.0) && !Utils.eq(defAcRt, 1.0) && numUnused != 0) continue;
                isContinue = false;
            }
        }

        private Instances computeInfoGain(Instances instances, double defAcRt, Antd antd) {
            Instances data = new Instances(instances);
            Instances[] splitData = antd.splitData(data, defAcRt, this.m_Class);
            if (splitData != null) {
                return splitData[(int)antd.getAttrValue()];
            }
            return null;
        }

        private void prune(Instances pruneData) {
            int antdsSize;
            Instances data = new Instances(pruneData);
            double total = data.sumOfWeights();
            double defAccu = 0.0;
            double defAccuRate = 0.0;
            int size = this.m_Antds.size();
            if (size == 0) {
                return;
            }
            double[] worthRt = new double[size];
            double[] coverage = new double[size];
            double[] worthValue = new double[size];
            for (int w = 0; w < size; ++w) {
                worthValue[w] = 0.0;
                coverage[w] = 0.0;
                worthRt[w] = 0.0;
            }
            for (int x = 0; x < size; ++x) {
                Antd antd = (Antd)this.m_Antds.elementAt(x);
                Attribute attr = antd.getAttr();
                Instances newData = new Instances(data);
                data = new Instances(newData, newData.numInstances());
                for (int y = 0; y < newData.numInstances(); ++y) {
                    Instance ins = newData.instance(y);
                    if (ins.isMissing(attr) || !antd.isCover(ins)) continue;
                    int n = x;
                    coverage[n] = coverage[n] + ins.weight();
                    data.add(ins);
                    if (!Utils.eq(ins.classValue(), this.m_Class)) continue;
                    int n2 = x;
                    worthValue[n2] = worthValue[n2] + ins.weight();
                }
                if (coverage[x] == 0.0) continue;
                worthRt[x] = worthValue[x] / coverage[x];
            }
            for (int z = size - 1; z > 0 && Utils.sm(worthRt[z], worthRt[z - 1]); --z) {
                this.m_Antds.removeElementAt(z);
            }
            if (this.m_Antds.size() == 1 && Utils.sm(worthRt[0], defAccuRate = (defAccu = this.computeDefAccu(pruneData)) / total)) {
                this.m_Antds.removeAllElements();
            }
            if ((antdsSize = this.m_Antds.size()) != 0) {
                this.m_Worth = worthValue[antdsSize - 1];
                this.m_WorthRate = worthRt[antdsSize - 1];
                this.m_CoverP = coverage[antdsSize - 1];
                Antd last = (Antd)this.m_Antds.lastElement();
                this.m_CoverG = last.getCover();
                this.m_AccuG = last.getAccu();
            } else {
                this.m_Worth = defAccu;
                this.m_WorthRate = defAccuRate;
                this.m_CoverP = total;
            }
        }

        private double computeDefAccu(Instances data) {
            double defAccu = 0.0;
            for (int i = 0; i < data.numInstances(); ++i) {
                Instance inst = data.instance(i);
                if (!Utils.eq(inst.classValue(), this.m_Class)) continue;
                defAccu += inst.weight();
            }
            return defAccu;
        }

        public double getWorthRate() {
            return this.m_WorthRate;
        }

        public double getWorth() {
            return this.m_Worth;
        }

        public double getCoverP() {
            return this.m_CoverP;
        }

        public double getCoverG() {
            return this.m_CoverG;
        }

        public double getAccuG() {
            return this.m_AccuG;
        }

        public String toString(String att, String cl) {
            StringBuffer text = new StringBuffer();
            if (this.m_Antds.size() > 0) {
                for (int j = 0; j < this.m_Antds.size() - 1; ++j) {
                    text.append("(" + ((Antd)this.m_Antds.elementAt(j)).toString() + ") and ");
                }
                text.append("(" + ((Antd)this.m_Antds.lastElement()).toString() + ")");
            }
            text.append(" => " + att + " = " + cl);
            text.append("  (" + this.m_CoverG + "/" + (this.m_CoverG - this.m_AccuG) + ") [" + this.m_CoverP + "/" + (this.m_CoverP - this.m_Worth) + "]");
            return text.toString();
        }

        public String toString() {
            return this.toString(this.m_ClassAttribute.name(), this.m_ClassAttribute.value((int)this.m_Class));
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5928 $");
        }
    }

    private class Ridor_node
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -581370560157467677L;
        private double defClass = Double.NaN;
        private RidorRule[] rules = null;
        private Ridor_node[] excepts = null;
        private int level;

        private Ridor_node() {
        }

        public double getDefClass() {
            return this.defClass;
        }

        public RidorRule[] getRules() {
            return this.rules;
        }

        public Ridor_node[] getExcepts() {
            return this.excepts;
        }

        public void findRules(Instances[] dataByClass, int lvl) throws Exception {
            Vector finalRules = null;
            int clas = -1;
            double[] isPure = new double[dataByClass.length];
            int numMajority = 0;
            this.level = lvl + 1;
            for (int h = 0; h < dataByClass.length; ++h) {
                isPure[h] = dataByClass[h].sumOfWeights();
                if (!Utils.grOrEq(isPure[h], Ridor.this.m_Folds)) continue;
                ++numMajority;
            }
            if (numMajority <= 1) {
                this.defClass = Utils.maxIndex(isPure);
                return;
            }
            double total = Utils.sum(isPure);
            if (Ridor.this.m_IsMajority) {
                this.defClass = Utils.maxIndex(isPure);
                Instances data = new Instances(dataByClass[(int)this.defClass]);
                int index = data.classIndex();
                for (int j = 0; j < data.numInstances(); ++j) {
                    data.instance(j).setClassValue(1.0);
                }
                for (int k = 0; k < dataByClass.length; ++k) {
                    if (k == (int)this.defClass) continue;
                    data = data.numInstances() >= dataByClass[k].numInstances() ? this.append(data, dataByClass[k]) : this.append(dataByClass[k], data);
                }
                data.setClassIndex(index);
                double classCount = total - isPure[(int)this.defClass];
                finalRules = new Vector();
                this.buildRuleset(data, classCount, finalRules);
                if (finalRules.size() == 0) {
                    return;
                }
            } else {
                double maxAcRt = isPure[Utils.maxIndex(isPure)] / total;
                for (int i = 0; i < dataByClass.length; ++i) {
                    if (!(isPure[i] >= (double)Ridor.this.m_Folds)) continue;
                    Instances data = new Instances(dataByClass[i]);
                    int index = data.classIndex();
                    for (int j = 0; j < data.numInstances(); ++j) {
                        data.instance(j).setClassValue(1.0);
                    }
                    for (int k = 0; k < dataByClass.length; ++k) {
                        if (k == i) continue;
                        data = data.numInstances() >= dataByClass[k].numInstances() ? this.append(data, dataByClass[k]) : this.append(dataByClass[k], data);
                    }
                    data.setClassIndex(index);
                    double classCount = data.sumOfWeights() - isPure[i];
                    Vector ruleset = new Vector();
                    double wAcRt = this.buildRuleset(data, classCount, ruleset);
                    if (!Utils.gr(wAcRt, maxAcRt)) continue;
                    finalRules = ruleset;
                    maxAcRt = wAcRt;
                    clas = i;
                }
                if (finalRules == null) {
                    this.defClass = Utils.maxIndex(isPure);
                    return;
                }
                this.defClass = clas;
            }
            int size = finalRules.size();
            this.rules = new RidorRule[size];
            this.excepts = new Ridor_node[size];
            for (int l = 0; l < size; ++l) {
                this.rules[l] = (RidorRule)finalRules.elementAt(l);
            }
            Instances[] uncovered = dataByClass;
            if (this.level == 1) {
                Ridor.this.m_Err = total - uncovered[(int)this.defClass].sumOfWeights();
            }
            uncovered[(int)this.defClass] = new Instances(uncovered[(int)this.defClass], 0);
            for (int m = 0; m < size; ++m) {
                Instances[][] dvdData = this.divide(this.rules[m], uncovered);
                Instances[] covered = dvdData[0];
                this.excepts[m] = new Ridor_node();
                this.excepts[m].findRules(covered, this.level);
            }
        }

        private double buildRuleset(Instances insts, double classCount, Vector ruleset) throws Exception {
            Instances data = new Instances(insts);
            double wAcRt = 0.0;
            double total = data.sumOfWeights();
            while (classCount >= (double)Ridor.this.m_Folds) {
                RidorRule bestRule = null;
                double bestWorthRate = -1.0;
                double bestWorth = -1.0;
                RidorRule rule = new RidorRule();
                rule.setPredictedClass(0.0);
                for (int j = 0; j < Ridor.this.m_Shuffle; ++j) {
                    double w;
                    double wr;
                    if (Ridor.this.m_Shuffle > 1) {
                        data.randomize(Ridor.this.m_Random);
                    }
                    rule.buildClassifier(data);
                    if (Ridor.this.m_IsAllErr) {
                        wr = (rule.getWorth() + rule.getAccuG()) / (rule.getCoverP() + rule.getCoverG());
                        w = rule.getWorth() + rule.getAccuG();
                    } else {
                        wr = rule.getWorthRate();
                        w = rule.getWorth();
                    }
                    if (!Utils.gr(wr, bestWorthRate) && (!Utils.eq(wr, bestWorthRate) || !Utils.gr(w, bestWorth))) continue;
                    bestRule = rule;
                    bestWorthRate = wr;
                    bestWorth = w;
                }
                if (bestRule == null) {
                    throw new Exception("Something wrong here inside findRule()!");
                }
                if (Utils.sm(bestWorthRate, 0.5) || !bestRule.hasAntds()) break;
                Instances newData = new Instances(data);
                data = new Instances(newData, 0);
                classCount = 0.0;
                double cover = 0.0;
                for (int l = 0; l < newData.numInstances(); ++l) {
                    Instance datum = newData.instance(l);
                    if (!bestRule.isCover(datum)) {
                        data.add(datum);
                        if (!Utils.eq(datum.classValue(), 0.0)) continue;
                        classCount += datum.weight();
                        continue;
                    }
                    cover += datum.weight();
                }
                wAcRt += this.computeWeightedAcRt(bestWorthRate, cover, total);
                ruleset.addElement(bestRule);
            }
            double wDefAcRt = (data.sumOfWeights() - classCount) / total;
            return wAcRt += wDefAcRt;
        }

        private Instances append(Instances data1, Instances data2) {
            Instances data = new Instances(data1);
            for (int i = 0; i < data2.numInstances(); ++i) {
                data.add(data2.instance(i));
            }
            return data;
        }

        private double computeWeightedAcRt(double worthRt, double cover, double total) {
            return worthRt * (cover / total);
        }

        private Instances[][] divide(RidorRule rule, Instances[] dataByClass) {
            int len = dataByClass.length;
            Instances[][] dataBags = new Instances[2][len];
            for (int i = 0; i < len; ++i) {
                Instances[] dvdData = rule.coveredByRule(dataByClass[i]);
                dataBags[0][i] = dvdData[0];
                dataBags[1][i] = dvdData[1];
            }
            return dataBags;
        }

        public int size() {
            int size = 0;
            if (this.rules != null) {
                for (int i = 0; i < this.rules.length; ++i) {
                    size += this.excepts[i].size();
                }
                size += this.rules.length;
            }
            return size;
        }

        public String toString() {
            StringBuffer text = new StringBuffer();
            if (this.level == 1) {
                text.append(Ridor.this.m_Class.name() + " = " + Ridor.this.m_Class.value((int)this.getDefClass()) + "  (" + Ridor.this.m_Cover + "/" + Ridor.this.m_Err + ")\n");
            }
            if (this.rules != null) {
                for (int i = 0; i < this.rules.length; ++i) {
                    for (int j = 0; j < this.level; ++j) {
                        text.append("         ");
                    }
                    String cl = Ridor.this.m_Class.value((int)this.excepts[i].getDefClass());
                    text.append("  Except " + this.rules[i].toString(Ridor.this.m_Class.name(), cl) + "\n" + this.excepts[i].toString());
                }
            }
            return text.toString();
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5928 $");
        }
    }
}

