/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Remove;

public class AddCluster
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 7414280611943807337L;
    protected Clusterer m_Clusterer = new SimpleKMeans();
    protected Range m_IgnoreAttributesRange = null;
    protected Filter m_removeAttributes = new Remove();

    public Capabilities getCapabilities(Instances instances) {
        Instances instances2 = new Instances(instances, 0);
        instances2.setClassIndex(-1);
        return super.getCapabilities(instances2);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.m_Clusterer.getCapabilities();
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    protected void testInputFormat(Instances instances) throws Exception {
        this.getCapabilities(instances).testWithFail(this.removeIgnored(instances));
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_removeAttributes = null;
        return false;
    }

    protected Instances removeIgnored(Instances instances) throws Exception {
        Instances instances2 = instances;
        if (this.m_IgnoreAttributesRange != null || instances.classIndex() >= 0) {
            this.m_removeAttributes = new Remove();
            String string = "";
            if (this.m_IgnoreAttributesRange != null) {
                string = string + this.m_IgnoreAttributesRange.getRanges();
            }
            if (instances.classIndex() >= 0) {
                string = string.length() > 0 ? string + "," + (instances.classIndex() + 1) : "" + (instances.classIndex() + 1);
            }
            ((Remove)this.m_removeAttributes).setAttributeIndices(string);
            ((Remove)this.m_removeAttributes).setInvertSelection(false);
            this.m_removeAttributes.setInputFormat(instances);
            instances2 = Filter.useFilter(instances, this.m_removeAttributes);
        }
        return instances2;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        Instances instances = this.getInputFormat();
        if (!this.isFirstBatchDone()) {
            Instances instances2 = this.removeIgnored(instances);
            this.m_Clusterer.buildClusterer(instances2);
            Instances instances3 = new Instances(instances, 0);
            FastVector fastVector = new FastVector(this.m_Clusterer.numberOfClusters());
            for (int i = 0; i < this.m_Clusterer.numberOfClusters(); ++i) {
                fastVector.addElement("cluster" + (i + 1));
            }
            instances3.insertAttributeAt(new Attribute("cluster", fastVector), instances3.numAttributes());
            this.setOutputFormat(instances3);
        }
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.convertInstance(instances.instance(i));
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.outputFormatPeek() != null) {
            this.convertInstance(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    protected void convertInstance(Instance instance) throws Exception {
        Instance instance2 = instance;
        double[] dArray = new double[instance.numAttributes() + 1];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            dArray[i] = instance2.value(i);
        }
        Instance instance3 = null;
        if (this.m_removeAttributes != null) {
            this.m_removeAttributes.input(instance);
            instance3 = this.m_removeAttributes.output();
        } else {
            instance3 = instance;
        }
        dArray[instance.numAttributes()] = this.m_Clusterer.clusterInstance(instance3);
        Instance instance4 = instance2 instanceof SparseInstance ? new SparseInstance(instance2.weight(), dArray) : new Instance(instance2.weight(), dArray);
        instance4.setDataset(instance.dataset());
        this.copyValues(instance4, false, instance.dataset(), this.getOutputFormat());
        instance4.setDataset(this.getOutputFormat());
        this.push(instance4);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tFull class name of clusterer to use, followed\n\tby scheme options. eg:\n\t\t\"weka.clusterers.SimpleKMeans -N 3\"\n\t(default: weka.clusterers.SimpleKMeans)", "W", 1, "-W <clusterer specification>"));
        vector.addElement(new Option("\tThe range of attributes the clusterer should ignore.\n", "I", 1, "-I <att1,att2-att4,...>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String[] stringArray2;
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            string = SimpleKMeans.class.getName();
        }
        if ((stringArray2 = Utils.splitOptions(string)).length == 0) {
            throw new Exception("Invalid clusterer specification string");
        }
        String string2 = stringArray2[0];
        stringArray2[0] = "";
        this.setClusterer(Clusterer.forName(string2, stringArray2));
        this.setIgnoredAttributeIndices(Utils.getOption('I', stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-W";
        stringArray[n++] = "" + this.getClustererSpec();
        if (!this.getIgnoredAttributeIndices().equals("")) {
            stringArray[n++] = "-I";
            stringArray[n++] = this.getIgnoredAttributeIndices();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return "A filter that adds a new nominal attribute representing the cluster assigned to each instance by the specified clustering algorithm.";
    }

    public String clustererTipText() {
        return "The clusterer to assign clusters with.";
    }

    public void setClusterer(Clusterer clusterer) {
        this.m_Clusterer = clusterer;
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    protected String getClustererSpec() {
        Clusterer clusterer = this.getClusterer();
        if (clusterer instanceof OptionHandler) {
            return clusterer.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)clusterer)).getOptions());
        }
        return clusterer.getClass().getName();
    }

    public String ignoredAttributeIndicesTipText() {
        return "The range of attributes to be ignored by the clusterer. eg: first-3,5,9-last";
    }

    public String getIgnoredAttributeIndices() {
        if (this.m_IgnoreAttributesRange == null) {
            return "";
        }
        return this.m_IgnoreAttributesRange.getRanges();
    }

    public void setIgnoredAttributeIndices(String string) {
        if (string == null || string.length() == 0) {
            this.m_IgnoreAttributesRange = null;
        } else {
            this.m_IgnoreAttributesRange = new Range();
            this.m_IgnoreAttributesRange.setRanges(string);
        }
    }

    public static void main(String[] stringArray) {
        AddCluster.runFilter(new AddCluster(), stringArray);
    }
}

