/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallSplitter;
import weka.core.neighboursearch.balltrees.BallTreeConstructor;
import weka.core.neighboursearch.balltrees.PointsClosestToFurthestChildren;

public class TopDownConstructor
extends BallTreeConstructor
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -5150140645091889979L;
    protected BallSplitter m_Splitter = new PointsClosestToFurthestChildren();

    public String globalInfo() {
        return "The class implementing the TopDown construction method of ball trees. It further uses one of a number of different splitting methods to split a ball while constructing the tree top down.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Stephen M. Omohundro");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1989");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Five Balltree Construction Algorithms");
        technicalInformation.setValue(TechnicalInformation.Field.MONTH, "December");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "TR-89-063");
        technicalInformation.setValue(TechnicalInformation.Field.INSTITUTION, "International Computer Science Institute");
        return technicalInformation;
    }

    public BallNode buildTree() throws Exception {
        this.m_MaxDepth = 0;
        this.m_NumNodes = 0;
        this.m_NumLeaves = 1;
        this.m_Splitter.setInstances(this.m_Instances);
        this.m_Splitter.setInstanceList(this.m_InstList);
        this.m_Splitter.setEuclideanDistanceFunction((EuclideanDistance)this.m_DistanceFunction);
        BallNode ballNode = new BallNode(0, this.m_InstList.length - 1, 0);
        ballNode.setPivot(BallNode.calcCentroidPivot(this.m_InstList, this.m_Instances));
        ballNode.setRadius(BallNode.calcRadius(this.m_InstList, this.m_Instances, ballNode.getPivot(), this.m_DistanceFunction));
        this.splitNodes(ballNode, this.m_MaxDepth + 1);
        return ballNode;
    }

    protected void splitNodes(BallNode ballNode, int n) throws Exception {
        if (ballNode.m_NumInstances <= this.m_MaxInstancesInLeaf) {
            return;
        }
        --this.m_NumLeaves;
        this.m_Splitter.splitNode(ballNode, this.m_NumNodes);
        this.m_NumNodes += 2;
        this.m_NumLeaves += 2;
        if (this.m_MaxDepth < n) {
            this.m_MaxDepth = n;
        }
        this.splitNodes(ballNode.m_Left, n + 1);
        this.splitNodes(ballNode.m_Right, n + 1);
        if (this.m_FullyContainChildBalls) {
            double d = BallNode.calcRadius(ballNode.m_Left, ballNode.m_Right, ballNode.getPivot(), this.m_DistanceFunction);
            Instance instance = BallNode.calcPivot(ballNode.m_Left, ballNode.m_Right, this.m_Instances);
            System.err.println("Left Radius: " + ballNode.m_Left.getRadius() + " Right Radius: " + ballNode.m_Right.getRadius() + " d(p1,p2): " + this.m_DistanceFunction.distance(ballNode.m_Left.getPivot(), ballNode.m_Right.getPivot()) + " node's old radius: " + ballNode.getRadius() + " node's new Radius: " + d + " node;s old pivot: " + ballNode.getPivot() + " node's new pivot: " + instance);
            ballNode.setRadius(d);
        }
    }

    public int[] addInstance(BallNode ballNode, Instance instance) throws Exception {
        if (ballNode.m_Left != null && ballNode.m_Right != null) {
            double d;
            double d2 = this.m_DistanceFunction.distance(instance, ballNode.m_Left.getPivot(), Double.POSITIVE_INFINITY);
            if (d2 < (d = this.m_DistanceFunction.distance(instance, ballNode.m_Right.getPivot(), Double.POSITIVE_INFINITY))) {
                this.addInstance(ballNode.m_Left, instance);
                this.processNodesAfterAddInstance(ballNode.m_Right);
            } else {
                this.addInstance(ballNode.m_Right, instance);
            }
            ++ballNode.m_End;
        } else {
            if (ballNode.m_Left != null || ballNode.m_Right != null) {
                throw new Exception("Error: Only one leaf of the built ball tree is assigned. Please check code.");
            }
            int n = this.m_Instances.numInstances() - 1;
            int[] nArray = new int[this.m_Instances.numInstances()];
            System.arraycopy(this.m_InstList, 0, nArray, 0, ballNode.m_End + 1);
            if (ballNode.m_End < this.m_InstList.length - 1) {
                System.arraycopy(this.m_InstList, ballNode.m_End + 2, nArray, ballNode.m_End + 2, this.m_InstList.length - ballNode.m_End - 1);
            }
            nArray[ballNode.m_End + 1] = n;
            ++ballNode.m_End;
            ++ballNode.m_NumInstances;
            this.m_InstList = nArray;
            this.m_Splitter.setInstanceList(this.m_InstList);
            if (ballNode.m_NumInstances > this.m_MaxInstancesInLeaf) {
                this.m_Splitter.splitNode(ballNode, this.m_NumNodes);
                this.m_NumNodes += 2;
            }
        }
        return this.m_InstList;
    }

    protected void processNodesAfterAddInstance(BallNode ballNode) {
        ++ballNode.m_Start;
        ++ballNode.m_End;
        if (ballNode.m_Left != null && ballNode.m_Right != null) {
            this.processNodesAfterAddInstance(ballNode.m_Left);
            this.processNodesAfterAddInstance(ballNode.m_Right);
        }
    }

    public String ballSplitterTipText() {
        return "The BallSplitter algorithm set that would be used by the TopDown BallTree constructor.";
    }

    public BallSplitter getBallSplitter() {
        return this.m_Splitter;
    }

    public void setBallSplitter(BallSplitter ballSplitter) {
        this.m_Splitter = ballSplitter;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tBall splitting algorithm to use.", "S", 1, "-S <classname and options>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            String[] stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length == 0) {
                throw new Exception("Invalid BallSplitter specification string.");
            }
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            this.setBallSplitter((BallSplitter)Utils.forName(BallSplitter.class, string2, stringArray2));
        } else {
            this.setBallSplitter(new PointsClosestToFurthestChildren());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-S");
        vector.add(this.m_Splitter.getClass().getName());
        return vector.toArray(new String[vector.size()]);
    }
}

