/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Instances;
import weka.gui.beans.AbstractTrainAndTestSetProducer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;

public class TrainTestSplitMaker
extends AbstractTrainAndTestSetProducer
implements DataSourceListener,
TrainingSetListener,
TestSetListener,
UserRequestAcceptor,
EventConstraints,
Serializable {
    private static final long serialVersionUID = 7390064039444605943L;
    private double m_trainPercentage = 66.0;
    private int m_randomSeed = 1;
    private Thread m_splitThread = null;

    public TrainTestSplitMaker() {
        this.m_visual.loadIcons("weka/gui/beans/icons/TrainTestSplitMaker.gif", "weka/gui/beans/icons/TrainTestSplittMaker_animated.gif");
        this.m_visual.setText("TrainTestSplitMaker");
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public String globalInfo() {
        return "Split an incoming data set into separate train and test sets.";
    }

    public String trainPercentTipText() {
        return "The percentage of data to go into the training set";
    }

    public void setTrainPercent(double d) {
        this.m_trainPercentage = d;
    }

    public double getTrainPercent() {
        return this.m_trainPercentage;
    }

    public String seedTipText() {
        return "The randomization seed";
    }

    public void setSeed(int n) {
        this.m_randomSeed = n;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public void acceptTrainingSet(TrainingSetEvent trainingSetEvent) {
        Instances instances = trainingSetEvent.getTrainingSet();
        DataSetEvent dataSetEvent = new DataSetEvent(this, instances);
        this.acceptDataSet(dataSetEvent);
    }

    public void acceptTestSet(TestSetEvent testSetEvent) {
        Instances instances = testSetEvent.getTestSet();
        DataSetEvent dataSetEvent = new DataSetEvent(this, instances);
        this.acceptDataSet(dataSetEvent);
    }

    public void acceptDataSet(DataSetEvent dataSetEvent) {
        if (this.m_splitThread == null) {
            final Instances instances = new Instances(dataSetEvent.getDataSet());
            this.m_splitThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        block10: {
                            try {
                                instances.randomize(new Random(TrainTestSplitMaker.this.m_randomSeed));
                                int n = (int)Math.round((double)instances.numInstances() * TrainTestSplitMaker.this.m_trainPercentage / 100.0);
                                int n2 = instances.numInstances() - n;
                                Instances instances3 = new Instances(instances, 0, n);
                                Instances instances2 = new Instances(instances, n, n2);
                                TrainingSetEvent trainingSetEvent = new TrainingSetEvent(TrainTestSplitMaker.this, instances3);
                                trainingSetEvent.m_setNumber = 1;
                                trainingSetEvent.m_maxSetNumber = 1;
                                if (TrainTestSplitMaker.this.m_splitThread != null) {
                                    TrainTestSplitMaker.this.notifyTrainingSetProduced(trainingSetEvent);
                                }
                                TestSetEvent testSetEvent = new TestSetEvent(TrainTestSplitMaker.this, instances2);
                                testSetEvent.m_setNumber = 1;
                                testSetEvent.m_maxSetNumber = 1;
                                if (TrainTestSplitMaker.this.m_splitThread != null) {
                                    TrainTestSplitMaker.this.notifyTestSetProduced(testSetEvent);
                                    break block10;
                                }
                                if (TrainTestSplitMaker.this.m_logger == null) break block10;
                                TrainTestSplitMaker.this.m_logger.logMessage("[TrainTestSplitMaker] " + TrainTestSplitMaker.this.statusMessagePrefix() + " Split has been canceled!");
                                TrainTestSplitMaker.this.m_logger.statusMessage(TrainTestSplitMaker.this.statusMessagePrefix() + "INTERRUPTED");
                            }
                            catch (Exception exception) {
                                this.stop();
                                if (TrainTestSplitMaker.this.m_logger != null) {
                                    TrainTestSplitMaker.this.m_logger.statusMessage(TrainTestSplitMaker.this.statusMessagePrefix() + "ERROR (See log for details)");
                                    TrainTestSplitMaker.this.m_logger.logMessage("[TrainTestSplitMaker] " + TrainTestSplitMaker.this.statusMessagePrefix() + " problem during split creation. " + exception.getMessage());
                                }
                                exception.printStackTrace();
                                Object var8_9 = null;
                                if (this.isInterrupted() && TrainTestSplitMaker.this.m_logger != null) {
                                    TrainTestSplitMaker.this.m_logger.logMessage("[TrainTestSplitMaker] " + TrainTestSplitMaker.this.statusMessagePrefix() + " Split has been canceled!");
                                    TrainTestSplitMaker.this.m_logger.statusMessage(TrainTestSplitMaker.this.statusMessagePrefix() + "INTERRUPTED");
                                }
                                TrainTestSplitMaker.this.block(false);
                                return;
                            }
                        }
                        Object var8_8 = null;
                        if (this.isInterrupted() && TrainTestSplitMaker.this.m_logger != null) {
                            TrainTestSplitMaker.this.m_logger.logMessage("[TrainTestSplitMaker] " + TrainTestSplitMaker.this.statusMessagePrefix() + " Split has been canceled!");
                            TrainTestSplitMaker.this.m_logger.statusMessage(TrainTestSplitMaker.this.statusMessagePrefix() + "INTERRUPTED");
                        }
                        TrainTestSplitMaker.this.block(false);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (this.isInterrupted() && TrainTestSplitMaker.this.m_logger != null) {
                            TrainTestSplitMaker.this.m_logger.logMessage("[TrainTestSplitMaker] " + TrainTestSplitMaker.this.statusMessagePrefix() + " Split has been canceled!");
                            TrainTestSplitMaker.this.m_logger.statusMessage(TrainTestSplitMaker.this.statusMessagePrefix() + "INTERRUPTED");
                        }
                        TrainTestSplitMaker.this.block(false);
                        throw throwable;
                    }
                }
            };
            this.m_splitThread.setPriority(1);
            this.m_splitThread.start();
            this.block(true);
            this.m_splitThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestSetProduced(TestSetEvent testSetEvent) {
        Vector vector;
        TrainTestSplitMaker trainTestSplitMaker = this;
        synchronized (trainTestSplitMaker) {
            vector = (Vector)this.m_testListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size() && this.m_splitThread != null; ++i) {
                ((TestSetListener)vector.elementAt(i)).acceptTestSet(testSetEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetProduced(TrainingSetEvent trainingSetEvent) {
        Vector vector;
        TrainTestSplitMaker trainTestSplitMaker = this;
        synchronized (trainTestSplitMaker) {
            vector = (Vector)this.m_trainingListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size() && this.m_splitThread != null; ++i) {
                ((TrainingSetListener)vector.elementAt(i)).acceptTrainingSet(trainingSetEvent);
            }
        }
    }

    private synchronized void block(boolean bl) {
        if (bl) {
            try {
                if (this.m_splitThread.isAlive()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_splitThread != null) {
            Thread thread = this.m_splitThread;
            this.m_splitThread = null;
            thread.interrupt();
            thread.stop();
        }
    }

    public boolean isBusy() {
        return this.m_splitThread != null;
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        if (this.m_splitThread != null) {
            vector.addElement("Stop");
        }
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Stop") != 0) {
            throw new IllegalArgumentException(string + " not supported (TrainTestSplitMaker)");
        }
        this.stop();
    }

    public boolean eventGeneratable(String string) {
        if (this.m_listenee == null) {
            return false;
        }
        if (this.m_listenee instanceof EventConstraints) {
            return ((EventConstraints)this.m_listenee).eventGeneratable("dataSet") || ((EventConstraints)this.m_listenee).eventGeneratable("trainingSet") || ((EventConstraints)this.m_listenee).eventGeneratable("testSet");
        }
        return true;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

