/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.ensembleLibraryEditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.EnsembleLibrary;
import weka.classifiers.EnsembleLibraryModel;
import weka.gui.ensembleLibraryEditor.ModelList;

public class ListModelsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -1986253077944432252L;
    private EnsembleLibrary m_Library;
    private JButton m_RemoveSelectedButton;
    private JButton m_OpenModelFileButton;
    private JButton m_SaveModelFileButton;
    private ModelList m_ModelList;
    private JFileChooser m_modelListChooser = new JFileChooser(new File(System.getProperty("user.dir")));

    public ListModelsPanel(EnsembleLibrary ensembleLibrary) {
        this.m_Library = ensembleLibrary;
        this.createListModelsPanel();
    }

    public void setLibrary(EnsembleLibrary ensembleLibrary) {
        this.m_Library = ensembleLibrary;
    }

    private void createListModelsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Currently Chosen Library Models"));
        this.m_ModelList = new ModelList();
        this.m_ModelList.getInputMap().put(KeyStroke.getKeyStroke("released DELETE"), "deleteSelected");
        this.m_ModelList.getActionMap().put("deleteSelected", new AbstractAction("deleteSelected"){
            private static final long serialVersionUID = 8178827388328307805L;

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = ListModelsPanel.this.m_ModelList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ListModelsPanel.this.removeModel((EnsembleLibraryModel)objectArray[i]);
                }
                int[] nArray = new int[]{ListModelsPanel.this.m_ModelList.getSelectedIndices()[0]};
                ListModelsPanel.this.m_ModelList.setSelectedIndices(nArray);
            }
        });
        this.m_ModelList.setSelectionMode(2);
        this.m_ModelList.setVisibleRowCount(-1);
        this.m_ModelList.setLayoutOrientation(0);
        JScrollPane jScrollPane = new JScrollPane(this.m_ModelList);
        jScrollPane.setPreferredSize(new Dimension(150, 50));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)jPanel, gridBagConstraints);
        this.m_RemoveSelectedButton = new JButton("Remove Selected");
        this.m_RemoveSelectedButton.addActionListener(this);
        this.m_RemoveSelectedButton.setToolTipText("Remove all currently selected models from the above list");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.m_RemoveSelectedButton, gridBagConstraints);
        this.m_modelListChooser.setAcceptAllFileFilterUsed(false);
        XMLModelFileFilter xMLModelFileFilter = new XMLModelFileFilter();
        this.m_modelListChooser.addChoosableFileFilter(xMLModelFileFilter);
        this.m_modelListChooser.addChoosableFileFilter(new FlatModelFileFilter());
        this.m_modelListChooser.setFileFilter(xMLModelFileFilter);
        this.m_modelListChooser.setFileSelectionMode(0);
        this.m_OpenModelFileButton = new JButton("Open...");
        this.m_OpenModelFileButton.addActionListener(this);
        this.m_OpenModelFileButton.setToolTipText("Import a model list file from the file system");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.m_OpenModelFileButton, gridBagConstraints);
        this.m_SaveModelFileButton = new JButton("Save...");
        this.m_SaveModelFileButton.addActionListener(this);
        this.m_SaveModelFileButton.setToolTipText("Save the current list of models to a file");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.m_SaveModelFileButton, gridBagConstraints);
    }

    public EnsembleLibrary getLibrary() {
        return this.m_Library;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_OpenModelFileButton) {
            int n = this.m_modelListChooser.showOpenDialog(this);
            if (n == 0) {
                this.clearAll();
                File file = this.m_modelListChooser.getSelectedFile();
                if (this.m_modelListChooser.getFileFilter() instanceof FlatModelFileFilter) {
                    if (!file.getName().endsWith(".mlf")) {
                        file = new File(file.getPath() + ".mlf");
                    }
                } else if (!file.getName().endsWith(".model.xml")) {
                    file = new File(file.getPath() + ".model.xml");
                }
                EnsembleLibrary.loadLibrary(file, this, this.m_Library);
                ModelList.SortedListModel sortedListModel = (ModelList.SortedListModel)this.m_ModelList.getModel();
                TreeSet treeSet = this.m_Library.getModels();
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    this.addModel((EnsembleLibraryModel)iterator.next());
                }
            }
        } else if (actionEvent.getSource() == this.m_SaveModelFileButton) {
            int n = this.m_modelListChooser.showSaveDialog(this);
            if (n == 0) {
                File file = this.m_modelListChooser.getSelectedFile();
                if (this.m_modelListChooser.getFileFilter() instanceof FlatModelFileFilter) {
                    if (!file.getName().endsWith(".mlf")) {
                        file = new File(file.getPath() + ".mlf");
                    }
                } else if (!file.getName().endsWith(".model.xml")) {
                    file = new File(file.getPath() + ".model.xml");
                }
                EnsembleLibrary.saveLibrary(file, this.m_Library, this);
            }
        } else if (actionEvent.getSource() == this.m_RemoveSelectedButton) {
            Object[] objectArray = this.m_ModelList.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.removeModel((EnsembleLibraryModel)objectArray[i]);
            }
            if (this.m_ModelList.getSelectedIndices().length > 0) {
                int[] nArray = new int[]{this.m_ModelList.getSelectedIndices()[0]};
                this.m_ModelList.setSelectedIndices(nArray);
            }
        }
    }

    public void clearAll() {
        ((ModelList.SortedListModel)this.m_ModelList.getModel()).clear();
        this.m_Library.clearModels();
    }

    public void addModel(EnsembleLibraryModel ensembleLibraryModel) {
        ((ModelList.SortedListModel)this.m_ModelList.getModel()).add(ensembleLibraryModel);
        this.m_Library.addModel(ensembleLibraryModel);
    }

    public void removeModel(EnsembleLibraryModel ensembleLibraryModel) {
        ((ModelList.SortedListModel)this.m_ModelList.getModel()).removeElement(ensembleLibraryModel);
        this.m_Library.removeModel(ensembleLibraryModel);
    }

    class FlatModelFileFilter
    extends FileFilter {
        FlatModelFileFilter() {
        }

        public boolean accept(File file) {
            String string = file.getName();
            return string.endsWith(".mlf") || file.isDirectory();
        }

        public String getDescription() {
            return "Model List Files (*.mlf)";
        }
    }

    class XMLModelFileFilter
    extends FileFilter {
        XMLModelFileFilter() {
        }

        public boolean accept(File file) {
            String string = file.getName();
            return string.endsWith(".model.xml") || file.isDirectory();
        }

        public String getDescription() {
            return "XML Library Files (*.model.xml)";
        }
    }
}

