/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.SimpleBatchFilter;

public class AddClassification
extends SimpleBatchFilter {
    private static final long serialVersionUID = -1931467132568441909L;
    protected Classifier m_Classifier = new ZeroR();
    protected File m_SerializedClassifierFile = new File(System.getProperty("user.dir"));
    protected Classifier m_ActualClassifier = null;
    protected boolean m_OutputClassification = false;
    protected boolean m_RemoveOldClass = false;
    protected boolean m_OutputDistribution = false;
    protected boolean m_OutputErrorFlag = false;

    public String globalInfo() {
        return "A filter for adding the classification, the class distribution and an error flag to a dataset with a classifier. The classifier is either trained on the data itself or provided as serialized model.";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tFull class name of classifier to use, followed\n\tby scheme options. eg:\n\t\t\"weka.classifiers.bayes.NaiveBayes -D\"\n\t(default: weka.classifiers.rules.ZeroR)", "W", 1, "-W <classifier specification>"));
        vector.addElement(new Option("\tInstead of training a classifier on the data, one can also provide\n\ta serialized model and use that for tagging the data.", "serialized", 1, "-serialized <file>"));
        vector.addElement(new Option("\tAdds an attribute with the actual classification.\n\t(default: off)", "classification", 0, "-classification"));
        vector.addElement(new Option("\tRemoves the old class attribute.\n\t(default: off)", "remove-old-class", 0, "-remove-old-class"));
        vector.addElement(new Option("\tAdds attributes with the distribution for all classes \n\t(for numeric classes this will be identical to the attribute \n\toutput with '-classification').\n\t(default: off)", "distribution", 0, "-distribution"));
        vector.addElement(new Option("\tAdds an attribute indicating whether the classifier output \n\ta wrong classification (for numeric classes this is the numeric \n\tdifference).\n\t(default: off)", "error", 0, "-error"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setOutputClassification(Utils.getFlag("classification", stringArray));
        this.setRemoveOldClass(Utils.getFlag("remove-old-class", stringArray));
        this.setOutputDistribution(Utils.getFlag("distribution", stringArray));
        this.setOutputErrorFlag(Utils.getFlag("error", stringArray));
        boolean bl = false;
        String string = Utils.getOption("serialized", stringArray);
        if (string.length() != 0) {
            File file = new File(string);
            if (!file.exists()) {
                throw new FileNotFoundException("File '" + file.getAbsolutePath() + "' not found!");
            }
            if (file.isDirectory()) {
                throw new FileNotFoundException("'" + file.getAbsolutePath() + "' points to a directory not a file!");
            }
            this.setSerializedClassifierFile(file);
            bl = true;
        } else {
            this.setSerializedClassifierFile(null);
        }
        if (!bl) {
            String[] stringArray2;
            string = Utils.getOption('W', stringArray);
            if (string.length() == 0) {
                string = ZeroR.class.getName();
            }
            if ((stringArray2 = Utils.splitOptions(string)).length == 0) {
                throw new Exception("Invalid classifier specification string");
            }
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setClassifier(Classifier.forName(string, stringArray2));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        File file;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (this.getOutputClassification()) {
            vector.add("-classification");
        }
        if (this.getRemoveOldClass()) {
            vector.add("-remove-old-class");
        }
        if (this.getOutputDistribution()) {
            vector.add("-distribution");
        }
        if (this.getOutputErrorFlag()) {
            vector.add("-error");
        }
        if ((file = this.getSerializedClassifierFile()) != null && !file.isDirectory()) {
            vector.add("-serialized");
            vector.add(file.getAbsolutePath());
        } else {
            vector.add("-W");
            vector.add(this.getClassifierSpec());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getClassifier() == null ? super.getCapabilities() : this.getClassifier().getCapabilities();
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public String classifierTipText() {
        return "The classifier to use for classification.";
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    protected String getClassifierSpec() {
        Classifier classifier = this.getClassifier();
        String string = classifier.getClass().getName();
        if (classifier instanceof OptionHandler) {
            string = string + " " + Utils.joinOptions(classifier.getOptions());
        }
        return string;
    }

    public String serializedClassifierFileTipText() {
        return "A file containing the serialized model of a trained classifier.";
    }

    public File getSerializedClassifierFile() {
        return this.m_SerializedClassifierFile;
    }

    public void setSerializedClassifierFile(File file) {
        if (file == null || !file.exists()) {
            file = new File(System.getProperty("user.dir"));
        }
        this.m_SerializedClassifierFile = file;
    }

    public String outputClassificationTipText() {
        return "Whether to add an attribute with the actual classification.";
    }

    public boolean getOutputClassification() {
        return this.m_OutputClassification;
    }

    public void setOutputClassification(boolean bl) {
        this.m_OutputClassification = bl;
    }

    public String removeOldClassTipText() {
        return "Whether to remove the old class attribute.";
    }

    public boolean getRemoveOldClass() {
        return this.m_RemoveOldClass;
    }

    public void setRemoveOldClass(boolean bl) {
        this.m_RemoveOldClass = bl;
    }

    public String outputDistributionTipText() {
        return "Whether to add attributes with the distribution for all classes (for numeric classes this will be identical to the attribute output with 'outputClassification').";
    }

    public boolean getOutputDistribution() {
        return this.m_OutputDistribution;
    }

    public void setOutputDistribution(boolean bl) {
        this.m_OutputDistribution = bl;
    }

    public String outputErrorFlagTipText() {
        return "Whether to add an attribute indicating whether the classifier output a wrong classification (for numeric classes this is the numeric difference).";
    }

    public boolean getOutputErrorFlag() {
        return this.m_OutputErrorFlag;
    }

    public void setOutputErrorFlag(boolean bl) {
        this.m_OutputErrorFlag = bl;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        int n;
        int n2 = -1;
        FastVector fastVector = new FastVector();
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == instances.classIndex() && this.getRemoveOldClass()) continue;
            if (n == instances.classIndex()) {
                n2 = n;
            }
            fastVector.addElement(instances.attribute(n).copy());
        }
        if (this.getOutputClassification()) {
            if (n2 == -1) {
                n2 = fastVector.size();
            }
            fastVector.addElement(instances.classAttribute().copy("classification"));
        }
        if (this.getOutputDistribution()) {
            if (instances.classAttribute().isNominal()) {
                for (n = 0; n < instances.classAttribute().numValues(); ++n) {
                    fastVector.addElement(new Attribute("distribution_" + instances.classAttribute().value(n)));
                }
            } else {
                fastVector.addElement(new Attribute("distribution"));
            }
        }
        if (this.getOutputErrorFlag()) {
            if (instances.classAttribute().isNominal()) {
                FastVector fastVector2 = new FastVector();
                fastVector2.addElement("no");
                fastVector2.addElement("yes");
                fastVector.addElement(new Attribute("error", fastVector2));
            } else {
                fastVector.addElement(new Attribute("error"));
            }
        }
        Instances instances2 = new Instances(instances.relationName(), fastVector, 0);
        instances2.setClassIndex(n2);
        return instances2;
    }

    protected Instances process(Instances instances) throws Exception {
        if (!this.isFirstBatchDone()) {
            File file = this.getSerializedClassifierFile();
            if (!file.isDirectory()) {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                this.m_ActualClassifier = (Classifier)objectInputStream.readObject();
                objectInputStream.close();
            } else {
                this.m_ActualClassifier = Classifier.makeCopy(this.m_Classifier);
                this.m_ActualClassifier.buildClassifier(instances);
            }
        }
        Instances instances2 = this.getOutputFormat();
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            double[] dArray = instance.toDoubleArray();
            double[] dArray2 = new double[instances2.numAttributes()];
            int n = dArray.length;
            if (this.getRemoveOldClass()) {
                --n;
            }
            System.arraycopy(dArray, 0, dArray2, 0, n);
            if (this.getOutputClassification()) {
                dArray2[n] = this.m_ActualClassifier.classifyInstance(instance);
                ++n;
            }
            if (this.getOutputDistribution()) {
                double[] dArray3 = this.m_ActualClassifier.distributionForInstance(instance);
                for (int j = 0; j < dArray3.length; ++j) {
                    dArray2[n] = dArray3[j];
                    ++n;
                }
            }
            if (this.getOutputErrorFlag()) {
                dArray2[n] = instances2.classAttribute().isNominal() ? (instance.classValue() == this.m_ActualClassifier.classifyInstance(instance) ? 0.0 : 1.0) : this.m_ActualClassifier.classifyInstance(instance) - instance.classValue();
                ++n;
            }
            Instance instance2 = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), dArray2) : new Instance(instance.weight(), dArray2);
            this.copyValues(instance2, false, instance.dataset(), this.getOutputFormat());
            instances2.add(instance2);
        }
        return instances2;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] stringArray) {
        AddClassification.runFilter(new AddClassification(), stringArray);
    }
}

