/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.pace;

import java.util.Random;
import weka.classifiers.functions.pace.MixtureDistribution;
import weka.classifiers.functions.pace.NormalMixture;
import weka.classifiers.functions.pace.PaceMatrix;
import weka.core.RevisionUtils;
import weka.core.matrix.DoubleVector;
import weka.core.matrix.Maths;

public class ChisqMixture
extends MixtureDistribution {
    protected double separatingThreshold = 0.05;
    protected double trimingThreshold = 0.5;
    protected double supportThreshold = 0.5;
    protected int maxNumSupportPoints = 200;
    protected int fittingIntervalLength = 3;
    protected double fittingIntervalThreshold = 0.5;

    public double getSeparatingThreshold() {
        return this.separatingThreshold;
    }

    public void setSeparatingThreshold(double d) {
        this.separatingThreshold = d;
    }

    public double getTrimingThreshold() {
        return this.trimingThreshold;
    }

    public void setTrimingThreshold(double d) {
        this.trimingThreshold = d;
    }

    public boolean separable(DoubleVector doubleVector, int n, int n2, double d) {
        DoubleVector doubleVector2 = doubleVector.sqrt();
        double d2 = Math.sqrt(d);
        NormalMixture normalMixture = new NormalMixture();
        normalMixture.setSeparatingThreshold(this.separatingThreshold);
        return normalMixture.separable(doubleVector2, n, n2, d2);
    }

    public DoubleVector supportPoints(DoubleVector doubleVector, int n) {
        DoubleVector doubleVector2 = new DoubleVector();
        doubleVector2.setCapacity(doubleVector.size() + 1);
        if (doubleVector.get(0) < this.supportThreshold || n != 0) {
            doubleVector2.addElement(0.0);
        }
        for (int i = 0; i < doubleVector.size(); ++i) {
            if (!(doubleVector.get(i) > this.supportThreshold)) continue;
            doubleVector2.addElement(doubleVector.get(i));
        }
        if (doubleVector2.size() > this.maxNumSupportPoints) {
            throw new IllegalArgumentException("Too many support points. ");
        }
        return doubleVector2;
    }

    public PaceMatrix fittingIntervals(DoubleVector doubleVector) {
        double d;
        double d2;
        int n;
        PaceMatrix paceMatrix = new PaceMatrix(doubleVector.size() * 2, 2);
        DoubleVector doubleVector2 = doubleVector.sqrt();
        int n2 = 0;
        for (n = 0; n < doubleVector.size(); ++n) {
            d2 = doubleVector2.get(n) - (double)this.fittingIntervalLength;
            if (d2 < this.fittingIntervalThreshold) {
                d2 = 0.0;
            }
            d2 *= d2;
            d = doubleVector.get(n);
            if (d < this.fittingIntervalThreshold) {
                d = this.fittingIntervalThreshold;
            }
            paceMatrix.set(n2, 0, d2);
            paceMatrix.set(n2, 1, d);
            ++n2;
        }
        for (n = 0; n < doubleVector.size(); ++n) {
            d2 = doubleVector.get(n);
            if (d2 < this.fittingIntervalThreshold) {
                d2 = 0.0;
            }
            d = doubleVector2.get(n) + this.fittingIntervalThreshold;
            d *= d;
            paceMatrix.set(n2, 0, d2);
            paceMatrix.set(n2, 1, d);
            ++n2;
        }
        paceMatrix.setRowDimension(n2);
        return paceMatrix;
    }

    public PaceMatrix probabilityMatrix(DoubleVector doubleVector, PaceMatrix paceMatrix) {
        int n = doubleVector.size();
        int n2 = paceMatrix.getRowDimension();
        PaceMatrix paceMatrix2 = new PaceMatrix(n2, n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                paceMatrix2.set(i, j, Maths.pchisq(paceMatrix.get(i, 1), doubleVector.get(j)) - Maths.pchisq(paceMatrix.get(i, 0), doubleVector.get(j)));
            }
        }
        return paceMatrix2;
    }

    public double pace6(double d) {
        if (d > 100.0) {
            return d;
        }
        DoubleVector doubleVector = this.mixingDistribution.getPointValues();
        DoubleVector doubleVector2 = this.mixingDistribution.getFunctionValues();
        DoubleVector doubleVector3 = doubleVector.sqrt();
        DoubleVector doubleVector4 = Maths.dchisqLog(d, doubleVector);
        doubleVector4.minusEquals(doubleVector4.max());
        doubleVector4 = doubleVector4.map("java.lang.Math", "exp").timesEquals(doubleVector2);
        double d2 = doubleVector3.innerProduct(doubleVector4) / doubleVector4.sum();
        return d2 * d2;
    }

    public DoubleVector pace6(DoubleVector doubleVector) {
        DoubleVector doubleVector2 = new DoubleVector(doubleVector.size());
        for (int i = 0; i < doubleVector.size(); ++i) {
            doubleVector2.set(i, this.pace6(doubleVector.get(i)));
        }
        this.trim(doubleVector2);
        return doubleVector2;
    }

    public DoubleVector pace2(DoubleVector doubleVector) {
        int n;
        DoubleVector doubleVector2 = new DoubleVector(doubleVector.size());
        for (n = 0; n < doubleVector.size(); ++n) {
            doubleVector2.set(n, this.hf(doubleVector.get(n)));
        }
        doubleVector2.cumulateInPlace();
        n = doubleVector2.indexOfMax();
        DoubleVector doubleVector3 = doubleVector.copy();
        if (n < doubleVector.size() - 1) {
            doubleVector3.set(n + 1, doubleVector.size() - 1, 0.0);
        }
        this.trim(doubleVector3);
        return doubleVector3;
    }

    public DoubleVector pace4(DoubleVector doubleVector) {
        DoubleVector doubleVector2 = this.h(doubleVector);
        DoubleVector doubleVector3 = doubleVector.copy();
        for (int i = 0; i < doubleVector.size(); ++i) {
            if (!(doubleVector2.get(i) <= 0.0)) continue;
            doubleVector3.set(i, 0.0);
        }
        this.trim(doubleVector3);
        return doubleVector3;
    }

    public void trim(DoubleVector doubleVector) {
        for (int i = 0; i < doubleVector.size(); ++i) {
            if (!(doubleVector.get(i) <= this.trimingThreshold)) continue;
            doubleVector.set(i, 0.0);
        }
    }

    public double hf(double d) {
        DoubleVector doubleVector = this.mixingDistribution.getPointValues();
        DoubleVector doubleVector2 = this.mixingDistribution.getFunctionValues();
        double d2 = Math.sqrt(d);
        DoubleVector doubleVector3 = doubleVector.sqrt();
        DoubleVector doubleVector4 = Maths.dnormLog(d2, doubleVector3, 1.0);
        double d3 = doubleVector4.max();
        doubleVector4.minusEquals(d3);
        DoubleVector doubleVector5 = Maths.dnormLog(-d2, doubleVector3, 1.0);
        doubleVector5.minusEquals(d3);
        doubleVector4 = doubleVector4.map("java.lang.Math", "exp");
        doubleVector4.timesEquals(doubleVector2);
        doubleVector5 = doubleVector5.map("java.lang.Math", "exp");
        doubleVector5.timesEquals(doubleVector2);
        return (doubleVector.minus(d2 / 2.0).innerProduct(doubleVector4) - doubleVector.plus(d2 / 2.0).innerProduct(doubleVector5)) / (doubleVector4.sum() + doubleVector5.sum());
    }

    public double h(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        DoubleVector doubleVector = this.mixingDistribution.getPointValues();
        DoubleVector doubleVector2 = this.mixingDistribution.getFunctionValues();
        double d2 = Math.sqrt(d);
        DoubleVector doubleVector3 = doubleVector.sqrt();
        DoubleVector doubleVector4 = Maths.dnorm(d2, doubleVector3, 1.0).timesEquals(doubleVector2);
        DoubleVector doubleVector5 = Maths.dnorm(-d2, doubleVector3, 1.0).timesEquals(doubleVector2);
        return doubleVector.minus(d2 / 2.0).innerProduct(doubleVector4) - doubleVector.plus(d2 / 2.0).innerProduct(doubleVector5);
    }

    public DoubleVector h(DoubleVector doubleVector) {
        DoubleVector doubleVector2 = new DoubleVector(doubleVector.size());
        for (int i = 0; i < doubleVector.size(); ++i) {
            doubleVector2.set(i, this.h(doubleVector.get(i)));
        }
        return doubleVector2;
    }

    public double f(double d) {
        DoubleVector doubleVector = this.mixingDistribution.getPointValues();
        DoubleVector doubleVector2 = this.mixingDistribution.getFunctionValues();
        return Maths.dchisq(d, doubleVector).timesEquals(doubleVector2).sum();
    }

    public DoubleVector f(DoubleVector doubleVector) {
        DoubleVector doubleVector2 = new DoubleVector(doubleVector.size());
        for (int i = 0; i < doubleVector.size(); ++i) {
            doubleVector2.set(i, this.h(doubleVector2.get(i)));
        }
        return doubleVector2;
    }

    public String toString() {
        return this.mixingDistribution.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    public static void main(String[] stringArray) {
        int n = 50;
        int n2 = 50;
        double d = 0.0;
        double d2 = 10.0;
        double d3 = Math.sqrt(d);
        double d4 = Math.sqrt(d2);
        DoubleVector doubleVector = Maths.rnorm(n, d3, 1.0, new Random());
        DoubleVector doubleVector2 = doubleVector = doubleVector.cat(Maths.rnorm(n2, d4, 1.0, new Random()));
        doubleVector = doubleVector.square();
        doubleVector.sort();
        DoubleVector doubleVector3 = new DoubleVector(n, d3).cat(new DoubleVector(n2, d4));
        System.out.println("==========================================================");
        System.out.println("This is to test the estimation of the mixing\ndistribution of the mixture of non-central Chi-square\ndistributions. The example mixture used is of the form: \n\n   0.5 * Chi^2_1(ncp1) + 0.5 * Chi^2_1(ncp2)\n");
        System.out.println("It also tests the PACE estimators. Quadratic losses of the\nestimators are given, measuring their performance.");
        System.out.println("==========================================================");
        System.out.println("ncp1 = " + d + " ncp2 = " + d2 + "\n");
        System.out.println(doubleVector.size() + " observations are: \n\n" + doubleVector);
        System.out.println("\nQuadratic loss of the raw data (i.e., the MLE) = " + doubleVector2.sum2(doubleVector3));
        System.out.println("==========================================================");
        ChisqMixture chisqMixture = new ChisqMixture();
        chisqMixture.fit(doubleVector, 1);
        System.out.println("The estimated mixing distribution is\n" + chisqMixture);
        DoubleVector doubleVector4 = chisqMixture.pace2(doubleVector.rev()).rev();
        System.out.println("\nThe PACE2 Estimate = \n" + doubleVector4);
        System.out.println("Quadratic loss = " + doubleVector4.sqrt().times(doubleVector2.sign()).sum2(doubleVector3));
        doubleVector4 = chisqMixture.pace4(doubleVector);
        System.out.println("\nThe PACE4 Estimate = \n" + doubleVector4);
        System.out.println("Quadratic loss = " + doubleVector4.sqrt().times(doubleVector2.sign()).sum2(doubleVector3));
        doubleVector4 = chisqMixture.pace6(doubleVector);
        System.out.println("\nThe PACE6 Estimate = \n" + doubleVector4);
        System.out.println("Quadratic loss = " + doubleVector4.sqrt().times(doubleVector2.sign()).sum2(doubleVector3));
    }
}

