/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.NumericToBinary;

public class ChiSquaredAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler {
    static final long serialVersionUID = -8316857822521717692L;
    private boolean m_missing_merge;
    private boolean m_Binarize;
    private double[] m_ChiSquareds;

    public String globalInfo() {
        return "ChiSquaredAttributeEval :\n\nEvaluates the worth of an attribute by computing the value of the chi-squared statistic with respect to the class.\n";
    }

    public ChiSquaredAttributeEval() {
        this.resetOptions();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\ttreat missing values as a seperate value.", "M", 0, "-M"));
        vector.addElement(new Option("\tjust binarize numeric attributes instead \n\tof properly discretizing them.", "B", 0, "-B"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        this.setMissingMerge(!Utils.getFlag('M', stringArray));
        this.setBinarizeNumericAttributes(Utils.getFlag('B', stringArray));
    }

    public String[] getOptions() {
        String[] stringArray = new String[2];
        int n = 0;
        if (!this.getMissingMerge()) {
            stringArray[n++] = "-M";
        }
        if (this.getBinarizeNumericAttributes()) {
            stringArray[n++] = "-B";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String binarizeNumericAttributesTipText() {
        return "Just binarize numeric attributes instead of properly discretizing them.";
    }

    public void setBinarizeNumericAttributes(boolean bl) {
        this.m_Binarize = bl;
    }

    public boolean getBinarizeNumericAttributes() {
        return this.m_Binarize;
    }

    public String missingMergeTipText() {
        return "Distribute counts for missing values. Counts are distributed across other values in proportion to their frequency. Otherwise, missing is treated as a separate value.";
    }

    public void setMissingMerge(boolean bl) {
        this.m_missing_merge = bl;
    }

    public boolean getMissingMerge() {
        return this.m_missing_merge;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        int n;
        Filter filter;
        this.getCapabilities().testWithFail(instances);
        int n2 = instances.classIndex();
        int n3 = instances.numInstances();
        if (!this.m_Binarize) {
            filter = new Discretize();
            ((Discretize)filter).setUseBetterEncoding(true);
            ((Discretize)filter).setInputFormat(instances);
            instances = Filter.useFilter(instances, filter);
        } else {
            filter = new NumericToBinary();
            ((NumericToBinary)filter).setInputFormat(instances);
            instances = Filter.useFilter(instances, filter);
        }
        int n4 = instances.attribute(n2).numValues();
        double[][][] dArrayArray = new double[instances.numAttributes()][][];
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == n2) continue;
            n = instances.attribute(i).numValues();
            dArrayArray[i] = new double[n + 1][n4 + 1];
        }
        double[] dArray = new double[n4 + 1];
        for (n = 0; n < n3; ++n) {
            Instance instance = instances.instance(n);
            if (instance.classIsMissing()) {
                int n5 = n4;
                dArray[n5] = dArray[n5] + instance.weight();
                continue;
            }
            int n6 = (int)instance.classValue();
            dArray[n6] = dArray[n6] + instance.weight();
        }
        for (n = 0; n < dArrayArray.length; ++n) {
            if (n == n2) continue;
            for (int i = 0; i < dArray.length; ++i) {
                dArrayArray[n][0][i] = dArray[i];
            }
        }
        for (n = 0; n < n3; ++n) {
            Instance instance = instances.instance(n);
            for (int i = 0; i < instance.numValues(); ++i) {
                if (instance.index(i) == n2) continue;
                if (instance.isMissingSparse(i) || instance.classIsMissing()) {
                    if (!instance.isMissingSparse(i)) {
                        double[] dArray2 = dArrayArray[instance.index(i)][(int)instance.valueSparse(i)];
                        int n7 = n4;
                        dArray2[n7] = dArray2[n7] + instance.weight();
                        double[] dArray3 = dArrayArray[instance.index(i)][0];
                        int n8 = n4;
                        dArray3[n8] = dArray3[n8] - instance.weight();
                        continue;
                    }
                    if (!instance.classIsMissing()) {
                        double[] dArray4 = dArrayArray[instance.index(i)][instances.attribute(instance.index(i)).numValues()];
                        int n9 = (int)instance.classValue();
                        dArray4[n9] = dArray4[n9] + instance.weight();
                        double[] dArray5 = dArrayArray[instance.index(i)][0];
                        int n10 = (int)instance.classValue();
                        dArray5[n10] = dArray5[n10] - instance.weight();
                        continue;
                    }
                    double[] dArray6 = dArrayArray[instance.index(i)][instances.attribute(instance.index(i)).numValues()];
                    int n11 = n4;
                    dArray6[n11] = dArray6[n11] + instance.weight();
                    double[] dArray7 = dArrayArray[instance.index(i)][0];
                    int n12 = n4;
                    dArray7[n12] = dArray7[n12] - instance.weight();
                    continue;
                }
                double[] dArray8 = dArrayArray[instance.index(i)][(int)instance.valueSparse(i)];
                int n13 = (int)instance.classValue();
                dArray8[n13] = dArray8[n13] + instance.weight();
                double[] dArray9 = dArrayArray[instance.index(i)][0];
                int n14 = (int)instance.classValue();
                dArray9[n14] = dArray9[n14] - instance.weight();
            }
        }
        if (this.m_missing_merge) {
            for (n = 0; n < instances.numAttributes(); ++n) {
                int n15;
                int n16;
                if (n == n2) continue;
                int n17 = instances.attribute(n).numValues();
                double[] dArray10 = new double[n17];
                double[] dArray11 = new double[n4];
                double d = 0.0;
                for (int i = 0; i < n17; ++i) {
                    for (n16 = 0; n16 < n4; ++n16) {
                        int n18 = i;
                        dArray10[n18] = dArray10[n18] + dArrayArray[n][i][n16];
                        int n19 = n16;
                        dArray11[n19] = dArray11[n19] + dArrayArray[n][i][n16];
                    }
                    d += dArray10[i];
                }
                if (!Utils.gr(d, 0.0)) continue;
                double[][] dArray12 = new double[n17][n4];
                for (n16 = 0; n16 < n17; ++n16) {
                    for (n15 = 0; n15 < n4; ++n15) {
                        dArray12[n16][n15] = dArray10[n16] / d * dArrayArray[n][n17][n15];
                    }
                }
                for (n16 = 0; n16 < n4; ++n16) {
                    for (n15 = 0; n15 < n17; ++n15) {
                        double[] dArray13 = dArray12[n15];
                        int n20 = n16;
                        dArray13[n20] = dArray13[n20] + dArray11[n16] / d * dArrayArray[n][n15][n4];
                    }
                }
                for (n16 = 0; n16 < n4; ++n16) {
                    for (n15 = 0; n15 < n17; ++n15) {
                        double[] dArray14 = dArray12[n15];
                        int n21 = n16;
                        dArray14[n21] = dArray14[n21] + dArrayArray[n][n15][n16] / d * dArrayArray[n][n17][n4];
                    }
                }
                double[][] dArray15 = new double[n17][n4];
                for (n15 = 0; n15 < n17; ++n15) {
                    for (int i = 0; i < n4; ++i) {
                        dArray15[n15][i] = dArrayArray[n][n15][i] + dArray12[n15][i];
                    }
                }
                dArrayArray[n] = dArray15;
            }
        }
        this.m_ChiSquareds = new double[instances.numAttributes()];
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == n2) continue;
            this.m_ChiSquareds[n] = ContingencyTables.chiVal(ContingencyTables.reduceMatrix(dArrayArray[n]), false);
        }
    }

    protected void resetOptions() {
        this.m_ChiSquareds = null;
        this.m_missing_merge = true;
        this.m_Binarize = false;
    }

    public double evaluateAttribute(int n) throws Exception {
        return this.m_ChiSquareds[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_ChiSquareds == null) {
            stringBuffer.append("Chi-squared attribute evaluator has not been built");
        } else {
            stringBuffer.append("\tChi-squared Ranking Filter");
            if (!this.m_missing_merge) {
                stringBuffer.append("\n\tMissing values treated as seperate");
            }
            if (this.m_Binarize) {
                stringBuffer.append("\n\tNumeric attributes are just binarized");
            }
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.16 $");
    }

    public static void main(String[] stringArray) {
        ChiSquaredAttributeEval.runEvaluator(new ChiSquaredAttributeEval(), stringArray);
    }
}

