/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.java_cup;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import weka.core.parser.java_cup.runtime.Symbol;
import weka.core.parser.java_cup.sym;

public class ErrorManager {
    private static ErrorManager errorManager = new ErrorManager();
    private int errors = 0;
    private int warnings = 0;
    private int fatals = 0;

    public int getFatalCount() {
        return this.fatals;
    }

    public int getErrorCount() {
        return this.errors;
    }

    public int getWarningCount() {
        return this.warnings;
    }

    public static ErrorManager getManager() {
        return errorManager;
    }

    private ErrorManager() {
    }

    public void emit_fatal(String string) {
        System.err.println("Fatal : " + string);
        ++this.fatals;
    }

    public void emit_fatal(String string, Symbol symbol2) {
        System.err.println("Fatal: " + string + " @ " + symbol2);
        ++this.fatals;
    }

    public void emit_warning(String string) {
        System.err.println("Warning : " + string);
        ++this.warnings;
    }

    public void emit_warning(String string, Symbol symbol2) {
        System.err.println("Fatal: " + string + " @ " + symbol2);
        ++this.warnings;
    }

    public void emit_error(String string) {
        System.err.println("Error : " + string);
        ++this.errors;
    }

    public void emit_error(String string, Symbol symbol2) {
        System.err.println("Error: " + string + " @ " + symbol2);
        ++this.errors;
    }

    private static String convSymbol(Symbol symbol2) {
        String string = symbol2.value == null ? "" : " (\"" + symbol2.value.toString() + "\")";
        Field[] fieldArray = sym.class.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!Modifier.isPublic(fieldArray[i].getModifiers())) continue;
            try {
                if (fieldArray[i].getInt(null) != symbol2.sym) continue;
                return fieldArray[i].getName() + string;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return symbol2.toString() + string;
    }
}

