/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Random;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.BayesNetGenerator;
import weka.classifiers.bayes.net.EditableBayesNet;
import weka.classifiers.bayes.net.MarginCalculator;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyDialog;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.BIFParser;
import weka.gui.graphvisualizer.GraphNode;
import weka.gui.graphvisualizer.HierarchicalBCEngine;
import weka.gui.graphvisualizer.LayoutCompleteEvent;
import weka.gui.graphvisualizer.LayoutCompleteEventListener;
import weka.gui.graphvisualizer.LayoutEngine;
import weka.gui.visualize.PrintablePanel;

public class GUI
extends JPanel
implements LayoutCompleteEventListener {
    private static final long serialVersionUID = -2038911085935515624L;
    protected LayoutEngine m_layoutEngine;
    protected GraphPanel m_GraphPanel;
    EditableBayesNet m_BayesNet = new EditableBayesNet(true);
    protected String m_sFileName = "";
    MarginCalculator m_marginCalculator = null;
    MarginCalculator m_marginCalculatorWithEvidence = null;
    boolean m_bViewMargins = false;
    boolean m_bViewCliques = false;
    private JMenuBar m_menuBar;
    Instances m_Instances = null;
    final JTextField m_jTfZoom;
    final JToolBar m_jTbTools;
    final JLabel m_jStatusBar;
    private final JTextField m_jTfNodeWidth = new JTextField(3);
    private final JTextField m_jTfNodeHeight = new JTextField(3);
    JScrollPane m_jScrollPane;
    private final String ICONPATH = "weka/classifiers/bayes/net/icons/";
    private double m_fScale = 1.0;
    private int m_nNodeHeight = 2 * this.getFontMetrics(this.getFont()).getHeight();
    static final int DEFAULT_NODE_WIDTH = 50;
    private int m_nNodeWidth = 50;
    static final int PADDING = 10;
    private int m_nPaddedNodeWidth = 60;
    private int[] m_nZoomPercents = new int[]{10, 25, 50, 75, 100, 125, 150, 175, 200, 225, 250, 275, 300, 350, 400, 450, 500, 550, 600, 650, 700, 800, 900, 999};
    Action a_new = new ActionNew();
    Action a_quit = new ActionQuit();
    Action a_save = new ActionSave();
    ActionExport a_export = new ActionExport();
    ActionPrint a_print = new ActionPrint();
    Action a_load = new ActionLoad();
    Action a_zoomin = new ActionZoomIn();
    Action a_zoomout = new ActionZoomOut();
    Action a_layout = new ActionLayout();
    Action a_saveas = new ActionSaveAs();
    Action a_viewtoolbar = new ActionViewToolbar();
    Action a_viewstatusbar = new ActionViewStatusbar();
    Action a_networkgenerator = new ActionGenerateNetwork();
    Action a_datagenerator = new ActionGenerateData();
    Action a_datasetter = new ActionSetData();
    Action a_learn = new ActionLearn();
    Action a_learnCPT = new ActionLearnCPT();
    Action a_help = new ActionHelp();
    Action a_about = new ActionAbout();
    ActionAddNode a_addnode = new ActionAddNode();
    Action a_delnode = new ActionDeleteNode();
    Action a_cutnode = new ActionCutNode();
    Action a_copynode = new ActionCopyNode();
    Action a_pastenode = new ActionPasteNode();
    Action a_selectall = new ActionSelectAll();
    Action a_addarc = new ActionAddArc();
    Action a_delarc = new ActionDeleteArc();
    Action a_undo = new ActionUndo();
    Action a_redo = new ActionRedo();
    Action a_alignleft = new ActionAlignLeft();
    Action a_alignright = new ActionAlignRight();
    Action a_aligntop = new ActionAlignTop();
    Action a_alignbottom = new ActionAlignBottom();
    Action a_centerhorizontal = new ActionCenterHorizontal();
    Action a_centervertical = new ActionCenterVertical();
    Action a_spacehorizontal = new ActionSpaceHorizontal();
    Action a_spacevertical = new ActionSpaceVertical();
    int m_nCurrentNode = -1;
    Selection m_Selection = new Selection();
    Rectangle m_nSelectedRect = null;
    ClipBoard m_clipboard = new ClipBoard();

    public GUI() {
        this.m_GraphPanel = new GraphPanel();
        this.m_jScrollPane = new JScrollPane(this.m_GraphPanel);
        this.m_jTfZoom = new JTextField("100%");
        this.m_jTfZoom.setMinimumSize(this.m_jTfZoom.getPreferredSize());
        this.m_jTfZoom.setHorizontalAlignment(0);
        this.m_jTfZoom.setToolTipText("Zoom");
        this.m_jTfZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                try {
                    int n = -1;
                    n = jTextField.getText().indexOf(37);
                    n = n == -1 ? Integer.parseInt(jTextField.getText()) : Integer.parseInt(jTextField.getText().substring(0, n));
                    if (n <= 999) {
                        GUI.this.m_fScale = (double)n / 100.0;
                    }
                    jTextField.setText((int)(GUI.this.m_fScale * 100.0) + "%");
                    if (GUI.this.m_fScale > 0.1) {
                        if (!GUI.this.a_zoomout.isEnabled()) {
                            GUI.this.a_zoomout.setEnabled(true);
                        }
                    } else {
                        GUI.this.a_zoomout.setEnabled(false);
                    }
                    if (GUI.this.m_fScale < 9.99) {
                        if (!GUI.this.a_zoomin.isEnabled()) {
                            GUI.this.a_zoomin.setEnabled(true);
                        }
                    } else {
                        GUI.this.a_zoomin.setEnabled(false);
                    }
                    GUI.this.setAppropriateSize();
                    GUI.this.m_GraphPanel.repaint();
                    GUI.this.m_GraphPanel.invalidate();
                    GUI.this.m_jScrollPane.revalidate();
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(GUI.this.getParent(), "Invalid integer entered for zoom.", "Error", 0);
                    jTextField.setText(GUI.this.m_fScale * 100.0 + "%");
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("ExtraControls"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        jPanel.setPreferredSize(new Dimension(0, 0));
        this.m_jTbTools = new JToolBar();
        this.m_jTbTools.setFloatable(false);
        this.m_jTbTools.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.m_jTbTools.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        this.m_jTbTools.add(this.a_new);
        this.m_jTbTools.add(this.a_save);
        this.m_jTbTools.add(this.a_load);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_cutnode);
        this.m_jTbTools.add(this.a_copynode);
        this.m_jTbTools.add(this.a_pastenode);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_undo);
        this.m_jTbTools.add(this.a_redo);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_alignleft);
        this.m_jTbTools.add(this.a_alignright);
        this.m_jTbTools.add(this.a_aligntop);
        this.m_jTbTools.add(this.a_alignbottom);
        this.m_jTbTools.add(this.a_centerhorizontal);
        this.m_jTbTools.add(this.a_centervertical);
        this.m_jTbTools.add(this.a_spacehorizontal);
        this.m_jTbTools.add(this.a_spacevertical);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_zoomin);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(this.m_jTfZoom.getPreferredSize());
        jPanel2.setMinimumSize(this.m_jTfZoom.getPreferredSize());
        jPanel2.add((Component)this.m_jTfZoom, "Center");
        this.m_jTbTools.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.m_jTbTools.add(this.a_zoomout);
        this.m_jTbTools.addSeparator(new Dimension(2, 2));
        this.m_jTbTools.add(this.a_layout);
        this.m_jTbTools.addSeparator(new Dimension(4, 2));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.m_jStatusBar = new JLabel("Status bar");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_jTbTools, "North");
        this.add((Component)this.m_jScrollPane, "Center");
        this.add((Component)this.m_jStatusBar, "South");
        this.updateStatus();
        this.a_datagenerator.setEnabled(false);
        this.makeMenuBar();
    }

    public JMenuBar getMenuBar() {
        return this.m_menuBar;
    }

    private void makeMenuBar() {
        this.m_menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        this.m_menuBar.add(jMenu);
        jMenu.add(this.a_new);
        jMenu.add(this.a_load);
        jMenu.add(this.a_save);
        jMenu.add(this.a_saveas);
        jMenu.addSeparator();
        jMenu.add(this.a_print);
        jMenu.add(this.a_export);
        jMenu.addSeparator();
        jMenu.add(this.a_quit);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        this.m_menuBar.add(jMenu2);
        jMenu2.add(this.a_undo);
        jMenu2.add(this.a_redo);
        jMenu2.addSeparator();
        jMenu2.add(this.a_selectall);
        jMenu2.add(this.a_delnode);
        jMenu2.add(this.a_cutnode);
        jMenu2.add(this.a_copynode);
        jMenu2.add(this.a_pastenode);
        jMenu2.addSeparator();
        jMenu2.add(this.a_addnode);
        jMenu2.add(this.a_addarc);
        jMenu2.add(this.a_delarc);
        jMenu2.addSeparator();
        jMenu2.add(this.a_alignleft);
        jMenu2.add(this.a_alignright);
        jMenu2.add(this.a_aligntop);
        jMenu2.add(this.a_alignbottom);
        jMenu2.add(this.a_centerhorizontal);
        jMenu2.add(this.a_centervertical);
        jMenu2.add(this.a_spacehorizontal);
        jMenu2.add(this.a_spacevertical);
        JMenu jMenu3 = new JMenu("Tools");
        jMenu3.setMnemonic('T');
        jMenu3.add(this.a_networkgenerator);
        jMenu3.add(this.a_datagenerator);
        jMenu3.add(this.a_datasetter);
        jMenu3.add(this.a_learn);
        jMenu3.add(this.a_learnCPT);
        jMenu3.addSeparator();
        jMenu3.add(this.a_layout);
        jMenu3.addSeparator();
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Show Margins", false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GUI.this.m_bViewMargins;
                GUI.this.m_bViewMargins = jCheckBoxMenuItem.getState();
                if (!bl && jCheckBoxMenuItem.getState()) {
                    GUI.this.updateStatus();
                }
                GUI.this.repaint();
            }
        });
        jMenu3.add(jCheckBoxMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Show Cliques", false);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GUI.this.m_bViewCliques;
                GUI.this.m_bViewCliques = jCheckBoxMenuItem2.getState();
                if (!bl && jCheckBoxMenuItem2.getState()) {
                    GUI.this.updateStatus();
                }
                GUI.this.repaint();
            }
        });
        jMenu3.add(jCheckBoxMenuItem2);
        this.m_menuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu("View");
        jMenu4.setMnemonic('V');
        this.m_menuBar.add(jMenu4);
        jMenu4.add(this.a_zoomin);
        jMenu4.add(this.a_zoomout);
        jMenu4.addSeparator();
        jMenu4.add(this.a_viewtoolbar);
        jMenu4.add(this.a_viewstatusbar);
        JMenu jMenu5 = new JMenu("Help");
        jMenu5.setMnemonic('H');
        this.m_menuBar.add(jMenu5);
        jMenu5.add(this.a_help);
        jMenu5.add(this.a_about);
    }

    protected void setAppropriateNodeSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 50;
        if (n == 0) {
            for (int i = 0; i < this.m_BayesNet.getNrOfNodes(); ++i) {
                int n2 = fontMetrics.stringWidth(this.m_BayesNet.getNodeName(i));
                if (n2 <= n) continue;
                n = n2;
            }
        }
        this.m_nNodeWidth = n + 4;
        this.m_nPaddedNodeWidth = this.m_nNodeWidth + 10;
        this.m_jTfNodeWidth.setText("" + this.m_nNodeWidth);
        this.m_nNodeHeight = 2 * fontMetrics.getHeight();
        this.m_jTfNodeHeight.setText("" + this.m_nNodeHeight);
    }

    public void setAppropriateSize() {
        int n = 0;
        int n2 = 0;
        this.m_GraphPanel.setScale(this.m_fScale, this.m_fScale);
        for (int i = 0; i < this.m_BayesNet.getNrOfNodes(); ++i) {
            int n3 = this.m_BayesNet.getPositionX(i);
            int n4 = this.m_BayesNet.getPositionY(i);
            if (n < n3) {
                n = n3 + 100;
            }
            if (n2 >= n4) continue;
            n2 = n4;
        }
        this.m_GraphPanel.setPreferredSize(new Dimension((int)((double)(n + this.m_nPaddedNodeWidth + 2) * this.m_fScale), (int)((double)(n2 + this.m_nNodeHeight + 2) * this.m_fScale)));
        this.m_GraphPanel.revalidate();
    }

    public void layoutCompleted(LayoutCompleteEvent layoutCompleteEvent) {
        LayoutEngine layoutEngine = this.m_layoutEngine;
        FastVector fastVector = new FastVector(this.m_BayesNet.getNrOfNodes());
        FastVector fastVector2 = new FastVector(this.m_BayesNet.getNrOfNodes());
        for (int i = 0; i < layoutEngine.getNodes().size(); ++i) {
            GraphNode graphNode = (GraphNode)layoutEngine.getNodes().elementAt(i);
            if (graphNode.nodeType != 3) continue;
            fastVector.addElement(graphNode.x);
            fastVector2.addElement(graphNode.y);
        }
        this.m_BayesNet.layoutGraph(fastVector, fastVector2);
        this.m_jStatusBar.setText("Graph layed out");
        this.a_undo.setEnabled(true);
        this.a_redo.setEnabled(false);
        this.setAppropriateSize();
        this.m_GraphPanel.invalidate();
        this.m_jScrollPane.revalidate();
        this.m_GraphPanel.repaint();
    }

    public void readBIFFromFile(String string) throws BIFFormatException, IOException {
        this.m_sFileName = string;
        try {
            BIFReader bIFReader = new BIFReader();
            bIFReader.processFile(string);
            this.m_BayesNet = new EditableBayesNet(bIFReader);
            this.updateStatus();
            this.a_datagenerator.setEnabled(this.m_BayesNet.getNrOfNodes() > 0);
            this.m_BayesNet.clearUndoStack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.setAppropriateNodeSize();
        this.setAppropriateSize();
    }

    void initFromArffFile(String string) {
        try {
            Instances instances = new Instances(new FileReader(string));
            this.m_BayesNet = new EditableBayesNet(instances);
            this.m_Instances = instances;
            this.a_learn.setEnabled(true);
            this.a_learnCPT.setEnabled(true);
            this.setAppropriateNodeSize();
            this.setAppropriateSize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void layoutGraph() {
        if (this.m_BayesNet.getNrOfNodes() == 0) {
            return;
        }
        try {
            FastVector fastVector = new FastVector();
            FastVector fastVector2 = new FastVector();
            BIFParser bIFParser = new BIFParser(this.m_BayesNet.toXMLBIF03(), fastVector, fastVector2);
            bIFParser.parse();
            this.updateStatus();
            this.m_layoutEngine = new HierarchicalBCEngine(fastVector, fastVector2, this.m_nPaddedNodeWidth, this.m_nNodeHeight);
            this.m_layoutEngine.addLayoutCompleteEventListener(this);
            this.m_layoutEngine.layoutGraph();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void updateStatus() {
        this.a_undo.setEnabled(this.m_BayesNet.canUndo());
        this.a_redo.setEnabled(this.m_BayesNet.canRedo());
        this.a_datagenerator.setEnabled(this.m_BayesNet.getNrOfNodes() > 0);
        if (!this.m_bViewMargins && !this.m_bViewCliques) {
            this.repaint();
            return;
        }
        try {
            int n;
            this.m_marginCalculator = new MarginCalculator();
            this.m_marginCalculator.calcMargins(this.m_BayesNet);
            SerializedObject serializedObject = new SerializedObject(this.m_marginCalculator);
            this.m_marginCalculatorWithEvidence = (MarginCalculator)serializedObject.getObject();
            for (n = 0; n < this.m_BayesNet.getNrOfNodes(); ++n) {
                if (this.m_BayesNet.getEvidence(n) < 0) continue;
                this.m_marginCalculatorWithEvidence.setEvidence(n, this.m_BayesNet.getEvidence(n));
            }
            for (n = 0; n < this.m_BayesNet.getNrOfNodes(); ++n) {
                this.m_BayesNet.setMargin(n, this.m_marginCalculatorWithEvidence.getMargin(n));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.repaint();
    }

    void addArcInto(int n) {
        String string = this.m_BayesNet.getNodeName(n);
        try {
            int n2;
            int n3;
            int n4;
            int n5 = this.m_BayesNet.getNrOfNodes();
            boolean[] blArray = new boolean[n5];
            blArray[n] = true;
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    for (n2 = 0; n2 < this.m_BayesNet.getNrOfParents(n3); ++n2) {
                        if (!blArray[this.m_BayesNet.getParent(n3, n2)]) continue;
                        blArray[n3] = true;
                    }
                }
            }
            for (n4 = 0; n4 < this.m_BayesNet.getNrOfParents(n); ++n4) {
                blArray[this.m_BayesNet.getParent((int)n, (int)n4)] = true;
            }
            n4 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                if (blArray[n3]) continue;
                ++n4;
            }
            if (n4 == 0) {
                JOptionPane.showMessageDialog(null, "No potential parents available for this node (" + string + "). Choose another node as child node.");
                return;
            }
            Object[] objectArray = new String[n4];
            n2 = 0;
            for (int i = 0; i < n5; ++i) {
                if (blArray[i]) continue;
                objectArray[n2++] = this.m_BayesNet.getNodeName(i);
            }
            String string2 = (String)JOptionPane.showInputDialog(null, "Select parent node for " + string, "Nodes", 0, null, objectArray, objectArray[0]);
            if (string2 == null || string2.equals("")) {
                return;
            }
            this.m_BayesNet.addArc(string2, string);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
            this.updateStatus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void deleteArc(int n, String string) {
        try {
            this.m_BayesNet.deleteArc(this.m_BayesNet.getNode(string), n);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateStatus();
    }

    void deleteArc(String string, int n) {
        try {
            this.m_BayesNet.deleteArc(n, this.m_BayesNet.getNode(string));
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateStatus();
    }

    void deleteArc(String[] stringArray) {
        String string = (String)JOptionPane.showInputDialog(null, "Select arc to delete", "Arcs", 0, null, stringArray, stringArray[0]);
        if (string != null && !string.equals("")) {
            int n = string.indexOf(" -> ");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 4);
            try {
                this.m_BayesNet.deleteArc(string2, string3);
                this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.updateStatus();
        }
    }

    void renameNode(int n) {
        String string = JOptionPane.showInputDialog(null, this.m_BayesNet.getNodeName(n), "New name for node", 2);
        if (string == null || string.equals("")) {
            return;
        }
        try {
            while (this.m_BayesNet.getNode2(string) >= 0) {
                string = JOptionPane.showInputDialog(null, (Object)("Cannot rename to " + string + ".\nNode with that name already exists."));
                if (string != null && !string.equals("")) continue;
                return;
            }
            this.m_BayesNet.setNodeName(n, string);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.repaint();
    }

    void renameValue(int n, String string) {
        String string2 = JOptionPane.showInputDialog(null, "New name for value " + string, "Node " + this.m_BayesNet.getNodeName(n), 2);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.m_BayesNet.renameNodeValue(n, string, string2);
        this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        this.a_undo.setEnabled(true);
        this.a_redo.setEnabled(false);
        this.repaint();
    }

    void deleteNode(int n) {
        try {
            this.m_BayesNet.deleteNode(n);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateStatus();
    }

    void addValue() {
        String string = "Value" + (this.m_BayesNet.getCardinality(this.m_nCurrentNode) + 1);
        String string2 = JOptionPane.showInputDialog(null, "New value " + string, "Node " + this.m_BayesNet.getNodeName(this.m_nCurrentNode), 2);
        if (string2 == null || string2.equals("")) {
            return;
        }
        try {
            this.m_BayesNet.addNodeValue(this.m_nCurrentNode, string2);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateStatus();
    }

    void delValue(int n, String string) {
        try {
            this.m_BayesNet.delNodeValue(n, string);
            this.m_jStatusBar.setText(this.m_BayesNet.lastActionMsg());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateStatus();
    }

    void editCPT(int n) {
        Object object;
        Object object2;
        JComponent jComponent;
        Serializable serializable;
        this.m_nCurrentNode = n;
        final GraphVisualizerTableModel graphVisualizerTableModel = new GraphVisualizerTableModel(n);
        JTable jTable = new JTable(graphVisualizerTableModel);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        int n2 = this.m_BayesNet.getNrOfParents(n);
        if (n2 > 0) {
            JLabel jLabel;
            int n3;
            serializable = new GridBagConstraints();
            jComponent = new JPanel(new GridBagLayout());
            object2 = new int[n2];
            object = new int[n2];
            ((GridBagConstraints)serializable).anchor = 18;
            ((GridBagConstraints)serializable).fill = 2;
            ((GridBagConstraints)serializable).insets = new Insets(0, 1, 0, 0);
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            block0: do {
                int n6;
                ((GridBagConstraints)serializable).gridwidth = 1;
                for (n3 = 0; n3 < n2; ++n3) {
                    n6 = this.m_BayesNet.getParent(n, n3);
                    jLabel = new JLabel(this.m_BayesNet.getValueName(n6, object2[n3]));
                    jLabel.setFont(new Font("Dialog", 0, 12));
                    jLabel.setOpaque(true);
                    jLabel.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
                    jLabel.setHorizontalAlignment(0);
                    if (bl) {
                        jLabel.setBackground(jLabel.getBackground().darker());
                        jLabel.setForeground(Color.white);
                    } else {
                        jLabel.setForeground(Color.black);
                    }
                    n5 = jLabel.getPreferredSize().width;
                    jLabel.setPreferredSize(new Dimension(n5, jTable.getRowHeight()));
                    if (object[n3] < n5) {
                        object[n3] = n5;
                    }
                    n5 = 0;
                    if (n3 == n2 - 1) {
                        ((GridBagConstraints)serializable).gridwidth = 0;
                        bl = !bl;
                    }
                    jComponent.add((Component)jLabel, serializable);
                    ++n4;
                }
                for (n3 = n2 - 1; n3 >= 0; --n3) {
                    n6 = this.m_BayesNet.getParent(this.m_nCurrentNode, n3);
                    if (object2[n3] != this.m_BayesNet.getCardinality(n6) - 1 || n3 == 0) {
                        int n7 = n3;
                        object2[n7] = object2[n7] + 1;
                        continue block0;
                    }
                    object2[n3] = 0;
                }
            } while (object2[0] != this.m_BayesNet.getCardinality(n3 = this.m_BayesNet.getParent(this.m_nCurrentNode, 0)));
            JLabel jLabel2 = (JLabel)jComponent.getComponent(n4 - 1);
            jComponent.remove(n4 - 1);
            jLabel2.setPreferredSize(new Dimension(jLabel2.getPreferredSize().width, jTable.getRowHeight()));
            ((GridBagConstraints)serializable).gridwidth = 0;
            ((GridBagConstraints)serializable).weighty = 1.0;
            jComponent.add((Component)jLabel2, serializable);
            ((GridBagConstraints)serializable).weighty = 0.0;
            ((GridBagConstraints)serializable).gridwidth = 1;
            JPanel jPanel = new JPanel(new GridBagLayout());
            for (int i = 0; i < n2; ++i) {
                JLabel jLabel3 = new JLabel(this.m_BayesNet.getNodeName(this.m_BayesNet.getParent(n, i)));
                jLabel3.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 1));
                Dimension dimension = jLabel3.getPreferredSize();
                if (dimension.width < object[i]) {
                    jLabel3.setPreferredSize(new Dimension((int)object[i], dimension.height));
                    jLabel3.setHorizontalAlignment(0);
                    jLabel3.setMinimumSize(new Dimension((int)object[i], dimension.height));
                } else if (dimension.width > object[i]) {
                    jLabel = (JLabel)jComponent.getComponent(i);
                    jLabel.setPreferredSize(new Dimension(dimension.width, jLabel.getPreferredSize().height));
                }
                jPanel.add((Component)jLabel3, serializable);
            }
            jScrollPane.setRowHeaderView(jComponent);
            jScrollPane.setCorner("UPPER_LEFT_CORNER", jPanel);
        }
        serializable = new JDialog((Frame)this.getTopLevelAncestor(), "Probability Distribution Table For " + this.m_BayesNet.getNodeName(n), true);
        ((Window)serializable).setSize(500, 400);
        ((Window)serializable).setLocation(this.getLocation().x + this.getWidth() / 2 - 250, this.getLocation().y + this.getHeight() / 2 - 200);
        ((JDialog)serializable).getContentPane().setLayout(new BorderLayout());
        ((JDialog)serializable).getContentPane().add((Component)jScrollPane, "Center");
        jComponent = new JButton("Randomize");
        ((AbstractButton)jComponent).setMnemonic('R');
        ((AbstractButton)jComponent).addActionListener(new ActionListener((JDialog)serializable){
            final /* synthetic */ JDialog val$dlg;
            {
                this.val$dlg = jDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                graphVisualizerTableModel.randomize();
                this.val$dlg.repaint();
            }
        });
        object2 = new JButton("Ok");
        ((AbstractButton)object2).setMnemonic('O');
        ((AbstractButton)object2).addActionListener(new ActionListener((JDialog)serializable){
            final /* synthetic */ JDialog val$dlg;
            {
                this.val$dlg = jDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                graphVisualizerTableModel.setData();
                try {
                    GUI.this.m_BayesNet.setDistribution(GUI.this.m_nCurrentNode, graphVisualizerTableModel.m_fProbs);
                    GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                    GUI.this.updateStatus();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.val$dlg.setVisible(false);
            }
        });
        object = new JButton("Cancel");
        ((AbstractButton)object).setMnemonic('C');
        ((AbstractButton)object).addActionListener(new ActionListener((JDialog)serializable){
            final /* synthetic */ JDialog val$dlg;
            {
                this.val$dlg = jDialog;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.val$dlg.setVisible(false);
            }
        });
        Container container = new Container();
        container.setLayout(new GridBagLayout());
        container.add(jComponent);
        container.add((Component)object2);
        container.add((Component)object);
        ((JDialog)serializable).getContentPane().add((Component)container, "South");
        ((Dialog)serializable).setVisible(true);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Bayes Network Editor");
        GUI gUI = new GUI();
        JMenuBar jMenuBar = gUI.getMenuBar();
        if (stringArray.length > 0) {
            try {
                gUI.readBIFFromFile(stringArray[0]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (BIFFormatException bIFFormatException) {
                bIFFormatException.printStackTrace();
                System.exit(-1);
            }
        }
        jFrame.setJMenuBar(jMenuBar);
        jFrame.getContentPane().add(gUI);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(800, 600);
        jFrame.setVisible(true);
        gUI.m_Selection.updateGUI();
        GenericObjectEditor.registerEditors();
    }

    private class GraphVisualizerMouseMotionListener
    extends MouseMotionAdapter {
        int m_nLastNode = -1;
        int m_nPosX;
        int m_nPosY;

        private GraphVisualizerMouseMotionListener() {
        }

        int getGraphNode(MouseEvent mouseEvent) {
            this.m_nPosY = 0;
            this.m_nPosX = 0;
            Rectangle rectangle = new Rectangle(0, 0, (int)((double)GUI.this.m_nPaddedNodeWidth * GUI.this.m_fScale), (int)((double)GUI.this.m_nNodeHeight * GUI.this.m_fScale));
            this.m_nPosX += mouseEvent.getX();
            this.m_nPosY += mouseEvent.getY();
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                rectangle.x = (int)((double)GUI.this.m_BayesNet.getPositionX(i) * GUI.this.m_fScale);
                rectangle.y = (int)((double)GUI.this.m_BayesNet.getPositionY(i) * GUI.this.m_fScale);
                if (!rectangle.contains(this.m_nPosX, this.m_nPosY)) continue;
                return i;
            }
            return -1;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (GUI.this.m_nSelectedRect != null) {
                GUI.this.m_nSelectedRect.width = mouseEvent.getPoint().x - GUI.this.m_nSelectedRect.x;
                GUI.this.m_nSelectedRect.height = mouseEvent.getPoint().y - GUI.this.m_nSelectedRect.y;
                GUI.this.repaint();
                return;
            }
            int n = this.getGraphNode(mouseEvent);
            if (n >= 0) {
                if (GUI.this.m_Selection.getSelected().size() > 0) {
                    if (GUI.this.m_Selection.getSelected().contains(n)) {
                        GUI.this.m_BayesNet.setPosition(n, (int)((double)this.m_nPosX / GUI.this.m_fScale - (double)(GUI.this.m_nPaddedNodeWidth / 2)), (int)((double)this.m_nPosY / GUI.this.m_fScale - (double)(GUI.this.m_nNodeHeight / 2)), GUI.this.m_Selection.getSelected());
                    } else {
                        GUI.this.m_Selection.clear();
                        GUI.this.m_BayesNet.setPosition(n, (int)((double)this.m_nPosX / GUI.this.m_fScale - (double)(GUI.this.m_nPaddedNodeWidth / 2)), (int)((double)this.m_nPosY / GUI.this.m_fScale - (double)(GUI.this.m_nNodeHeight / 2)));
                    }
                    GUI.this.repaint();
                } else {
                    GUI.this.m_BayesNet.setPosition(n, (int)((double)this.m_nPosX / GUI.this.m_fScale - (double)(GUI.this.m_nPaddedNodeWidth / 2)), (int)((double)this.m_nPosY / GUI.this.m_fScale - (double)(GUI.this.m_nNodeHeight / 2)));
                }
                GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                GUI.this.a_undo.setEnabled(true);
                GUI.this.a_redo.setEnabled(false);
                GUI.this.m_GraphPanel.highLight(n);
            }
            if (n < 0) {
                if (this.m_nLastNode >= 0) {
                    GUI.this.m_GraphPanel.repaint();
                    this.m_nLastNode = -1;
                } else {
                    GUI.this.m_nSelectedRect = new Rectangle(mouseEvent.getPoint().x, mouseEvent.getPoint().y, 1, 1);
                    GUI.this.m_GraphPanel.repaint();
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.getGraphNode(mouseEvent);
            if (n >= 0 && n != this.m_nLastNode) {
                GUI.this.m_GraphPanel.highLight(n);
                if (this.m_nLastNode >= 0) {
                    GUI.this.m_GraphPanel.highLight(this.m_nLastNode);
                }
                this.m_nLastNode = n;
            }
            if (n < 0 && this.m_nLastNode >= 0) {
                GUI.this.m_GraphPanel.repaint();
                this.m_nLastNode = -1;
            }
        }
    }

    private class GraphVisualizerMouseListener
    extends MouseAdapter {
        int m_nPosX = 0;
        int m_nPosY = 0;

        private GraphVisualizerMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Rectangle rectangle = new Rectangle(0, 0, (int)((double)GUI.this.m_nPaddedNodeWidth * GUI.this.m_fScale), (int)((double)GUI.this.m_nNodeHeight * GUI.this.m_fScale));
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                rectangle.x = (int)((double)GUI.this.m_BayesNet.getPositionX(i) * GUI.this.m_fScale);
                rectangle.y = (int)((double)GUI.this.m_BayesNet.getPositionY(i) * GUI.this.m_fScale);
                if (!rectangle.contains(n, n2)) continue;
                GUI.this.m_nCurrentNode = i;
                if (mouseEvent.getButton() == 3) {
                    this.handleRightNodeClick(mouseEvent);
                }
                if (mouseEvent.getButton() == 1) {
                    if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                        GUI.this.m_Selection.toggleSelection(GUI.this.m_nCurrentNode);
                    } else if ((mouseEvent.getModifiersEx() & 0x40) != 0) {
                        GUI.this.m_Selection.addToSelection(GUI.this.m_nCurrentNode);
                    } else {
                        GUI.this.m_Selection.clear();
                        GUI.this.m_Selection.addToSelection(GUI.this.m_nCurrentNode);
                    }
                    GUI.this.repaint();
                }
                return;
            }
            if (mouseEvent.getButton() == 3) {
                this.handleRightClick(mouseEvent, (int)((double)n / GUI.this.m_fScale), (int)((double)n2 / GUI.this.m_fScale));
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (GUI.this.m_nSelectedRect != null) {
                if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                    GUI.this.m_Selection.toggleSelection(GUI.this.m_nSelectedRect);
                } else if ((mouseEvent.getModifiersEx() & 0x40) != 0) {
                    GUI.this.m_Selection.addToSelection(GUI.this.m_nSelectedRect);
                } else {
                    GUI.this.m_Selection.clear();
                    GUI.this.m_Selection.addToSelection(GUI.this.m_nSelectedRect);
                }
                GUI.this.m_nSelectedRect = null;
                GUI.this.repaint();
            }
        }

        void handleRightClick(MouseEvent mouseEvent, int n, int n2) {
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("Add node")) {
                        GUI.this.a_addnode.addNode(GraphVisualizerMouseListener.this.m_nPosX, GraphVisualizerMouseListener.this.m_nPosY);
                        return;
                    }
                    GUI.this.repaint();
                }
            };
            JPopupMenu jPopupMenu = new JPopupMenu("Choose a value");
            JMenuItem jMenuItem = new JMenuItem("Add node");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            FastVector fastVector = GUI.this.m_Selection.getSelected();
            JMenu jMenu = new JMenu("Add parent");
            jPopupMenu.add(jMenu);
            if (fastVector.size() == 0) {
                jMenu.setEnabled(false);
            } else {
                int n3;
                int n4;
                int n5;
                int n6 = GUI.this.m_BayesNet.getNrOfNodes();
                boolean[] blArray = new boolean[n6];
                for (n5 = 0; n5 < fastVector.size(); ++n5) {
                    blArray[((Integer)fastVector.elementAt((int)n5)).intValue()] = true;
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    for (n4 = 0; n4 < n6; ++n4) {
                        for (n3 = 0; n3 < GUI.this.m_BayesNet.getNrOfParents(n4); ++n3) {
                            if (!blArray[GUI.this.m_BayesNet.getParent(n4, n3)]) continue;
                            blArray[n4] = true;
                        }
                    }
                }
                for (n5 = 0; n5 < fastVector.size(); ++n5) {
                    n4 = (Integer)fastVector.elementAt(n5);
                    for (n3 = 0; n3 < GUI.this.m_BayesNet.getNrOfParents(n4); ++n3) {
                        blArray[GUI.this.m_BayesNet.getParent((int)n4, (int)n3)] = true;
                    }
                }
                ActionListener actionListener2 = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            GUI.this.m_BayesNet.addArc(actionEvent.getActionCommand(), GUI.this.m_Selection.getSelected());
                            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                            GUI.this.updateStatus();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                };
                n4 = 0;
                for (n3 = 0; n3 < n6; ++n3) {
                    if (blArray[n3]) continue;
                    JMenuItem jMenuItem2 = new JMenuItem(GUI.this.m_BayesNet.getNodeName(n3));
                    jMenuItem2.addActionListener(actionListener2);
                    jMenu.add(jMenuItem2);
                    ++n4;
                }
                if (n4 == 0) {
                    jMenu.setEnabled(false);
                }
            }
            this.m_nPosX = n;
            this.m_nPosY = n2;
            jPopupMenu.setLocation(mouseEvent.getX(), mouseEvent.getY());
            jPopupMenu.show(GUI.this.m_GraphPanel, mouseEvent.getX(), mouseEvent.getY());
        }

        void handleRightNodeClick(MouseEvent mouseEvent) {
            GUI.this.m_Selection.clear();
            GUI.this.repaint();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GUI.this.renameValue(GUI.this.m_nCurrentNode, actionEvent.getActionCommand());
                }
            };
            ActionListener actionListener2 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GUI.this.delValue(GUI.this.m_nCurrentNode, actionEvent.getActionCommand());
                }
            };
            ActionListener actionListener3 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        GUI.this.m_BayesNet.addArc(actionEvent.getActionCommand(), GUI.this.m_BayesNet.getNodeName(GUI.this.m_nCurrentNode));
                        GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                        GUI.this.updateStatus();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            ActionListener actionListener4 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GUI.this.deleteArc(GUI.this.m_nCurrentNode, actionEvent.getActionCommand());
                }
            };
            ActionListener actionListener5 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GUI.this.deleteArc(actionEvent.getActionCommand(), GUI.this.m_nCurrentNode);
                }
            };
            ActionListener actionListener6 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        int n;
                        String[] stringArray = GUI.this.m_BayesNet.getValues(GUI.this.m_nCurrentNode);
                        for (n = 0; n < stringArray.length && !stringArray[n].equals(actionEvent.getActionCommand()); ++n) {
                        }
                        if (n == stringArray.length) {
                            n = -1;
                        }
                        if (n < stringArray.length) {
                            GUI.this.m_jStatusBar.setText("Set evidence for " + GUI.this.m_BayesNet.getNodeName(GUI.this.m_nCurrentNode));
                            if (GUI.this.m_BayesNet.getEvidence(GUI.this.m_nCurrentNode) < 0 && n >= 0) {
                                GUI.this.m_BayesNet.setEvidence(GUI.this.m_nCurrentNode, n);
                                GUI.this.m_marginCalculatorWithEvidence.setEvidence(GUI.this.m_nCurrentNode, n);
                            } else {
                                GUI.this.m_BayesNet.setEvidence(GUI.this.m_nCurrentNode, n);
                                SerializedObject serializedObject = new SerializedObject(GUI.this.m_marginCalculator);
                                GUI.this.m_marginCalculatorWithEvidence = (MarginCalculator)serializedObject.getObject();
                                for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                                    if (GUI.this.m_BayesNet.getEvidence(i) < 0) continue;
                                    GUI.this.m_marginCalculatorWithEvidence.setEvidence(i, GUI.this.m_BayesNet.getEvidence(i));
                                }
                            }
                            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                                GUI.this.m_BayesNet.setMargin(i, GUI.this.m_marginCalculatorWithEvidence.getMargin(i));
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    GUI.this.repaint();
                }
            };
            ActionListener actionListener7 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand().equals("Rename")) {
                        GUI.this.renameNode(GUI.this.m_nCurrentNode);
                        return;
                    }
                    if (actionEvent.getActionCommand().equals("Add parent")) {
                        GUI.this.addArcInto(GUI.this.m_nCurrentNode);
                        return;
                    }
                    if (actionEvent.getActionCommand().equals("Add value")) {
                        GUI.this.addValue();
                        return;
                    }
                    if (actionEvent.getActionCommand().equals("Delete node")) {
                        GUI.this.deleteNode(GUI.this.m_nCurrentNode);
                        return;
                    }
                    if (actionEvent.getActionCommand().equals("Edit CPT")) {
                        GUI.this.editCPT(GUI.this.m_nCurrentNode);
                        return;
                    }
                    GUI.this.repaint();
                }
            };
            try {
                int n;
                int n2;
                int n3;
                JMenuItem jMenuItem;
                JPopupMenu jPopupMenu = new JPopupMenu("Choose a value");
                JMenu jMenu = new JMenu("Set evidence");
                String[] stringArray = GUI.this.m_BayesNet.getValues(GUI.this.m_nCurrentNode);
                for (int i = 0; i < stringArray.length; ++i) {
                    jMenuItem = new JMenuItem(stringArray[i]);
                    jMenuItem.addActionListener(actionListener6);
                    jMenu.add(jMenuItem);
                }
                jMenu.addSeparator();
                JMenuItem jMenuItem2 = new JMenuItem("Clear");
                jMenuItem2.addActionListener(actionListener6);
                jMenu.add(jMenuItem2);
                jPopupMenu.add(jMenu);
                jMenu.setEnabled(GUI.this.m_bViewMargins);
                jPopupMenu.addSeparator();
                jMenuItem = new JMenuItem("Rename");
                jMenuItem.addActionListener(actionListener7);
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem3 = new JMenuItem("Delete node");
                jMenuItem3.addActionListener(actionListener7);
                jPopupMenu.add(jMenuItem3);
                JMenuItem jMenuItem4 = new JMenuItem("Edit CPT");
                jMenuItem4.addActionListener(actionListener7);
                jPopupMenu.add(jMenuItem4);
                jPopupMenu.addSeparator();
                JMenu jMenu2 = new JMenu("Add parent");
                jPopupMenu.add(jMenu2);
                int n4 = GUI.this.m_BayesNet.getNrOfNodes();
                boolean[] blArray = new boolean[n4];
                blArray[GUI.this.m_nCurrentNode] = true;
                for (n3 = 0; n3 < n4; ++n3) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        for (n = 0; n < GUI.this.m_BayesNet.getNrOfParents(n2); ++n) {
                            if (!blArray[GUI.this.m_BayesNet.getParent(n2, n)]) continue;
                            blArray[n2] = true;
                        }
                    }
                }
                for (n3 = 0; n3 < GUI.this.m_BayesNet.getNrOfParents(GUI.this.m_nCurrentNode); ++n3) {
                    blArray[GUI.this.m_BayesNet.getParent((int)GUI.this.m_nCurrentNode, (int)n3)] = true;
                }
                n3 = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    if (blArray[n2]) continue;
                    jMenuItem2 = new JMenuItem(GUI.this.m_BayesNet.getNodeName(n2));
                    jMenuItem2.addActionListener(actionListener3);
                    jMenu2.add(jMenuItem2);
                    ++n3;
                }
                if (n3 == 0) {
                    jMenu2.setEnabled(false);
                }
                JMenu jMenu3 = new JMenu("Delete parent");
                jPopupMenu.add(jMenu3);
                if (GUI.this.m_BayesNet.getNrOfParents(GUI.this.m_nCurrentNode) == 0) {
                    jMenu3.setEnabled(false);
                }
                for (n = 0; n < GUI.this.m_BayesNet.getNrOfParents(GUI.this.m_nCurrentNode); ++n) {
                    jMenuItem2 = new JMenuItem(GUI.this.m_BayesNet.getNodeName(GUI.this.m_BayesNet.getParent(GUI.this.m_nCurrentNode, n)));
                    jMenuItem2.addActionListener(actionListener4);
                    jMenu3.add(jMenuItem2);
                }
                JMenu jMenu4 = new JMenu("Delete child");
                jPopupMenu.add(jMenu4);
                FastVector fastVector = GUI.this.m_BayesNet.getChildren(GUI.this.m_nCurrentNode);
                if (fastVector.size() == 0) {
                    jMenu4.setEnabled(false);
                }
                for (int i = 0; i < fastVector.size(); ++i) {
                    jMenuItem2 = new JMenuItem(GUI.this.m_BayesNet.getNodeName((Integer)fastVector.elementAt(i)));
                    jMenuItem2.addActionListener(actionListener5);
                    jMenu4.add(jMenuItem2);
                }
                jPopupMenu.addSeparator();
                JMenuItem jMenuItem5 = new JMenuItem("Add value");
                jMenuItem5.addActionListener(actionListener7);
                jPopupMenu.add(jMenuItem5);
                JMenu jMenu5 = new JMenu("Rename value");
                jPopupMenu.add(jMenu5);
                for (int i = 0; i < stringArray.length; ++i) {
                    jMenuItem2 = new JMenuItem(stringArray[i]);
                    jMenuItem2.addActionListener(actionListener);
                    jMenu5.add(jMenuItem2);
                }
                JMenu jMenu6 = new JMenu("Delete value");
                jPopupMenu.add(jMenu6);
                if (GUI.this.m_BayesNet.getCardinality(GUI.this.m_nCurrentNode) <= 2) {
                    jMenu6.setEnabled(false);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    JMenuItem jMenuItem6 = new JMenuItem(stringArray[i]);
                    jMenuItem6.addActionListener(actionListener2);
                    jMenu6.add(jMenuItem6);
                }
                jPopupMenu.setLocation(mouseEvent.getX(), mouseEvent.getY());
                jPopupMenu.show(GUI.this.m_GraphPanel, mouseEvent.getX(), mouseEvent.getY());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class GraphVisualizerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4789813491347366596L;
        final String[] m_sColumnNames;
        final double[][] m_fProbs;
        int m_iNode;

        public GraphVisualizerTableModel(int n) {
            this.m_iNode = n;
            double[][] dArray = GUI.this.m_BayesNet.getDistribution(n);
            this.m_fProbs = new double[dArray.length][dArray[0].length];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    this.m_fProbs[i][j] = dArray[i][j];
                }
            }
            this.m_sColumnNames = GUI.this.m_BayesNet.getValues(n);
        }

        public void randomize() {
            int n = this.m_fProbs[0].length;
            Random random = new Random();
            for (int i = 0; i < this.m_fProbs.length; ++i) {
                int n2;
                for (n2 = 0; n2 < n - 1; ++n2) {
                    this.m_fProbs[i][n2] = random.nextDouble();
                }
                for (n2 = 0; n2 < n - 1; ++n2) {
                    for (int j = n2 + 1; j < n - 1; ++j) {
                        if (!(this.m_fProbs[i][n2] > this.m_fProbs[i][j])) continue;
                        double d = this.m_fProbs[i][n2];
                        this.m_fProbs[i][n2] = this.m_fProbs[i][j];
                        this.m_fProbs[i][j] = d;
                    }
                }
                double d = this.m_fProbs[i][0];
                for (int j = 1; j < n - 1; ++j) {
                    this.m_fProbs[i][j] = this.m_fProbs[i][j] - d;
                    d += this.m_fProbs[i][j];
                }
                this.m_fProbs[i][n - 1] = 1.0 - d;
            }
        }

        public void setData() {
        }

        public int getColumnCount() {
            return this.m_sColumnNames.length;
        }

        public int getRowCount() {
            return this.m_fProbs.length;
        }

        public String getColumnName(int n) {
            return this.m_sColumnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return new Double(this.m_fProbs[n][n2]);
        }

        public void setValueAt(Object object, int n, int n2) {
            int n3;
            Double d = (Double)object;
            if (d < 0.0 || d > 1.0) {
                return;
            }
            this.m_fProbs[n][n2] = d;
            double d2 = 0.0;
            for (n3 = 0; n3 < this.m_fProbs[n].length; ++n3) {
                d2 += this.m_fProbs[n][n3];
            }
            if (d2 > 1.0) {
                n3 = this.m_fProbs[n].length - 1;
                while (d2 > 1.0) {
                    if (n3 != n2) {
                        if (this.m_fProbs[n][n3] > d2 - 1.0) {
                            double[] dArray = this.m_fProbs[n];
                            int n4 = n3;
                            dArray[n4] = dArray[n4] - (d2 - 1.0);
                            d2 = 1.0;
                        } else {
                            d2 -= this.m_fProbs[n][n3];
                            this.m_fProbs[n][n3] = 0.0;
                        }
                    }
                    --n3;
                }
            } else {
                n3 = this.m_fProbs[n].length - 1;
                while (d2 < 1.0) {
                    if (n3 != n2) {
                        double[] dArray = this.m_fProbs[n];
                        int n5 = n3;
                        dArray[n5] = dArray[n5] + (1.0 - d2);
                        d2 = 1.0;
                    }
                    --n3;
                }
            }
            GUI.this.validate();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    private class GraphPanel
    extends PrintablePanel
    implements Printable {
        private static final long serialVersionUID = -3562813603236753173L;
        static final int HIGHLIGHTED = 1;
        static final int NORMAL = 0;
        int m_nClique = 1;

        public GraphPanel() {
            this.addMouseListener(new GraphVisualizerMouseListener());
            this.addMouseMotionListener(new GraphVisualizerMouseMotionListener());
            this.setToolTipText("");
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = 0;
            int n2 = 0;
            Rectangle rectangle = new Rectangle(0, 0, (int)((double)GUI.this.m_nPaddedNodeWidth * GUI.this.m_fScale), (int)((double)GUI.this.m_nNodeHeight * GUI.this.m_fScale));
            n2 += mouseEvent.getX();
            n += mouseEvent.getY();
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                rectangle.x = (int)((double)GUI.this.m_BayesNet.getPositionX(i) * GUI.this.m_fScale);
                rectangle.y = (int)((double)GUI.this.m_BayesNet.getPositionY(i) * GUI.this.m_fScale);
                if (!rectangle.contains(n2, n)) continue;
                return GUI.this.m_BayesNet.getNodeName(i) + " (right click to manipulate this node)";
            }
            return null;
        }

        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.scale(GUI.this.m_fScale, GUI.this.m_fScale);
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (GUI.this.m_bViewCliques) {
                this.m_nClique = 1;
                this.viewCliques(graphics2D, GUI.this.m_marginCalculator.m_root);
            }
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                this.drawNode(graphics2D, i, 0);
            }
            if (!GUI.this.a_export.isExporting() && !GUI.this.a_print.isPrinting()) {
                GUI.this.m_Selection.draw(graphics2D);
            }
            if (GUI.this.m_nSelectedRect != null) {
                graphics2D.drawRect((int)((double)GUI.this.m_nSelectedRect.x / GUI.this.m_fScale), (int)((double)GUI.this.m_nSelectedRect.y / GUI.this.m_fScale), (int)((double)GUI.this.m_nSelectedRect.width / GUI.this.m_fScale), (int)((double)GUI.this.m_nSelectedRect.height / GUI.this.m_fScale));
            }
        }

        void viewCliques(Graphics graphics, MarginCalculator.JunctionTreeNode junctionTreeNode) {
            int n;
            int[] nArray = junctionTreeNode.m_nNodes;
            graphics.setColor(new Color(this.m_nClique % 7 * 256 / 7, this.m_nClique % 2 * 256 / 2, this.m_nClique % 3 * 256 / 3));
            int n2 = GUI.this.m_nPaddedNodeWidth / 2 + this.m_nClique;
            int n3 = GUI.this.m_nNodeHeight / 2;
            int n4 = 0;
            int n5 = 0;
            String string = "";
            for (n = 0; n < nArray.length; ++n) {
                n4 += GUI.this.m_BayesNet.getPositionX(nArray[n]);
                n5 += GUI.this.m_BayesNet.getPositionY(nArray[n]);
                string = string + " " + nArray[n];
                for (int i = n + 1; i < nArray.length; ++i) {
                    graphics.drawLine(GUI.this.m_BayesNet.getPositionX(nArray[n]) + n2, GUI.this.m_BayesNet.getPositionY(nArray[n]) + n3, GUI.this.m_BayesNet.getPositionX(nArray[i]) + n2, GUI.this.m_BayesNet.getPositionY(nArray[i]) + n3);
                }
            }
            ++this.m_nClique;
            graphics.drawString("Clique " + this.m_nClique + "(" + string + ")", n4 /= nArray.length, n5 /= nArray.length);
            for (n = 0; n < junctionTreeNode.m_children.size(); ++n) {
                this.viewCliques(graphics, (MarginCalculator.JunctionTreeNode)junctionTreeNode.m_children.elementAt(n));
            }
        }

        protected void drawNode(Graphics graphics, int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = GUI.this.m_BayesNet.getPositionX(n);
            int n10 = GUI.this.m_BayesNet.getPositionY(n);
            graphics.setColor(this.getBackground().darker().darker());
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            if (n2 == 1) {
                graphics.setXORMode(Color.green);
            }
            graphics.fillOval(n9 + GUI.this.m_nPaddedNodeWidth - GUI.this.m_nNodeWidth - (GUI.this.m_nPaddedNodeWidth - GUI.this.m_nNodeWidth) / 2, n10, GUI.this.m_nNodeWidth, GUI.this.m_nNodeHeight);
            graphics.setColor(Color.white);
            if (n2 == 1) {
                graphics.setXORMode(Color.red);
            }
            if (fontMetrics.stringWidth(GUI.this.m_BayesNet.getNodeName(n)) <= GUI.this.m_nNodeWidth) {
                graphics.drawString(GUI.this.m_BayesNet.getNodeName(n), n9 + GUI.this.m_nPaddedNodeWidth / 2 - fontMetrics.stringWidth(GUI.this.m_BayesNet.getNodeName(n)) / 2, n10 + GUI.this.m_nNodeHeight / 2 + fontMetrics.getHeight() / 2 - 2);
            } else if (fontMetrics.stringWidth("" + n) <= GUI.this.m_nNodeWidth) {
                graphics.drawString("" + n, n9 + GUI.this.m_nPaddedNodeWidth / 2 - fontMetrics.stringWidth("" + n) / 2, n10 + GUI.this.m_nNodeHeight / 2 + fontMetrics.getHeight() / 2 - 2);
            }
            if (n2 == 1) {
                graphics.setXORMode(Color.green);
            }
            if (GUI.this.m_bViewMargins) {
                if (GUI.this.m_BayesNet.getEvidence(n) < 0) {
                    graphics.setColor(new Color(0, 128, 0));
                } else {
                    graphics.setColor(new Color(128, 0, 0));
                }
                double[] dArray = GUI.this.m_BayesNet.getMargin(n);
                for (n8 = 0; n8 < dArray.length; ++n8) {
                    String string = dArray[n8] + "";
                    if (string.charAt(0) == '0') {
                        string = string.substring(1);
                    }
                    if (string.length() > 5) {
                        string = string.substring(1, 5);
                    }
                    graphics.fillRect(n9 + GUI.this.m_nPaddedNodeWidth, n10 + n8 * 10 + 2, (int)(dArray[n8] * 100.0), 8);
                    graphics.drawString(GUI.this.m_BayesNet.getNodeValue(n, n8) + " " + string, n9 + GUI.this.m_nPaddedNodeWidth + (int)(dArray[n8] * 100.0), n10 + n8 * 10 + 10);
                }
            }
            if (GUI.this.m_bViewCliques) {
                return;
            }
            graphics.setColor(Color.black);
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfParents(n); ++i) {
                n8 = GUI.this.m_BayesNet.getParent(n, i);
                int n11 = n9 + GUI.this.m_nPaddedNodeWidth / 2;
                n7 = n10 + GUI.this.m_nNodeHeight;
                n6 = GUI.this.m_BayesNet.getPositionX(n8);
                n5 = GUI.this.m_BayesNet.getPositionY(n8);
                n4 = n6 + GUI.this.m_nPaddedNodeWidth / 2;
                n3 = n5;
                double d = Math.atan2(((double)(n4 - n11) + 0.0) * (double)GUI.this.m_nNodeHeight, ((double)(n3 - n7) + 0.0) * (double)GUI.this.m_nNodeWidth);
                n11 = (int)((double)(n9 + GUI.this.m_nPaddedNodeWidth / 2) + Math.sin(d) * (double)GUI.this.m_nNodeWidth / 2.0);
                n7 = (int)((double)(n10 + GUI.this.m_nNodeHeight / 2) + Math.cos(d) * (double)GUI.this.m_nNodeHeight / 2.0);
                n4 = (int)((double)(n6 + GUI.this.m_nPaddedNodeWidth / 2) - Math.sin(d) * (double)GUI.this.m_nNodeWidth / 2.0);
                n3 = (int)((double)(n5 + GUI.this.m_nNodeHeight / 2) - Math.cos(d) * (double)GUI.this.m_nNodeHeight / 2.0);
                this.drawArrow(graphics, n4, n3, n11, n7);
            }
            if (n2 == 1) {
                FastVector fastVector = GUI.this.m_BayesNet.getChildren(n);
                for (n8 = 0; n8 < fastVector.size(); ++n8) {
                    int n12 = (Integer)fastVector.elementAt(n8);
                    n7 = n9 + GUI.this.m_nPaddedNodeWidth / 2;
                    n6 = n10;
                    n5 = GUI.this.m_BayesNet.getPositionX(n12);
                    n4 = GUI.this.m_BayesNet.getPositionY(n12);
                    n3 = n5 + GUI.this.m_nPaddedNodeWidth / 2;
                    int n13 = n4 + GUI.this.m_nNodeHeight;
                    double d = Math.atan2(((double)(n3 - n7) + 0.0) * (double)GUI.this.m_nNodeHeight, ((double)(n13 - n6) + 0.0) * (double)GUI.this.m_nNodeWidth);
                    n7 = (int)((double)(n9 + GUI.this.m_nPaddedNodeWidth / 2) + Math.sin(d) * (double)GUI.this.m_nNodeWidth / 2.0);
                    n6 = (int)((double)(n10 + GUI.this.m_nNodeHeight / 2) + Math.cos(d) * (double)GUI.this.m_nNodeHeight / 2.0);
                    n3 = (int)((double)(n5 + GUI.this.m_nPaddedNodeWidth / 2) - Math.sin(d) * (double)GUI.this.m_nNodeWidth / 2.0);
                    n13 = (int)((double)(n4 + GUI.this.m_nNodeHeight / 2) - Math.cos(d) * (double)GUI.this.m_nNodeHeight / 2.0);
                    this.drawArrow(graphics, n7, n6, n3, n13);
                }
            }
        }

        protected void drawArrow(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.drawLine(n, n2, n3, n4);
            if (n == n3) {
                if (n2 < n4) {
                    graphics.drawLine(n3, n4, n3 + 4, n4 - 8);
                    graphics.drawLine(n3, n4, n3 - 4, n4 - 8);
                } else {
                    graphics.drawLine(n3, n4, n3 + 4, n4 + 8);
                    graphics.drawLine(n3, n4, n3 - 4, n4 + 8);
                }
            } else {
                double d;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                int n5 = 0;
                int n6 = 0;
                if (n3 < n) {
                    d3 = n - n3;
                    d2 = Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
                    d = Math.acos(d3 / d2);
                } else {
                    d3 = n - n3;
                    d2 = Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
                    d = Math.acos(d3 / d2);
                }
                double d5 = 0.5235987755982988;
                d2 = 8.0;
                d3 = Math.cos(d - d5) * d2;
                d4 = Math.sin(d - d5) * d2;
                n5 = (int)((double)n3 + d3);
                n6 = n2 < n4 ? (int)((double)n4 - d4) : (int)((double)n4 + d4);
                graphics.drawLine(n3, n4, n5, n6);
                d3 = Math.cos(d + d5) * d2;
                d4 = Math.sin(d + d5) * d2;
                n5 = (int)((double)n3 + d3);
                n6 = n2 < n4 ? (int)((double)n4 - d4) : (int)((double)n4 + d4);
                graphics.drawLine(n3, n4, n5, n6);
            }
        }

        public void highLight(int n) {
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setRenderingHints(renderingHints);
            graphics2D.setPaintMode();
            graphics2D.scale(GUI.this.m_fScale, GUI.this.m_fScale);
            this.drawNode(graphics2D, n, 1);
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n > 0) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double d = pageFormat.getImageableHeight();
            double d2 = pageFormat.getImageableWidth();
            int n2 = 1;
            int n3 = 1;
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                if (n2 < GUI.this.m_BayesNet.getPositionX(i)) {
                    n2 = GUI.this.m_BayesNet.getPositionX(i);
                }
                if (n3 >= GUI.this.m_BayesNet.getPositionY(i)) continue;
                n3 = GUI.this.m_BayesNet.getPositionY(i);
            }
            double d3 = GUI.this.m_fScale;
            if (d2 / (double)(n2 += GUI.this.m_nPaddedNodeWidth + 100) < d / (double)n3) {
                GUI.this.m_fScale = d2 / (double)n2;
            } else {
                GUI.this.m_fScale = d / (double)n3;
            }
            this.paint(graphics2D);
            GUI.this.m_fScale = d3;
            return 0;
        }
    }

    class ActionLayout
    extends MyAction {
        private static final long serialVersionUID = -203891108593551L;
        JDialog dlg;

        public ActionLayout() {
            super("Layout", "Layout Graph", "layout", "ctrl L");
            this.dlg = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dlg == null) {
                this.dlg = new JDialog();
                this.dlg.setTitle("Graph Layout Options");
                final JCheckBox jCheckBox = new JCheckBox("Custom Node Size");
                final JLabel jLabel = new JLabel("Width");
                final JLabel jLabel2 = new JLabel("Height");
                GUI.this.m_jTfNodeWidth.setHorizontalAlignment(0);
                GUI.this.m_jTfNodeWidth.setText("" + GUI.this.m_nNodeWidth);
                GUI.this.m_jTfNodeHeight.setHorizontalAlignment(0);
                GUI.this.m_jTfNodeHeight.setText("" + GUI.this.m_nNodeHeight);
                jLabel.setEnabled(false);
                GUI.this.m_jTfNodeWidth.setEnabled(false);
                jLabel2.setEnabled(false);
                GUI.this.m_jTfNodeHeight.setEnabled(false);
                jCheckBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                            jLabel.setEnabled(true);
                            GUI.this.m_jTfNodeWidth.setEnabled(true);
                            jLabel2.setEnabled(true);
                            GUI.this.m_jTfNodeHeight.setEnabled(true);
                        } else {
                            jLabel.setEnabled(false);
                            GUI.this.m_jTfNodeWidth.setEnabled(false);
                            jLabel2.setEnabled(false);
                            GUI.this.m_jTfNodeHeight.setEnabled(false);
                            GUI.this.setAppropriateSize();
                            GUI.this.setAppropriateNodeSize();
                        }
                    }
                });
                JButton jButton = new JButton("Layout Graph");
                jButton.setMnemonic('L');
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jCheckBox.isSelected()) {
                            int n;
                            int n2;
                            try {
                                n2 = Integer.parseInt(GUI.this.m_jTfNodeWidth.getText());
                            }
                            catch (NumberFormatException numberFormatException) {
                                JOptionPane.showMessageDialog(GUI.this.getParent(), "Invalid integer entered for node width.", "Error", 0);
                                n2 = GUI.this.m_nNodeWidth;
                                GUI.this.m_jTfNodeWidth.setText("" + GUI.this.m_nNodeWidth);
                            }
                            try {
                                n = Integer.parseInt(GUI.this.m_jTfNodeHeight.getText());
                            }
                            catch (NumberFormatException numberFormatException) {
                                JOptionPane.showMessageDialog(GUI.this.getParent(), "Invalid integer entered for node height.", "Error", 0);
                                n = GUI.this.m_nNodeHeight;
                                GUI.this.m_jTfNodeWidth.setText("" + GUI.this.m_nNodeHeight);
                            }
                            if (n2 != GUI.this.m_nNodeWidth || n != GUI.this.m_nNodeHeight) {
                                GUI.this.m_nNodeWidth = n2;
                                GUI.this.m_nPaddedNodeWidth = GUI.this.m_nNodeWidth + 10;
                                GUI.this.m_nNodeHeight = n;
                            }
                        }
                        ActionLayout.this.dlg.setVisible(false);
                        GUI.this.updateStatus();
                        GUI.this.layoutGraph();
                        GUI.this.m_jStatusBar.setText("Laying out Bayes net");
                    }
                });
                JButton jButton2 = new JButton("Cancel");
                jButton2.setMnemonic('C');
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ActionLayout.this.dlg.setVisible(false);
                    }
                });
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.dlg.setLayout(new GridBagLayout());
                Container container = new Container();
                container.setLayout(new GridBagLayout());
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.insets = new Insets(8, 0, 0, 0);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = 0;
                container.add((Component)jCheckBox, gridBagConstraints);
                gridBagConstraints.gridwidth = -1;
                container.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)GUI.this.m_jTfNodeWidth, gridBagConstraints);
                gridBagConstraints.gridwidth = -1;
                container.add((Component)jLabel2, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)GUI.this.m_jTfNodeHeight, gridBagConstraints);
                gridBagConstraints.fill = 2;
                this.dlg.add((Component)container, gridBagConstraints);
                this.dlg.add(jButton);
                gridBagConstraints.gridwidth = 0;
                this.dlg.add(jButton2);
            }
            this.dlg.setLocation(100, 100);
            this.dlg.setVisible(true);
            this.dlg.setSize(this.dlg.getPreferredSize());
            this.dlg.setVisible(false);
            this.dlg.setVisible(true);
            this.dlg.repaint();
        }
    }

    class ActionZoomOut
    extends MyAction {
        private static final long serialVersionUID = -203891108593551L;

        public ActionZoomOut() {
            super("Zoom out", "Zoom out", "zoomout", "-");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            int n2 = (int)(GUI.this.m_fScale * 100.0);
            n = n2 < 300 ? (int)Math.ceil((double)n2 / 25.0) : (n2 < 700 ? 6 + (int)Math.ceil((double)n2 / 50.0) : 13 + (int)Math.ceil((double)n2 / 100.0));
            if (n2 <= 10) {
                this.setEnabled(false);
            } else if (n2 < 999) {
                if (n <= 1) {
                    this.setEnabled(false);
                }
                GUI.this.m_jTfZoom.setText(GUI.this.m_nZoomPercents[n - 1] + "%");
                GUI.this.m_fScale = (double)GUI.this.m_nZoomPercents[n - 1] / 100.0;
            } else {
                if (!GUI.this.a_zoomin.isEnabled()) {
                    GUI.this.a_zoomin.setEnabled(true);
                }
                GUI.this.m_jTfZoom.setText(GUI.this.m_nZoomPercents[22] + "%");
                GUI.this.m_fScale = (double)GUI.this.m_nZoomPercents[22] / 100.0;
            }
            GUI.this.setAppropriateSize();
            GUI.this.m_GraphPanel.repaint();
            GUI.this.m_GraphPanel.invalidate();
            GUI.this.m_jScrollPane.revalidate();
            GUI.this.m_jStatusBar.setText("Zooming out");
        }
    }

    class ActionZoomIn
    extends MyAction {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionZoomIn() {
            super("Zoom in", "Zoom in", "zoomin", "+");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            int n2 = (int)(GUI.this.m_fScale * 100.0);
            n = n2 < 300 ? n2 / 25 : (n2 < 700 ? 6 + n2 / 50 : 13 + n2 / 100);
            if (n2 >= 999) {
                this.setEnabled(false);
                return;
            }
            if (n2 >= 10) {
                if (n >= 22) {
                    this.setEnabled(false);
                }
                if (n2 == 10 && !GUI.this.a_zoomout.isEnabled()) {
                    GUI.this.a_zoomout.setEnabled(true);
                }
                GUI.this.m_jTfZoom.setText(GUI.this.m_nZoomPercents[n + 1] + "%");
                GUI.this.m_fScale = (double)GUI.this.m_nZoomPercents[n + 1] / 100.0;
            } else {
                if (!GUI.this.a_zoomout.isEnabled()) {
                    GUI.this.a_zoomout.setEnabled(true);
                }
                GUI.this.m_jTfZoom.setText(GUI.this.m_nZoomPercents[0] + "%");
                GUI.this.m_fScale = (double)GUI.this.m_nZoomPercents[0] / 100.0;
            }
            GUI.this.setAppropriateSize();
            GUI.this.m_GraphPanel.repaint();
            GUI.this.m_GraphPanel.invalidate();
            GUI.this.m_jScrollPane.revalidate();
            GUI.this.m_jStatusBar.setText("Zooming in");
        }
    }

    class ActionAbout
    extends MyAction {
        private static final long serialVersionUID = -20389110859353L;

        public ActionAbout() {
            super("About", "Help about", "about", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(null, "Bayesian Network Workbench\nPart of Weka\n2007", "About Message", -1);
        }
    }

    class ActionHelp
    extends MyAction {
        private static final long serialVersionUID = -20389110859354L;

        public ActionHelp() {
            super("Help", "Bayesian Network Workbench Help", "help", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JOptionPane.showMessageDialog(null, "See Weka Homepage\nhttp://www.cs.waikato.ac.nz/ml", "Help Message", -1);
        }
    }

    class ActionQuit
    extends ActionSave {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionQuit() {
            super("Exit", "Exit Program", "exit", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GUI.this.m_BayesNet.isChanged()) {
                int n = JOptionPane.showConfirmDialog(null, "Network changed. Do you want to save it?", "Save before closing?", 1);
                if (n == 2) {
                    return;
                }
                if (n == 0 && !this.saveAs()) {
                    return;
                }
            }
            System.exit(0);
        }
    }

    class ActionPrint
    extends ActionSave {
        private static final long serialVersionUID = -20389001859354L;
        boolean m_bIsPrinting;

        public ActionPrint() {
            super("Print", "Print Graph", "print", "ctrl P");
            this.m_bIsPrinting = false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(GUI.this.m_GraphPanel);
            if (printerJob.printDialog()) {
                try {
                    this.m_bIsPrinting = true;
                    printerJob.print();
                    this.m_bIsPrinting = false;
                }
                catch (PrinterException printerException) {
                    GUI.this.m_jStatusBar.setText("Error printing: " + printerException);
                    this.m_bIsPrinting = false;
                }
            }
            GUI.this.m_jStatusBar.setText("Print");
        }

        public boolean isPrinting() {
            return this.m_bIsPrinting;
        }
    }

    class ActionSaveAs
    extends ActionSave {
        private static final long serialVersionUID = -20389110859354L;

        public ActionSaveAs() {
            super("Save As", "Save Graph As", "saveas", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.saveAs();
        }
    }

    class ActionSave
    extends MyAction {
        private static final long serialVersionUID = -20389110859355156L;
        ExtensionFileFilter ef1;

        public ActionSave() {
            super("Save", "Save Graph", "save", "ctrl S");
            this.ef1 = new ExtensionFileFilter(".xml", "XML BIF files");
        }

        public ActionSave(String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
            this.ef1 = new ExtensionFileFilter(".xml", "XML BIF files");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!GUI.this.m_sFileName.equals("")) {
                this.saveFile(GUI.this.m_sFileName);
                GUI.this.m_BayesNet.isSaved();
                GUI.this.m_jStatusBar.setText("Saved as " + GUI.this.m_sFileName);
            } else if (this.saveAs()) {
                GUI.this.m_BayesNet.isSaved();
                GUI.this.m_jStatusBar.setText("Saved as " + GUI.this.m_sFileName);
            }
        }

        boolean saveAs() {
            int n;
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            jFileChooser.addChoosableFileFilter(this.ef1);
            jFileChooser.setDialogTitle("Save Graph As");
            if (!GUI.this.m_sFileName.equals("")) {
                jFileChooser.setSelectedFile(new File(GUI.this.m_sFileName));
            }
            if ((n = jFileChooser.showSaveDialog(GUI.this)) == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                if (!string.endsWith(".xml")) {
                    string = string.concat(".xml");
                }
                this.saveFile(string);
                return true;
            }
            return false;
        }

        protected void saveFile(String string) {
            try {
                FileWriter fileWriter = new FileWriter(string);
                fileWriter.write(GUI.this.m_BayesNet.toXMLBIF03());
                fileWriter.close();
                GUI.this.m_sFileName = string;
                GUI.this.m_jStatusBar.setText("Saved as " + GUI.this.m_sFileName);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    class ActionViewToolbar
    extends MyAction {
        private static final long serialVersionUID = -20389110812354L;

        public ActionViewToolbar() {
            super("View toolbar", "View toolbar", "toolbar", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_jTbTools.setVisible(!GUI.this.m_jTbTools.isVisible());
        }
    }

    class ActionViewStatusbar
    extends MyAction {
        private static final long serialVersionUID = -20389330812354L;

        public ActionViewStatusbar() {
            super("View statusbar", "View statusbar", "statusbar", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_jStatusBar.setVisible(!GUI.this.m_jStatusBar.isVisible());
        }
    }

    class ActionLoad
    extends MyAction {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionLoad() {
            super("Load", "Load Graph", "open", "ctrl O");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(".arff", "ARFF files");
            ExtensionFileFilter extensionFileFilter2 = new ExtensionFileFilter(".xml", "XML BIF files");
            jFileChooser.addChoosableFileFilter(extensionFileFilter);
            jFileChooser.addChoosableFileFilter(extensionFileFilter2);
            jFileChooser.setDialogTitle("Load Graph");
            int n = jFileChooser.showOpenDialog(GUI.this);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                if (string.endsWith(extensionFileFilter.getExtensions()[0])) {
                    GUI.this.initFromArffFile(string);
                } else {
                    try {
                        GUI.this.readBIFFromFile(string);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                GUI.this.m_jStatusBar.setText("Loaded " + string);
                GUI.this.updateStatus();
            }
        }
    }

    class ActionNew
    extends MyAction {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionNew() {
            super("New", "New Network", "new", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_sFileName = "";
            GUI.this.m_BayesNet = new EditableBayesNet(true);
            GUI.this.updateStatus();
            GUI.this.layoutGraph();
            GUI.this.a_datagenerator.setEnabled(false);
            GUI.this.m_BayesNet.clearUndoStack();
            GUI.this.m_jStatusBar.setText("New Network");
            GUI.this.m_Selection = new Selection();
            GUI.this.repaint();
        }
    }

    class ActionDeleteArc
    extends MyAction {
        private static final long serialVersionUID = -2038914085935519L;

        public ActionDeleteArc() {
            super("Delete Arc", "Delete Arc", "delarc", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = 0;
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                n += GUI.this.m_BayesNet.getNrOfParents(i);
            }
            String[] stringArray = new String[n];
            int n2 = 0;
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                for (int j = 0; j < GUI.this.m_BayesNet.getNrOfParents(i); ++j) {
                    int n3 = GUI.this.m_BayesNet.getParent(i, j);
                    String string = GUI.this.m_BayesNet.getNodeName(n3);
                    string = string + " -> ";
                    string = string + GUI.this.m_BayesNet.getNodeName(i);
                    stringArray[n2++] = string;
                }
            }
            GUI.this.deleteArc(stringArray);
        }
    }

    class ActionAddArc
    extends MyAction {
        private static final long serialVersionUID = -2038913085935519L;

        public ActionAddArc() {
            super("Add Arc", "Add Arc", "addarc", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object[] objectArray = new String[GUI.this.m_BayesNet.getNrOfNodes()];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = GUI.this.m_BayesNet.getNodeName(i);
                }
                String string = (String)JOptionPane.showInputDialog(null, "Select child node", "Nodes", 0, null, objectArray, objectArray[0]);
                if (string == null || string.equals("")) {
                    return;
                }
                int n = GUI.this.m_BayesNet.getNode(string);
                GUI.this.addArcInto(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class ActionSpaceVertical
    extends MyAction {
        private static final long serialVersionUID = -838642085935519L;

        public ActionSpaceVertical() {
            super("Space Vertical", "Space Vertical", "spacevertical", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_BayesNet.spaceVertical(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionSpaceHorizontal
    extends MyAction {
        private static final long serialVersionUID = -9738642085935519L;

        public ActionSpaceHorizontal() {
            super("Space Horizontal", "Space Horizontal", "spacehorizontal", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_BayesNet.spaceHorizontal(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionCenterVertical
    extends MyAction {
        private static final long serialVersionUID = -8638642085935519L;

        public ActionCenterVertical() {
            super("Center Vertical", "Center Vertical", "centervertical", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_BayesNet.centerVertical(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionCenterHorizontal
    extends MyAction {
        private static final long serialVersionUID = -7538642085935519L;

        public ActionCenterHorizontal() {
            super("Center Horizontal", "Center Horizontal", "centerhorizontal", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_BayesNet.centerHorizontal(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionAlignBottom
    extends MyAction {
        private static final long serialVersionUID = -6438642085935519L;

        public ActionAlignBottom() {
            super("Align Bottom", "Align Bottom", "alignbottom", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_BayesNet.alignBottom(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionAlignTop
    extends MyAction {
        private static final long serialVersionUID = -5338642085935519L;

        public ActionAlignTop() {
            super("Align Top", "Align Top", "aligntop", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_BayesNet.alignTop(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionAlignRight
    extends MyAction {
        private static final long serialVersionUID = -4238642085935519L;

        public ActionAlignRight() {
            super("Align Right", "Align Right", "alignright", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_BayesNet.alignRight(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionAlignLeft
    extends MyAction {
        private static final long serialVersionUID = -3138642085935519L;

        public ActionAlignLeft() {
            super("Align Left", "Align Left", "alignleft", "");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_BayesNet.alignLeft(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionExport
    extends MyAction {
        boolean m_bIsExporting;
        private static final long serialVersionUID = -3027642085935519L;

        public ActionExport() {
            super("Export", "Export to graphics file", "export", "");
            this.m_bIsExporting = false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_bIsExporting = true;
            GUI.this.m_GraphPanel.saveComponent();
            this.m_bIsExporting = false;
            GUI.this.repaint();
        }

        public boolean isExporting() {
            return this.m_bIsExporting;
        }
    }

    class ActionSelectAll
    extends MyAction {
        private static final long serialVersionUID = -2038642085935519L;

        public ActionSelectAll() {
            super("Select All", "Select All Nodes", "selectall", "ctrl A");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUI.this.m_Selection.selectAll();
            GUI.this.repaint();
        }
    }

    class ActionPasteNode
    extends MyAction {
        private static final long serialVersionUID = -2038732085935519L;

        public ActionPasteNode() {
            super("Paste", "Paste Nodes", "paste", "ctrl V");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GUI.this.m_BayesNet.paste(GUI.this.m_clipboard.getText());
                GUI.this.updateStatus();
                GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public boolean isEnabled() {
            return GUI.this.m_clipboard.hasText();
        }
    }

    class ActionCutNode
    extends ActionCopyNode {
        private static final long serialVersionUID = -2038822085935519L;

        public ActionCutNode() {
            super("Cut", "Cut Nodes", "cut", "ctrl X");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.copy();
            GUI.this.m_BayesNet.deleteSelection(GUI.this.m_Selection.getSelected());
            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
            GUI.this.m_Selection.clear();
            GUI.this.a_undo.setEnabled(true);
            GUI.this.a_redo.setEnabled(false);
            GUI.this.repaint();
        }
    }

    class ActionCopyNode
    extends MyAction {
        private static final long serialVersionUID = -2038732085935519L;

        public ActionCopyNode() {
            super("Copy", "Copy Nodes", "copy", "ctrl C");
        }

        public ActionCopyNode(String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.copy();
        }

        public void copy() {
            String string = GUI.this.m_BayesNet.toXMLBIF03(GUI.this.m_Selection.getSelected());
            GUI.this.m_clipboard.setText(string);
        }
    }

    class ActionDeleteNode
    extends MyAction {
        private static final long serialVersionUID = -2038912085935519L;

        public ActionDeleteNode() {
            super("Delete Node", "Delete Node", "delnode", "DELETE");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GUI.this.m_Selection.getSelected().size() > 0) {
                GUI.this.m_BayesNet.deleteSelection(GUI.this.m_Selection.getSelected());
                GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                GUI.this.m_Selection.clear();
                GUI.this.updateStatus();
                GUI.this.repaint();
            } else {
                Object[] objectArray = new String[GUI.this.m_BayesNet.getNrOfNodes()];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = GUI.this.m_BayesNet.getNodeName(i);
                }
                String string = (String)JOptionPane.showInputDialog(null, "Select node to delete", "Nodes", 0, null, objectArray, objectArray[0]);
                if (string != null && !string.equals("")) {
                    int n = GUI.this.m_BayesNet.getNode2(string);
                    GUI.this.deleteNode(n);
                }
            }
        }
    }

    class ActionAddNode
    extends MyAction {
        private static final long serialVersionUID = -2038910085935519L;
        JDialog dlg;
        JTextField jTfName;
        JTextField jTfCard;
        int m_X;
        int m_Y;

        public ActionAddNode() {
            super("Add Node", "Add Node", "addnode", "");
            this.dlg = null;
            this.jTfName = new JTextField(20);
            this.jTfCard = new JTextField(3);
            this.m_X = Integer.MAX_VALUE;
        }

        public void addNode(int n, int n2) {
            this.m_X = n;
            this.m_Y = n2;
            this.addNode();
        }

        void addNode() {
            if (this.dlg == null) {
                this.dlg = new JDialog();
                this.dlg.setTitle("Add node");
                JLabel jLabel = new JLabel("Name");
                this.jTfName.setHorizontalAlignment(0);
                JLabel jLabel2 = new JLabel("Cardinality");
                this.jTfCard.setHorizontalAlignment(0);
                this.jTfCard.setText("2");
                JButton jButton = new JButton("Cancel");
                jButton.setMnemonic('C');
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ActionAddNode.this.dlg.setVisible(false);
                    }
                });
                JButton jButton2 = new JButton("Ok");
                jButton2.setMnemonic('O');
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = ActionAddNode.this.jTfName.getText();
                        if (string.length() <= 0) {
                            JOptionPane.showMessageDialog(null, "Name should have at least one character");
                            return;
                        }
                        int n = new Integer(ActionAddNode.this.jTfCard.getText());
                        if (n <= 1) {
                            JOptionPane.showMessageDialog(null, "Cardinality should be larger than 1");
                            return;
                        }
                        try {
                            if (ActionAddNode.this.m_X < Integer.MAX_VALUE) {
                                GUI.this.m_BayesNet.addNode(string, n, ActionAddNode.this.m_X, ActionAddNode.this.m_Y);
                            } else {
                                GUI.this.m_BayesNet.addNode(string, n);
                            }
                            GUI.this.m_jStatusBar.setText(GUI.this.m_BayesNet.lastActionMsg());
                            GUI.this.a_undo.setEnabled(true);
                            GUI.this.a_redo.setEnabled(false);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        GUI.this.repaint();
                        ActionAddNode.this.dlg.setVisible(false);
                    }
                });
                this.dlg.setLayout(new GridLayout(3, 2, 10, 10));
                this.dlg.add(jLabel);
                this.dlg.add(this.jTfName);
                this.dlg.add(jLabel2);
                this.dlg.add(this.jTfCard);
                this.dlg.add(jButton2);
                this.dlg.add(jButton);
                this.dlg.setSize(this.dlg.getPreferredSize());
            }
            this.jTfName.setText("Node" + (GUI.this.m_BayesNet.getNrOfNodes() + 1));
            this.dlg.setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.m_X = Integer.MAX_VALUE;
            this.addNode();
        }
    }

    class ActionRedo
    extends MyAction {
        private static final long serialVersionUID = -4038910085935519L;

        public ActionRedo() {
            super("Redo", "Redo", "redo", "ctrl Y");
            this.setEnabled(false);
        }

        public boolean isEnabled() {
            return GUI.this.m_BayesNet.canRedo();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = GUI.this.m_BayesNet.redo();
            GUI.this.m_jStatusBar.setText("Redo action performed: " + string);
            GUI.this.m_Selection.clear();
            GUI.this.updateStatus();
            GUI.this.repaint();
        }
    }

    class ActionUndo
    extends MyAction {
        private static final long serialVersionUID = -3038910085935519L;

        public ActionUndo() {
            super("Undo", "Undo", "undo", "ctrl Z");
            this.setEnabled(false);
        }

        public boolean isEnabled() {
            return GUI.this.m_BayesNet.canUndo();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = GUI.this.m_BayesNet.undo();
            GUI.this.m_jStatusBar.setText("Undo action performed: " + string);
            GUI.this.a_redo.setEnabled(GUI.this.m_BayesNet.canRedo());
            GUI.this.a_undo.setEnabled(GUI.this.m_BayesNet.canUndo());
            GUI.this.m_Selection.clear();
            GUI.this.updateStatus();
            GUI.this.repaint();
        }
    }

    class ActionSetData
    extends MyAction {
        private static final long serialVersionUID = -2038911085935519L;

        public ActionSetData() {
            super("Set Data", "Set Data File", "setdata", "ctrl A");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(".arff", "ARFF files");
            jFileChooser.addChoosableFileFilter(extensionFileFilter);
            jFileChooser.setDialogTitle("Set Data File");
            int n = jFileChooser.showOpenDialog(GUI.this);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().toString();
                try {
                    GUI.this.m_Instances = new Instances(new FileReader(string));
                    GUI.this.m_Instances.setClassIndex(GUI.this.m_Instances.numAttributes() - 1);
                    GUI.this.a_learn.setEnabled(true);
                    GUI.this.a_learnCPT.setEnabled(true);
                    GUI.this.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    class ActionLearnCPT
    extends MyAction {
        private static final long serialVersionUID = -2022211085935516L;

        public ActionLearnCPT() {
            super("Learn CPT", "Learn conditional probability tables", "learncpt", "");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (GUI.this.m_Instances == null) {
                JOptionPane.showMessageDialog(null, "Select instances to learn from first (menu Tools/Set Data)");
                return;
            }
            try {
                GUI.this.m_BayesNet.setData(GUI.this.m_Instances);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Data set is not compatible with network.\n" + exception.getMessage() + "\nChoose other instances (menu Tools/Set Data)");
                return;
            }
            try {
                GUI.this.m_BayesNet.estimateCPTs();
                GUI.this.m_BayesNet.clearUndoStack();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            GUI.this.updateStatus();
        }
    }

    class ActionLearn
    extends MyAction {
        private static final long serialVersionUID = -2038911085935516L;
        JDialog dlg;

        public ActionLearn() {
            super("Learn Network", "Learn Bayesian Network", "learn", "ctrl L");
            this.dlg = null;
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dlg == null) {
                this.dlg = new JDialog();
                this.dlg.setTitle("Learn Bayesian Network");
                JButton jButton = new JButton("Options");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            GenericObjectEditor.registerEditors();
                            GenericObjectEditor genericObjectEditor = new GenericObjectEditor(true);
                            genericObjectEditor.setClassType(Classifier.class);
                            genericObjectEditor.setValue(GUI.this.m_BayesNet);
                            PropertyDialog propertyDialog = PropertyDialog.getParentDialog(GUI.this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(GUI.this), (PropertyEditor)genericObjectEditor, 100, 100) : new PropertyDialog(PropertyDialog.getParentFrame(GUI.this), (PropertyEditor)genericObjectEditor, 100, 100);
                            propertyDialog.addWindowListener(new WindowAdapter(){

                                public void windowClosing(WindowEvent windowEvent) {
                                    PropertyEditor propertyEditor = ((PropertyDialog)windowEvent.getSource()).getEditor();
                                    Object object = propertyEditor.getValue();
                                    String string = "";
                                    if (object instanceof OptionHandler) {
                                        string = Utils.joinOptions(((OptionHandler)object).getOptions());
                                        try {
                                            GUI.this.m_BayesNet.setOptions(((OptionHandler)object).getOptions());
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    }
                                    System.out.println(object.getClass().getName() + " " + string);
                                    System.exit(0);
                                }
                            });
                            propertyDialog.setVisible(true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            System.err.println(exception.getMessage());
                        }
                        GUI.this.m_BayesNet.clearUndoStack();
                        GUI.this.a_undo.setEnabled(false);
                        GUI.this.a_redo.setEnabled(false);
                    }
                });
                JTextField jTextField = new JTextField(40);
                jTextField.setHorizontalAlignment(0);
                jTextField.setText("" + Utils.joinOptions(GUI.this.m_BayesNet.getOptions()));
                JButton jButton2 = new JButton("Learn");
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            GUI.this.m_BayesNet.buildClassifier(GUI.this.m_Instances);
                            GUI.this.layoutGraph();
                            GUI.this.updateStatus();
                            GUI.this.m_BayesNet.clearUndoStack();
                            ActionLearn.this.dlg.setVisible(false);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ActionLearn.this.dlg.setVisible(false);
                    }
                });
                JButton jButton3 = new JButton("Cancel");
                jButton3.setMnemonic('C');
                jButton3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ActionLearn.this.dlg.setVisible(false);
                    }
                });
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.dlg.setLayout(new GridBagLayout());
                Container container = new Container();
                container.setLayout(new GridBagLayout());
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.insets = new Insets(8, 0, 0, 0);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.fill = 2;
                container.add((Component)jButton, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)jTextField, gridBagConstraints);
                gridBagConstraints.fill = 2;
                this.dlg.add((Component)container, gridBagConstraints);
                this.dlg.add(jButton2);
                gridBagConstraints.gridwidth = 0;
                this.dlg.add(jButton3);
            }
            this.dlg.setLocation(100, 100);
            this.dlg.setVisible(true);
            this.dlg.setSize(this.dlg.getPreferredSize());
            this.dlg.setVisible(false);
            this.dlg.setVisible(true);
            this.dlg.repaint();
        }
    }

    class ActionGenerateData
    extends MyAction {
        private static final long serialVersionUID = -2038911085935516L;
        int m_nNrOfInstances;
        int m_nSeed;
        String m_sFile;
        JDialog dlg;

        public ActionGenerateData() {
            super("Generate Data", "Generate Random Instances from Network", "generate.data", "ctrl D");
            this.m_nNrOfInstances = 100;
            this.m_nSeed = 1234;
            this.m_sFile = "";
            this.dlg = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dlg == null) {
                this.dlg = new JDialog();
                this.dlg.setTitle("Generate Random Data Options");
                JLabel jLabel = new JLabel("Nr of instances");
                final JTextField jTextField = new JTextField(3);
                jTextField.setHorizontalAlignment(0);
                jTextField.setText("" + this.m_nNrOfInstances);
                JLabel jLabel2 = new JLabel("Random seed");
                JTextField jTextField2 = new JTextField(3);
                jTextField2.setHorizontalAlignment(0);
                jTextField2.setText("" + this.m_nSeed);
                JLabel jLabel3 = new JLabel("Output file (optional)");
                final JTextField jTextField3 = new JTextField(12);
                jTextField3.setHorizontalAlignment(0);
                jTextField3.setText(this.m_sFile);
                JButton jButton = new JButton("Generate Data");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            String string = "tmp.bif.file.xml";
                            BayesNetGenerator bayesNetGenerator = new BayesNetGenerator();
                            String[] stringArray = new String[]{"-M", "" + jTextField.getText(), "-F", string};
                            FileWriter fileWriter = new FileWriter(string);
                            StringBuffer stringBuffer = new StringBuffer();
                            if (GUI.this.m_marginCalculator == null) {
                                GUI.this.m_marginCalculator = new MarginCalculator();
                                GUI.this.m_marginCalculator.calcMargins(GUI.this.m_BayesNet);
                            }
                            stringBuffer.append(GUI.this.m_marginCalculator.toXMLBIF03());
                            fileWriter.write(stringBuffer.toString());
                            fileWriter.close();
                            bayesNetGenerator.setOptions(stringArray);
                            bayesNetGenerator.generateRandomNetwork();
                            bayesNetGenerator.generateInstances();
                            GUI.this.m_Instances = bayesNetGenerator.m_Instances;
                            GUI.this.a_learn.setEnabled(true);
                            GUI.this.a_learnCPT.setEnabled(true);
                            ActionGenerateData.this.m_sFile = jTextField3.getText();
                            if (ActionGenerateData.this.m_sFile != null && !ActionGenerateData.this.m_sFile.equals("")) {
                                FileWriter fileWriter2 = new FileWriter(ActionGenerateData.this.m_sFile);
                                StringBuffer stringBuffer2 = new StringBuffer();
                                stringBuffer2.append(GUI.this.m_Instances.toString());
                                fileWriter2.write(stringBuffer2.toString());
                                fileWriter2.close();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ActionGenerateData.this.dlg.setVisible(false);
                    }
                });
                JButton jButton2 = new JButton("Browse");
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(".arff", "Arff files");
                        jFileChooser.addChoosableFileFilter(extensionFileFilter);
                        jFileChooser.setDialogTitle("Save Instances As");
                        int n = jFileChooser.showSaveDialog(GUI.this);
                        if (n == 0) {
                            String string = jFileChooser.getSelectedFile().toString();
                            jTextField3.setText(string);
                        }
                        ActionGenerateData.this.dlg.setVisible(true);
                    }
                });
                JButton jButton3 = new JButton("Cancel");
                jButton3.setMnemonic('C');
                jButton3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ActionGenerateData.this.dlg.setVisible(false);
                    }
                });
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.dlg.setLayout(new GridBagLayout());
                Container container = new Container();
                container.setLayout(new GridBagLayout());
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.insets = new Insets(8, 0, 0, 0);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.fill = 2;
                container.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)jTextField, gridBagConstraints);
                gridBagConstraints.gridwidth = -1;
                container.add((Component)jLabel2, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)jTextField2, gridBagConstraints);
                gridBagConstraints.gridwidth = -1;
                container.add((Component)jLabel3, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)jTextField3, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)jButton2, gridBagConstraints);
                gridBagConstraints.fill = 2;
                this.dlg.add((Component)container, gridBagConstraints);
                this.dlg.add(jButton);
                gridBagConstraints.gridwidth = 0;
                this.dlg.add(jButton3);
            }
            this.dlg.setLocation(100, 100);
            this.dlg.setVisible(true);
            this.dlg.setSize(this.dlg.getPreferredSize());
            this.dlg.setVisible(false);
            this.dlg.setVisible(true);
            this.dlg.repaint();
        }
    }

    class ActionGenerateNetwork
    extends MyAction {
        private static final long serialVersionUID = -2038911085935517L;
        int m_nNrOfNodes;
        int m_nNrOfArcs;
        int m_nCardinality;
        int m_nSeed;
        JDialog dlg;

        public ActionGenerateNetwork() {
            super("Generate Network", "Generate Random Bayesian Network", "generate.network", "ctrl N");
            this.m_nNrOfNodes = 10;
            this.m_nNrOfArcs = 15;
            this.m_nCardinality = 2;
            this.m_nSeed = 123;
            this.dlg = null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dlg == null) {
                this.dlg = new JDialog();
                this.dlg.setTitle("Generate Random Bayesian Network Options");
                JLabel jLabel = new JLabel("Nr of nodes");
                final JTextField jTextField = new JTextField(3);
                jTextField.setHorizontalAlignment(0);
                jTextField.setText("" + this.m_nNrOfNodes);
                JLabel jLabel2 = new JLabel("Nr of arcs");
                final JTextField jTextField2 = new JTextField(3);
                jTextField2.setHorizontalAlignment(0);
                jTextField2.setText("" + this.m_nNrOfArcs);
                JLabel jLabel3 = new JLabel("Cardinality");
                final JTextField jTextField3 = new JTextField(3);
                jTextField3.setHorizontalAlignment(0);
                jTextField3.setText("" + this.m_nCardinality);
                JLabel jLabel4 = new JLabel("Random seed");
                final JTextField jTextField4 = new JTextField(3);
                jTextField4.setHorizontalAlignment(0);
                jTextField4.setText("" + this.m_nSeed);
                JButton jButton = new JButton("Generate Network");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            BayesNetGenerator bayesNetGenerator = new BayesNetGenerator();
                            GUI.this.m_BayesNet = bayesNetGenerator;
                            GUI.this.m_BayesNet.clearUndoStack();
                            String[] stringArray = new String[]{"-N", "" + jTextField.getText(), "-A", "" + jTextField2.getText(), "-C", "" + jTextField3.getText(), "-S", "" + jTextField4.getText()};
                            bayesNetGenerator.setOptions(stringArray);
                            bayesNetGenerator.generateRandomNetwork();
                            BIFReader bIFReader = new BIFReader();
                            bIFReader.processString(GUI.this.m_BayesNet.toXMLBIF03());
                            GUI.this.m_BayesNet = new EditableBayesNet(bIFReader);
                            GUI.this.updateStatus();
                            GUI.this.layoutGraph();
                            GUI.this.a_datagenerator.setEnabled(true);
                            GUI.this.m_Instances = null;
                            GUI.this.a_learn.setEnabled(false);
                            GUI.this.a_learnCPT.setEnabled(false);
                            ActionGenerateNetwork.this.dlg.setVisible(false);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                JButton jButton2 = new JButton("Cancel");
                jButton2.setMnemonic('C');
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ActionGenerateNetwork.this.dlg.setVisible(false);
                    }
                });
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.dlg.setLayout(new GridBagLayout());
                Container container = new Container();
                container.setLayout(new GridBagLayout());
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.insets = new Insets(8, 0, 0, 0);
                gridBagConstraints.anchor = 18;
                gridBagConstraints.gridwidth = -1;
                gridBagConstraints.fill = 2;
                container.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)jTextField, gridBagConstraints);
                gridBagConstraints.gridwidth = -1;
                container.add((Component)jLabel2, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)jTextField2, gridBagConstraints);
                gridBagConstraints.gridwidth = -1;
                container.add((Component)jLabel3, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)jTextField3, gridBagConstraints);
                gridBagConstraints.gridwidth = -1;
                container.add((Component)jLabel4, gridBagConstraints);
                gridBagConstraints.gridwidth = 0;
                container.add((Component)jTextField4, gridBagConstraints);
                gridBagConstraints.fill = 2;
                this.dlg.add((Component)container, gridBagConstraints);
                this.dlg.add(jButton);
                gridBagConstraints.gridwidth = 0;
                this.dlg.add(jButton2);
            }
            this.dlg.setLocation(100, 100);
            this.dlg.setVisible(true);
            this.dlg.setSize(this.dlg.getPreferredSize());
            this.dlg.setVisible(false);
            this.dlg.setVisible(true);
            this.dlg.repaint();
        }
    }

    class MyAction
    extends AbstractAction {
        private static final long serialVersionUID = -2038911111935517L;

        public MyAction(String string, String string2, String string3, String string4) {
            Serializable serializable;
            super(string);
            this.putValue("ShortDescription", string2);
            this.putValue("LongDescription", string2);
            if (string4.length() > 0) {
                serializable = KeyStroke.getKeyStroke(string4);
                this.putValue("AcceleratorKey", serializable);
            }
            this.putValue("MnemonicKey", string.charAt(0));
            serializable = ClassLoader.getSystemResource("weka/classifiers/bayes/net/icons/" + string3 + ".png");
            if (serializable != null) {
                this.putValue("SmallIcon", new ImageIcon((URL)serializable));
            } else {
                this.putValue("SmallIcon", new ImageIcon(new BufferedImage(20, 20, 6)));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class ClipBoard {
        String m_sText = null;

        public ClipBoard() {
            if (GUI.this.a_pastenode != null) {
                GUI.this.a_pastenode.setEnabled(false);
            }
        }

        public boolean hasText() {
            return this.m_sText != null;
        }

        public String getText() {
            return this.m_sText;
        }

        public void setText(String string) {
            this.m_sText = string;
            GUI.this.a_pastenode.setEnabled(true);
        }
    }

    class Selection {
        FastVector m_selected = new FastVector();

        public FastVector getSelected() {
            return this.m_selected;
        }

        void updateGUI() {
            if (this.m_selected.size() > 0) {
                GUI.this.a_cutnode.setEnabled(true);
                GUI.this.a_copynode.setEnabled(true);
            } else {
                GUI.this.a_cutnode.setEnabled(false);
                GUI.this.a_copynode.setEnabled(false);
            }
            if (this.m_selected.size() > 1) {
                GUI.this.a_alignleft.setEnabled(true);
                GUI.this.a_alignright.setEnabled(true);
                GUI.this.a_aligntop.setEnabled(true);
                GUI.this.a_alignbottom.setEnabled(true);
                GUI.this.a_centerhorizontal.setEnabled(true);
                GUI.this.a_centervertical.setEnabled(true);
                GUI.this.a_spacehorizontal.setEnabled(true);
                GUI.this.a_spacevertical.setEnabled(true);
            } else {
                GUI.this.a_alignleft.setEnabled(false);
                GUI.this.a_alignright.setEnabled(false);
                GUI.this.a_aligntop.setEnabled(false);
                GUI.this.a_alignbottom.setEnabled(false);
                GUI.this.a_centerhorizontal.setEnabled(false);
                GUI.this.a_centervertical.setEnabled(false);
                GUI.this.a_spacehorizontal.setEnabled(false);
                GUI.this.a_spacevertical.setEnabled(false);
            }
        }

        public void addToSelection(int n) {
            for (int i = 0; i < this.m_selected.size(); ++i) {
                if (n != (Integer)this.m_selected.elementAt(i)) continue;
                return;
            }
            this.m_selected.addElement(n);
            this.updateGUI();
        }

        public void addToSelection(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                this.addToSelection(nArray[i]);
            }
            this.updateGUI();
        }

        public void addToSelection(Rectangle rectangle) {
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                if (!this.contains(rectangle, i)) continue;
                this.addToSelection(i);
            }
        }

        public void selectAll() {
            this.m_selected.removeAllElements();
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                this.m_selected.addElement(i);
            }
            this.updateGUI();
        }

        boolean contains(Rectangle rectangle, int n) {
            return rectangle.intersects((double)GUI.this.m_BayesNet.getPositionX(n) * GUI.this.m_fScale, (double)GUI.this.m_BayesNet.getPositionY(n) * GUI.this.m_fScale, (double)GUI.this.m_nPaddedNodeWidth * GUI.this.m_fScale, (double)GUI.this.m_nNodeHeight * GUI.this.m_fScale);
        }

        public void removeFromSelection(int n) {
            for (int i = 0; i < this.m_selected.size(); ++i) {
                if (n != (Integer)this.m_selected.elementAt(i)) continue;
                this.m_selected.removeElementAt(i);
            }
            this.updateGUI();
        }

        public void toggleSelection(int n) {
            for (int i = 0; i < this.m_selected.size(); ++i) {
                if (n != (Integer)this.m_selected.elementAt(i)) continue;
                this.m_selected.removeElementAt(i);
                this.updateGUI();
                return;
            }
            this.addToSelection(n);
        }

        public void toggleSelection(Rectangle rectangle) {
            for (int i = 0; i < GUI.this.m_BayesNet.getNrOfNodes(); ++i) {
                if (!this.contains(rectangle, i)) continue;
                this.toggleSelection(i);
            }
        }

        public void clear() {
            this.m_selected.removeAllElements();
            this.updateGUI();
        }

        public void draw(Graphics graphics) {
            if (this.m_selected.size() == 0) {
                return;
            }
            for (int i = 0; i < this.m_selected.size(); ++i) {
                int n = (Integer)this.m_selected.elementAt(i);
                int n2 = GUI.this.m_BayesNet.getPositionX(n);
                int n3 = GUI.this.m_BayesNet.getPositionY(n);
                graphics.setColor(Color.BLACK);
                int n4 = n2 + GUI.this.m_nPaddedNodeWidth - GUI.this.m_nNodeWidth - (GUI.this.m_nPaddedNodeWidth - GUI.this.m_nNodeWidth) / 2;
                int n5 = n3;
                int n6 = 5;
                graphics.fillRect(n4, n5, n6, n6);
                graphics.fillRect(n4, n5 + GUI.this.m_nNodeHeight, n6, n6);
                graphics.fillRect(n4 + GUI.this.m_nNodeWidth, n5, n6, n6);
                graphics.fillRect(n4 + GUI.this.m_nNodeWidth, n5 + GUI.this.m_nNodeHeight, n6, n6);
            }
        }
    }
}

