/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ErrorBasedMeritEvaluator;
import weka.attributeSelection.HoldOutSubsetEvaluator;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class ClassifierSubsetEval
extends HoldOutSubsetEvaluator
implements OptionHandler,
ErrorBasedMeritEvaluator {
    static final long serialVersionUID = 7532217899385278710L;
    private Instances m_trainingInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private Classifier m_Classifier = new ZeroR();
    private Evaluation m_Evaluation;
    private File m_holdOutFile = new File("Click to set hold out or test instances");
    private Instances m_holdOutInstances = null;
    private boolean m_useTraining = true;

    public String globalInfo() {
        return "Classifier subset evaluator:\n\nEvaluates attribute subsets on training data or a seperate hold out testing set. Uses a classifier to estimate the 'merit' of a set of attributes.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tclass name of the classifier to use for accuracy estimation.\n\tPlace any classifier options LAST on the command line\n\tfollowing a \"--\". eg.:\n\t\t-B weka.classifiers.bayes.NaiveBayes ... -- -K\n\t(default: weka.classifiers.rules.ZeroR)", "B", 1, "-B <classifier>"));
        vector.addElement(new Option("\tUse the training data to estimate accuracy.", "T", 0, "-T"));
        vector.addElement(new Option("\tName of the hold out/test set to \n\testimate accuracy on.", "H", 1, "-H <filename>"));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to scheme " + this.m_Classifier.getClass().getName() + ":"));
            Enumeration enumeration = this.m_Classifier.listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.resetOptions();
        String string = Utils.getOption('B', stringArray);
        if (string.length() == 0) {
            string = ZeroR.class.getName();
        }
        this.setClassifier(Classifier.forName(string, Utils.partitionOptions(stringArray)));
        string = Utils.getOption('H', stringArray);
        if (string.length() != 0) {
            this.setHoldOutFile(new File(string));
        }
        this.setUseTraining(Utils.getFlag('T', stringArray));
    }

    public String classifierTipText() {
        return "Classifier to use for estimating the accuracy of subsets";
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String holdOutFileTipText() {
        return "File containing hold out/test instances.";
    }

    public File getHoldOutFile() {
        return this.m_holdOutFile;
    }

    public void setHoldOutFile(File file) {
        this.m_holdOutFile = file;
    }

    public String useTrainingTipText() {
        return "Use training data instead of hold out/test instances.";
    }

    public boolean getUseTraining() {
        return this.m_useTraining;
    }

    public void setUseTraining(boolean bl) {
        this.m_useTraining = bl;
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            stringArray = this.m_Classifier.getOptions();
        }
        String[] stringArray2 = new String[6 + stringArray.length];
        int n = 0;
        if (this.getClassifier() != null) {
            stringArray2[n++] = "-B";
            stringArray2[n++] = this.getClassifier().getClass().getName();
        }
        if (this.getUseTraining()) {
            stringArray2[n++] = "-T";
        }
        stringArray2[n++] = "-H";
        stringArray2[n++] = this.getHoldOutFile().getPath();
        if (stringArray.length > 0) {
            stringArray2[n++] = "--";
            System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
            n += stringArray.length;
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getClassifier() == null ? super.getCapabilities() : this.getClassifier().getCapabilities();
        for (Capabilities.Capability capability : Capabilities.Capability.values()) {
            capabilities.enableDependency(capability);
        }
        return capabilities;
    }

    public void buildEvaluator(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_trainingInstances = instances;
        this.m_classIndex = this.m_trainingInstances.classIndex();
        this.m_numAttribs = this.m_trainingInstances.numAttributes();
        this.m_numInstances = this.m_trainingInstances.numInstances();
        if (!this.m_useTraining && !this.getHoldOutFile().getPath().startsWith("Click to set")) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getHoldOutFile().getPath()));
            this.m_holdOutInstances = new Instances(bufferedReader);
            this.m_holdOutInstances.setClassIndex(this.m_trainingInstances.classIndex());
            if (!this.m_trainingInstances.equalHeaders(this.m_holdOutInstances)) {
                throw new Exception("Hold out/test set is not compatable with training data.");
            }
        }
    }

    public double evaluateSubset(BitSet bitSet) throws Exception {
        int n;
        double d = 0.0;
        int n2 = 0;
        Instances instances = null;
        Instances instances2 = null;
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        instances = new Instances(this.m_trainingInstances);
        if (!this.m_useTraining) {
            if (this.m_holdOutInstances == null) {
                throw new Exception("Must specify a set of hold out/test instances with -H");
            }
            instances2 = new Instances(this.m_holdOutInstances);
        }
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            ++n2;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n3++] = n;
        }
        nArray[n3] = this.m_classIndex;
        remove.setAttributeIndicesArray(nArray);
        remove.setInputFormat(instances);
        instances = Filter.useFilter(instances, remove);
        if (!this.m_useTraining) {
            instances2 = Filter.useFilter(instances2, remove);
        }
        this.m_Classifier.buildClassifier(instances);
        this.m_Evaluation = new Evaluation(instances);
        if (!this.m_useTraining) {
            this.m_Evaluation.evaluateModel(this.m_Classifier, instances2, new Object[0]);
        } else {
            this.m_Evaluation.evaluateModel(this.m_Classifier, instances, new Object[0]);
        }
        d = this.m_trainingInstances.classAttribute().isNominal() ? this.m_Evaluation.errorRate() : this.m_Evaluation.meanAbsoluteError();
        this.m_Evaluation = null;
        return -d;
    }

    public double evaluateSubset(BitSet bitSet, Instances instances) throws Exception {
        int n;
        int n2 = 0;
        Instances instances2 = null;
        Instances instances3 = null;
        if (!this.m_trainingInstances.equalHeaders(instances)) {
            throw new Exception("evaluateSubset : Incompatable instance types.");
        }
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        instances2 = new Instances(this.m_trainingInstances);
        instances3 = new Instances(instances);
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            ++n2;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n3++] = n;
        }
        nArray[n3] = this.m_classIndex;
        remove.setAttributeIndicesArray(nArray);
        remove.setInputFormat(instances2);
        instances2 = Filter.useFilter(instances2, remove);
        instances3 = Filter.useFilter(instances3, remove);
        this.m_Classifier.buildClassifier(instances2);
        this.m_Evaluation = new Evaluation(instances2);
        this.m_Evaluation.evaluateModel(this.m_Classifier, instances3, new Object[0]);
        double d = this.m_trainingInstances.classAttribute().isNominal() ? this.m_Evaluation.errorRate() : this.m_Evaluation.meanAbsoluteError();
        this.m_Evaluation = null;
        return -d;
    }

    public double evaluateSubset(BitSet bitSet, Instance instance, boolean bl) throws Exception {
        int n;
        int n2 = 0;
        Instances instances = null;
        Instance instance2 = null;
        if (!this.m_trainingInstances.equalHeaders(instance.dataset())) {
            throw new Exception("evaluateSubset : Incompatable instance types.");
        }
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        instances = new Instances(this.m_trainingInstances);
        instance2 = (Instance)instance.copy();
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            ++n2;
        }
        int[] nArray = new int[n2 + 1];
        int n3 = 0;
        for (n = 0; n < this.m_numAttribs; ++n) {
            if (!bitSet.get(n)) continue;
            nArray[n3++] = n;
        }
        nArray[n3] = this.m_classIndex;
        remove.setAttributeIndicesArray(nArray);
        remove.setInputFormat(instances);
        if (bl) {
            instances = Filter.useFilter(instances, remove);
            this.m_Classifier.buildClassifier(instances);
        }
        remove.input(instance2);
        instance2 = remove.output();
        double[] dArray = this.m_Classifier.distributionForInstance(instance2);
        double d = this.m_trainingInstances.classAttribute().isNominal() ? dArray[(int)instance2.classValue()] : dArray[0];
        double d2 = this.m_trainingInstances.classAttribute().isNominal() ? 1.0 - d : instance2.classValue() - d;
        return -d2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_trainingInstances == null) {
            stringBuffer.append("\tClassifier subset evaluator has not been built yet\n");
        } else {
            stringBuffer.append("\tClassifier Subset Evaluator\n");
            stringBuffer.append("\tLearning scheme: " + this.getClassifier().getClass().getName() + "\n");
            stringBuffer.append("\tScheme options: ");
            String[] stringArray = new String[]{};
            if (this.m_Classifier instanceof OptionHandler) {
                stringArray = this.m_Classifier.getOptions();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i] + " ");
                }
            }
            stringBuffer.append("\n");
            stringBuffer.append("\tHold out/test set: ");
            if (!this.m_useTraining) {
                if (this.getHoldOutFile().getPath().startsWith("Click to set")) {
                    stringBuffer.append("none\n");
                } else {
                    stringBuffer.append(this.getHoldOutFile().getPath() + '\n');
                }
            } else {
                stringBuffer.append("Training data\n");
            }
            if (this.m_trainingInstances.attribute(this.m_classIndex).isNumeric()) {
                stringBuffer.append("\tAccuracy estimation: MAE\n");
            } else {
                stringBuffer.append("\tAccuracy estimation: classification error\n");
            }
        }
        return stringBuffer.toString();
    }

    protected void resetOptions() {
        this.m_trainingInstances = null;
        this.m_Evaluation = null;
        this.m_Classifier = new ZeroR();
        this.m_holdOutFile = new File("Click to set hold out or test instances");
        this.m_holdOutInstances = null;
        this.m_useTraining = false;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.18 $");
    }

    public static void main(String[] stringArray) {
        ClassifierSubsetEval.runEvaluator(new ClassifierSubsetEval(), stringArray);
    }
}

