/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.REPTree;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.unsupervised.attribute.Remove;

public class RandomSubSpace
extends RandomizableIteratedSingleClassifierEnhancer
implements WeightedInstancesHandler,
TechnicalInformationHandler {
    private static final long serialVersionUID = 1278172513912424947L;
    protected double m_SubSpaceSize = 0.5;
    protected Classifier m_ZeroR;

    public RandomSubSpace() {
        this.m_Classifier = new REPTree();
    }

    public String globalInfo() {
        return "This method constructs a decision tree based classifier that maintains highest accuracy on training data and improves on generalization accuracy as it grows in complexity. The classifier consists of multiple trees constructed systematically by pseudorandomly selecting subsets of components of the feature vector, that is, trees constructed in randomly chosen subspaces.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Tin Kam Ho");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1998");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "The Random Subspace Method for Constructing Decision Forests");
        technicalInformation.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Pattern Analysis and Machine Intelligence");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "20");
        technicalInformation.setValue(TechnicalInformation.Field.NUMBER, "8");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "832-844");
        technicalInformation.setValue(TechnicalInformation.Field.URL, "http://citeseer.ist.psu.edu/ho98random.html");
        technicalInformation.setValue(TechnicalInformation.Field.ISSN, "0162-8828");
        return technicalInformation;
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.REPTree";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSize of each subspace:\n\t\t< 1: percentage of the number of attributes\n\t\t>=1: absolute number of attributes\n", "P", 1, "-P"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setSubSpaceSize(Double.parseDouble(string));
        } else {
            this.setSubSpaceSize(0.5);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-P");
        vector.add("" + this.getSubSpaceSize());
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String subSpaceSizeTipText() {
        return "Size of each subSpace: if less than 1 as a percentage of the number of attributes, otherwise the absolute number of attributes.";
    }

    public double getSubSpaceSize() {
        return this.m_SubSpaceSize;
    }

    public void setSubSpaceSize(double d) {
        this.m_SubSpaceSize = d;
    }

    protected int numberOfAttributes(int n, double d) {
        int n2 = (int)Math.round(d < 1.0 ? (double)n * d : d);
        if (n2 > n) {
            n2 = n;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        return n2;
    }

    protected String randomSubSpace(Integer[] integerArray, int n, int n2, Random random) {
        Collections.shuffle(Arrays.asList(integerArray), random);
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(integerArray[i] + ",");
        }
        stringBuffer.append(n2);
        if (this.getDebug()) {
            System.out.println("subSPACE = " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        super.buildClassifier(instances);
        Integer[] integerArray = new Integer[instances.numAttributes() - 1];
        int n2 = instances.classIndex();
        int n3 = 0;
        for (n = 0; n < integerArray.length + 1; ++n) {
            if (n == n2) continue;
            integerArray[n3++] = n + 1;
        }
        n = this.numberOfAttributes(integerArray.length, this.getSubSpaceSize());
        Random random = instances.getRandomNumberGenerator(this.m_Seed);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            if (this.m_Classifier instanceof Randomizable) {
                ((Randomizable)((Object)this.m_Classifiers[i])).setSeed(random.nextInt());
            }
            FilteredClassifier filteredClassifier = new FilteredClassifier();
            filteredClassifier.setClassifier(this.m_Classifiers[i]);
            this.m_Classifiers[i] = filteredClassifier;
            Remove remove = new Remove();
            remove.setOptions(new String[]{"-V", "-R", this.randomSubSpace(integerArray, n, n2 + 1, random)});
            filteredClassifier.setFilter(remove);
            this.m_Classifiers[i].buildClassifier(instances);
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        double[] dArray = new double[instance.numClasses()];
        for (int i = 0; i < this.m_NumIterations; ++i) {
            if (instance.classAttribute().isNumeric()) {
                dArray[0] = dArray[0] + this.m_Classifiers[i].classifyInstance(instance);
                continue;
            }
            double[] dArray2 = this.m_Classifiers[i].distributionForInstance(instance);
            for (int j = 0; j < dArray2.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] + dArray2[j];
            }
        }
        if (instance.classAttribute().isNumeric()) {
            dArray[0] = dArray[0] / (double)this.m_NumIterations;
            return dArray;
        }
        if (Utils.eq(Utils.sum(dArray), 0.0)) {
            return dArray;
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            stringBuffer.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            stringBuffer.append(this.m_ZeroR.toString());
            return stringBuffer.toString();
        }
        if (this.m_Classifiers == null) {
            return "RandomSubSpace: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("All the base classifiers: \n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append(this.m_Classifiers[i].toString() + "\n\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        RandomSubSpace.runClassifier(new RandomSubSpace(), stringArray);
    }
}

