/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.ensembleSelection;

import weka.classifiers.Evaluation;

public class EnsembleMetricHelper {
    public static final int METRIC_ACCURACY = 0;
    public static final int METRIC_RMSE = 1;
    public static final int METRIC_ROC = 2;
    public static final int METRIC_PRECISION = 3;
    public static final int METRIC_RECALL = 4;
    public static final int METRIC_FSCORE = 5;
    public static final int METRIC_ALL = 6;

    public static double getMetric(Evaluation evaluation, int n) {
        switch (n) {
            case 0: {
                return evaluation.pctCorrect();
            }
            case 1: {
                return 1.0 - evaluation.rootMeanSquaredError();
            }
            case 2: {
                return evaluation.areaUnderROC(1);
            }
            case 3: {
                return evaluation.precision(1);
            }
            case 4: {
                return evaluation.recall(1);
            }
            case 5: {
                return evaluation.fMeasure(1);
            }
            case 6: {
                double d = 0.0;
                int n2 = 0;
                d += evaluation.pctCorrect();
                ++n2;
                d += 1.0 - evaluation.rootMeanSquaredError();
                ++n2;
                d += evaluation.areaUnderROC(1);
                ++n2;
                d += evaluation.precision(1);
                ++n2;
                d += evaluation.recall(1);
                ++n2;
                return (d += evaluation.fMeasure(1)) / (double)(++n2);
            }
        }
        return 0.0;
    }
}

