/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableClassifier;
import weka.classifiers.mi.TLD_Optm;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class TLD
extends RandomizableClassifier
implements OptionHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 6657315525171152210L;
    protected double[][] m_MeanP = null;
    protected double[][] m_VarianceP = null;
    protected double[][] m_MeanN = null;
    protected double[][] m_VarianceN = null;
    protected double[][] m_SumP = null;
    protected double[][] m_SumN = null;
    protected double[] m_ParamsP = null;
    protected double[] m_ParamsN = null;
    protected int m_Dimension = 0;
    protected double[] m_Class = null;
    protected int m_NumClasses = 2;
    public static double ZERO = 1.0E-6;
    protected int m_Run = 1;
    protected double m_Cutoff;
    protected boolean m_UseEmpiricalCutOff = false;

    public String globalInfo() {
        return "Two-Level Distribution approach, changes the starting value of the searching algorithm, supplement the cut-off modification and check missing values.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MISC);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Xin Xu");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Statistical learning in multiple instance problem");
        technicalInformation.setValue(TechnicalInformation.Field.SCHOOL, "University of Waikato");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, NZ");
        technicalInformation.setValue(TechnicalInformation.Field.NOTE, "0657.594");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.BINARY_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return capabilities;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.disableAllClasses();
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        double d;
        double d2;
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        int n7 = instances.numInstances();
        this.m_Dimension = instances.attribute(1).relation().numAttributes();
        Instances instances2 = new Instances(instances, 0);
        Instances instances3 = new Instances(instances, 0);
        for (n6 = 0; n6 < n7; ++n6) {
            Instance instance = instances.instance(n6);
            if (instance.classValue() == 1.0) {
                instances2.add(instance);
                continue;
            }
            instances3.add(instance);
        }
        n6 = instances2.numInstances();
        int n8 = instances3.numInstances();
        this.m_MeanP = new double[n6][this.m_Dimension];
        this.m_VarianceP = new double[n6][this.m_Dimension];
        this.m_SumP = new double[n6][this.m_Dimension];
        this.m_MeanN = new double[n8][this.m_Dimension];
        this.m_VarianceN = new double[n8][this.m_Dimension];
        this.m_SumN = new double[n8][this.m_Dimension];
        this.m_ParamsP = new double[4 * this.m_Dimension];
        this.m_ParamsN = new double[4 * this.m_Dimension];
        double[] dArray = new double[this.m_Dimension];
        double[] dArray2 = new double[this.m_Dimension];
        double[] dArray3 = new double[this.m_Dimension];
        double[] dArray4 = new double[this.m_Dimension];
        double[] dArray5 = new double[this.m_Dimension];
        double[] dArray6 = new double[this.m_Dimension];
        double[] dArray7 = new double[this.m_Dimension];
        double[] dArray8 = new double[this.m_Dimension];
        double[] dArray9 = new double[this.m_Dimension];
        double[] dArray10 = new double[this.m_Dimension];
        for (n5 = 0; n5 < n6; ++n5) {
            object = instances2.instance(n5).relationalValue(1);
            for (n4 = 0; n4 < ((Instances)object).numAttributes(); ++n4) {
                this.m_MeanP[n5][n4] = ((Instances)object).meanOrMode(n4);
                this.m_VarianceP[n5][n4] = ((Instances)object).variance(n4);
            }
            n4 = 0;
            n3 = 0;
            while (n4 < this.m_Dimension) {
                if (!Double.isNaN(this.m_MeanP[n5][n4])) {
                    for (n2 = 0; n2 < ((Instances)object).numInstances(); ++n2) {
                        Instance instance = ((Instances)object).instance(n2);
                        if (instance.isMissing(n3)) continue;
                        double[] dArray11 = this.m_SumP[n5];
                        int n9 = n4;
                        dArray11[n9] = dArray11[n9] + instance.weight();
                    }
                    int n10 = n4;
                    dArray9[n10] = dArray9[n10] + 1.0;
                    int n11 = n4;
                    dArray[n11] = dArray[n11] + this.m_MeanP[n5][n4];
                    int n12 = n4;
                    dArray7[n12] = dArray7[n12] + this.m_MeanP[n5][n4] * this.m_MeanP[n5][n4];
                    if (dArray3[n4] < this.m_VarianceP[n5][n4]) {
                        dArray3[n4] = this.m_VarianceP[n5][n4];
                    }
                    int n13 = n4;
                    dArray5[n13] = dArray5[n13] + this.m_VarianceP[n5][n4];
                    double[] dArray12 = this.m_VarianceP[n5];
                    int n14 = n4;
                    dArray12[n14] = dArray12[n14] * (this.m_SumP[n5][n4] - 1.0);
                    if (this.m_VarianceP[n5][n4] < 0.0) {
                        this.m_VarianceP[n5][n4] = 0.0;
                    }
                }
                ++n4;
                ++n3;
            }
        }
        for (n5 = 0; n5 < n8; ++n5) {
            object = instances3.instance(n5).relationalValue(1);
            for (n4 = 0; n4 < ((Instances)object).numAttributes(); ++n4) {
                this.m_MeanN[n5][n4] = ((Instances)object).meanOrMode(n4);
                this.m_VarianceN[n5][n4] = ((Instances)object).variance(n4);
            }
            n4 = 0;
            n3 = 0;
            while (n4 < this.m_Dimension) {
                if (!Double.isNaN(this.m_MeanN[n5][n4])) {
                    for (n2 = 0; n2 < ((Instances)object).numInstances(); ++n2) {
                        if (((Instances)object).instance(n2).isMissing(n3)) continue;
                        double[] dArray13 = this.m_SumN[n5];
                        int n15 = n4;
                        dArray13[n15] = dArray13[n15] + ((Instances)object).instance(n2).weight();
                    }
                    int n16 = n4;
                    dArray10[n16] = dArray10[n16] + 1.0;
                    int n17 = n4;
                    dArray2[n17] = dArray2[n17] + this.m_MeanN[n5][n4];
                    int n18 = n4;
                    dArray8[n18] = dArray8[n18] + this.m_MeanN[n5][n4] * this.m_MeanN[n5][n4];
                    if (dArray4[n4] < this.m_VarianceN[n5][n4]) {
                        dArray4[n4] = this.m_VarianceN[n5][n4];
                    }
                    int n19 = n4;
                    dArray6[n19] = dArray6[n19] + this.m_VarianceN[n5][n4];
                    double[] dArray14 = this.m_VarianceN[n5];
                    int n20 = n4;
                    dArray14[n20] = dArray14[n20] * (this.m_SumN[n5][n4] - 1.0);
                    if (this.m_VarianceN[n5][n4] < 0.0) {
                        this.m_VarianceN[n5][n4] = 0.0;
                    }
                }
                ++n4;
                ++n3;
            }
        }
        for (n5 = 0; n5 < this.m_Dimension; ++n5) {
            int n21 = n5;
            dArray[n21] = dArray[n21] / dArray9[n5];
            int n22 = n5;
            dArray2[n22] = dArray2[n22] / dArray10[n5];
            if (dArray9[n5] > 1.0) {
                dArray7[n5] = dArray7[n5] / (dArray9[n5] - 1.0) - dArray[n5] * dArray9[n5] / (dArray9[n5] - 1.0);
            }
            if (dArray10[n5] > 1.0) {
                dArray8[n5] = dArray8[n5] / (dArray10[n5] - 1.0) - dArray2[n5] * dArray10[n5] / (dArray10[n5] - 1.0);
            }
            int n23 = n5;
            dArray5[n23] = dArray5[n23] / dArray9[n5];
            int n24 = n5;
            dArray6[n24] = dArray6[n24] / dArray10[n5];
        }
        double[][] dArray15 = new double[2][4];
        object = new double[4];
        double[] dArray16 = new double[4];
        for (n = 0; n < this.m_Dimension; ++n) {
            int n25;
            double d3;
            if (this.getDebug()) {
                System.err.println("\n\n!!!!!!!!!!!!!!!!!!!!!!???Dimension #" + n);
            }
            double d4 = d3 = dArray3[n] > ZERO ? dArray3[n] : 1.0;
            if (dArray5[n] <= ZERO) {
                dArray5[n] = ZERO;
            }
            double d5 = d3 / dArray5[n] + 2.0;
            d2 = dArray7[n] / dArray5[n];
            if (d2 <= ZERO) {
                d2 = 1.0;
            }
            d = dArray[n];
            object[0] = d3;
            object[1] = d5;
            object[2] = d2;
            object[3] = d;
            double d6 = d3 = dArray4[n] > ZERO ? dArray4[n] : 1.0;
            if (dArray6[n] <= ZERO) {
                dArray6[n] = ZERO;
            }
            d5 = d3 / dArray6[n] + 2.0;
            d2 = dArray8[n] / dArray6[n];
            if (d2 <= ZERO) {
                d2 = 1.0;
            }
            d = dArray2[n];
            dArray16[0] = d3;
            dArray16[1] = d5;
            dArray16[2] = d2;
            dArray16[3] = d;
            dArray15[0][0] = ZERO;
            dArray15[0][1] = 2.0 + ZERO;
            dArray15[0][2] = ZERO;
            dArray15[0][3] = Double.NaN;
            for (int i = 0; i < 4; ++i) {
                dArray15[1][i] = Double.NaN;
                this.m_ParamsP[4 * n + i] = (double)object[i];
                this.m_ParamsN[4 * n + i] = dArray16[i];
            }
            double d7 = Double.MAX_VALUE;
            double d8 = Double.MAX_VALUE;
            Random random = new Random(this.m_Seed);
            TLD_Optm tLD_Optm = null;
            TLD_Optm tLD_Optm2 = null;
            boolean bl = true;
            double[] dArray17 = new double[n6];
            double[] dArray18 = new double[n6];
            double[] dArray19 = new double[n6];
            double[] dArray20 = new double[n8];
            double[] dArray21 = new double[n8];
            double[] dArray22 = new double[n8];
            for (n25 = 0; n25 < n6; ++n25) {
                dArray17[n25] = this.m_SumP[n25][n];
                dArray18[n25] = this.m_MeanP[n25][n];
                dArray19[n25] = this.m_VarianceP[n25][n];
            }
            for (n25 = 0; n25 < n8; ++n25) {
                dArray20[n25] = this.m_SumN[n25][n];
                dArray21[n25] = this.m_MeanN[n25][n];
                dArray22[n25] = this.m_VarianceN[n25][n];
            }
            n25 = 0;
            while (n25 < this.m_Run) {
                double d9;
                int n26;
                if (this.getDebug()) {
                    System.err.println("\n\n!!!!!!!!!!!!!!!!!!!!!!???Run #" + n25);
                }
                if (this.getDebug()) {
                    System.err.println("\nPositive exemplars");
                }
                tLD_Optm = new TLD_Optm();
                tLD_Optm.setNum(dArray17);
                tLD_Optm.setSSquare(dArray19);
                tLD_Optm.setXBar(dArray18);
                object = tLD_Optm.findArgmin((double[])object, dArray15);
                while (object == null) {
                    object = tLD_Optm.getVarbValues();
                    if (this.getDebug()) {
                        System.err.println("!!! 200 iterations finished, not enough!");
                    }
                    object = tLD_Optm.findArgmin((double[])object, dArray15);
                }
                double d10 = tLD_Optm.getMinFunction();
                if (!Double.isNaN(d10) && d10 < d7) {
                    d7 = d10;
                    for (n26 = 0; n26 < 4; ++n26) {
                        this.m_ParamsP[4 * n + n26] = (double)object[n26];
                    }
                }
                if (Double.isNaN(d10)) {
                    object = new double[4];
                    bl = false;
                }
                if (this.getDebug()) {
                    System.err.println("\nNegative exemplars");
                }
                tLD_Optm2 = new TLD_Optm();
                tLD_Optm2.setNum(dArray20);
                tLD_Optm2.setSSquare(dArray22);
                tLD_Optm2.setXBar(dArray21);
                dArray16 = tLD_Optm2.findArgmin(dArray16, dArray15);
                while (dArray16 == null) {
                    dArray16 = tLD_Optm2.getVarbValues();
                    if (this.getDebug()) {
                        System.err.println("!!! 200 iterations finished, not enough!");
                    }
                    dArray16 = tLD_Optm2.findArgmin(dArray16, dArray15);
                }
                d10 = tLD_Optm2.getMinFunction();
                if (!Double.isNaN(d10) && d10 < d8) {
                    d8 = d10;
                    for (n26 = 0; n26 < 4; ++n26) {
                        this.m_ParamsN[4 * n + n26] = dArray16[n26];
                    }
                }
                if (Double.isNaN(d10)) {
                    dArray16 = new double[4];
                    bl = false;
                }
                if (!bl) {
                    --n25;
                    bl = true;
                }
                if (++n25 >= this.m_Run) continue;
                n26 = random.nextInt(n6);
                int n27 = random.nextInt(n8);
                while (this.m_SumP[n26][n] <= 1.0 || Double.isNaN(this.m_MeanP[n26][n])) {
                    n26 = random.nextInt(n6);
                }
                d3 = this.m_VarianceP[n26][n] / (this.m_SumP[n26][n] - 1.0);
                if (d3 <= ZERO) {
                    d3 = this.m_ParamsN[4 * n];
                }
                if ((d5 = d3 * this.m_ParamsP[4 * n + 2] / (d9 = ((d = this.m_MeanP[n26][n]) - this.m_ParamsP[4 * n + 3]) * (d - this.m_ParamsP[4 * n + 3])) + 2.0) <= ZERO || Double.isNaN(d5) || Double.isInfinite(d5)) {
                    d5 = this.m_ParamsN[4 * n + 1];
                }
                if ((d2 = d9 * (this.m_ParamsP[4 * n + 1] - 2.0) / this.m_ParamsP[4 * n]) <= ZERO || Double.isNaN(d2) || Double.isInfinite(d2)) {
                    d2 = this.m_ParamsN[4 * n + 2];
                }
                object[0] = d3;
                object[1] = d5;
                object[2] = d2;
                object[3] = d;
                while (this.m_SumN[n27][n] <= 1.0 || Double.isNaN(this.m_MeanN[n27][n])) {
                    n27 = random.nextInt(n8);
                }
                d3 = this.m_VarianceN[n27][n] / (this.m_SumN[n27][n] - 1.0);
                if (d3 <= ZERO) {
                    d3 = this.m_ParamsP[4 * n];
                }
                if ((d5 = d3 * this.m_ParamsN[4 * n + 2] / (d9 = ((d = this.m_MeanN[n27][n]) - this.m_ParamsN[4 * n + 3]) * (d - this.m_ParamsN[4 * n + 3])) + 2.0) <= ZERO || Double.isNaN(d5) || Double.isInfinite(d5)) {
                    d5 = this.m_ParamsP[4 * n + 1];
                }
                if ((d2 = d9 * (this.m_ParamsN[4 * n + 1] - 2.0) / this.m_ParamsN[4 * n]) <= ZERO || Double.isNaN(d2) || Double.isInfinite(d2)) {
                    d2 = this.m_ParamsP[4 * n + 2];
                }
                dArray16[0] = d3;
                dArray16[1] = d5;
                dArray16[2] = d2;
                dArray16[3] = d;
            }
        }
        n = 0;
        int n28 = 0;
        while (n < this.m_Dimension) {
            double d11 = this.m_ParamsP[4 * n];
            double d12 = this.m_ParamsP[4 * n + 1];
            d2 = this.m_ParamsP[4 * n + 2];
            d = this.m_ParamsP[4 * n + 3];
            if (this.getDebug()) {
                System.err.println("\n\n???Positive: ( " + instances.attribute(1).relation().attribute(n28) + "): a=" + d11 + ", b=" + d12 + ", w=" + d2 + ", m=" + d);
            }
            d11 = this.m_ParamsN[4 * n];
            d12 = this.m_ParamsN[4 * n + 1];
            d2 = this.m_ParamsN[4 * n + 2];
            d = this.m_ParamsN[4 * n + 3];
            if (this.getDebug()) {
                System.err.println("???Negative: (" + instances.attribute(1).relation().attribute(n28) + "): a=" + d11 + ", b=" + d12 + ", w=" + d2 + ", m=" + d);
            }
            ++n;
            ++n28;
        }
        if (this.m_UseEmpiricalCutOff) {
            int n29;
            double[] dArray23 = new double[n6];
            double[] dArray24 = new double[n8];
            for (n29 = 0; n29 < n6; ++n29) {
                dArray23[n29] = this.likelihoodRatio(this.m_SumP[n29], this.m_MeanP[n29], this.m_VarianceP[n29]);
            }
            for (n29 = 0; n29 < n8; ++n29) {
                dArray24[n29] = this.likelihoodRatio(this.m_SumN[n29], this.m_MeanN[n29], this.m_VarianceN[n29]);
            }
            this.findCutOff(dArray23, dArray24);
        } else {
            this.m_Cutoff = -Math.log((double)n6 / (double)n8);
        }
        if (this.getDebug()) {
            System.err.println("???Cut-off=" + this.m_Cutoff);
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        int n;
        Instances instances = instance.relationalValue(1);
        double[] dArray = new double[this.m_Dimension];
        double[] dArray2 = new double[this.m_Dimension];
        double[] dArray3 = new double[this.m_Dimension];
        for (n = 0; n < instances.numAttributes(); ++n) {
            dArray2[n] = instances.meanOrMode(n);
            dArray3[n] = instances.variance(n);
        }
        n = 0;
        int n2 = 0;
        while (n < this.m_Dimension) {
            for (int i = 0; i < instances.numInstances(); ++i) {
                if (instances.instance(i).isMissing(n2)) continue;
                int n3 = n;
                dArray[n3] = dArray[n3] + instances.instance(i).weight();
            }
            dArray3[n] = dArray3[n] * (dArray[n] - 1.0);
            if (dArray3[n] <= 0.0) {
                dArray3[n] = 0.0;
            }
            ++n;
            ++n2;
        }
        double d = this.likelihoodRatio(dArray, dArray2, dArray3);
        return d > this.m_Cutoff ? 1.0 : 0.0;
    }

    private double likelihoodRatio(double[] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_Dimension; ++i) {
            int n;
            if (Double.isNaN(dArray2[i])) continue;
            int n2 = (int)dArray[i] / 2;
            double d3 = this.m_ParamsP[4 * i];
            double d4 = this.m_ParamsP[4 * i + 1];
            double d5 = this.m_ParamsP[4 * i + 2];
            double d6 = this.m_ParamsP[4 * i + 3];
            d += 0.5 * d4 * Math.log(d3) + 0.5 * (d4 + dArray[i] - 1.0) * Math.log(1.0 + dArray[i] * d5) - 0.5 * (d4 + dArray[i]) * Math.log((1.0 + dArray[i] * d5) * (d3 + dArray3[i]) + dArray[i] * (dArray2[i] - d6) * (dArray2[i] - d6)) - 0.5 * dArray[i] * Math.log(Math.PI);
            for (n = 1; n <= n2; ++n) {
                d += Math.log(d4 / 2.0 + dArray[i] / 2.0 - (double)n);
            }
            if (dArray[i] / 2.0 > (double)n2) {
                d += TLD_Optm.diffLnGamma(d4 / 2.0);
            }
            d3 = this.m_ParamsN[4 * i];
            d4 = this.m_ParamsN[4 * i + 1];
            d5 = this.m_ParamsN[4 * i + 2];
            d6 = this.m_ParamsN[4 * i + 3];
            d2 += 0.5 * d4 * Math.log(d3) + 0.5 * (d4 + dArray[i] - 1.0) * Math.log(1.0 + dArray[i] * d5) - 0.5 * (d4 + dArray[i]) * Math.log((1.0 + dArray[i] * d5) * (d3 + dArray3[i]) + dArray[i] * (dArray2[i] - d6) * (dArray2[i] - d6)) - 0.5 * dArray[i] * Math.log(Math.PI);
            for (n = 1; n <= n2; ++n) {
                d2 += Math.log(d4 / 2.0 + dArray[i] / 2.0 - (double)n);
            }
            if (!(dArray[i] / 2.0 > (double)n2)) continue;
            d2 += TLD_Optm.diffLnGamma(d4 / 2.0);
        }
        return d - d2;
    }

    private void findCutOff(double[] dArray, double[] dArray2) {
        int[] nArray = Utils.sort(dArray);
        int[] nArray2 = Utils.sort(dArray2);
        int n = dArray.length;
        int n2 = dArray2.length;
        int n3 = 0;
        int n4 = 0;
        double d = 0.0;
        double d2 = n;
        double d3 = 0.0;
        double d4 = Double.MAX_VALUE;
        while (n4 < n2 && dArray[nArray[0]] >= dArray2[nArray2[n4]]) {
            ++n4;
            d += 1.0;
        }
        if (n4 >= n2) {
            this.m_Cutoff = (dArray2[nArray2[n2 - 1]] + dArray[nArray[0]]) / 2.0;
            return;
        }
        int n5 = n4;
        while (n3 < n && n4 < n2) {
            double d5;
            if (dArray[nArray[n3]] >= dArray2[nArray2[n4]]) {
                d += 1.0;
                d5 = dArray2[nArray2[n4]];
                ++n4;
            } else {
                d2 -= 1.0;
                d5 = dArray[nArray[n3]];
                ++n3;
            }
            ++n5;
            if (!(d + d2 > d3) && (d + d2 != d3 || !(Math.abs(d5) < d4))) continue;
            d3 = d + d2;
            this.m_Cutoff = d5;
            d4 = Math.abs(d5);
        }
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSet whether or not use empirical\n\tlog-odds cut-off instead of 0", "C", 0, "-C"));
        vector.addElement(new Option("\tSet the number of multiple runs \n\tneeded for searching the MLE.", "R", 1, "-R <numOfRuns>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        this.setUsingCutOff(Utils.getFlag('C', stringArray));
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setNumRuns(Integer.parseInt(string));
        } else {
            this.setNumRuns(1);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (this.getDebug()) {
            vector.add("-D");
        }
        if (this.getUsingCutOff()) {
            vector.add("-C");
        }
        vector.add("-R");
        vector.add("" + this.getNumRuns());
        return vector.toArray(new String[vector.size()]);
    }

    public String numRunsTipText() {
        return "The number of runs to perform.";
    }

    public void setNumRuns(int n) {
        this.m_Run = n;
    }

    public int getNumRuns() {
        return this.m_Run;
    }

    public String usingCutOffTipText() {
        return "Whether to use an empirical cutoff.";
    }

    public void setUsingCutOff(boolean bl) {
        this.m_UseEmpiricalCutOff = bl;
    }

    public boolean getUsingCutOff() {
        return this.m_UseEmpiricalCutOff;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new TLD(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

