/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorFullBayes;
import weka.classifiers.bayes.net.estimate.SimpleEstimator;
import weka.classifiers.bayes.net.search.local.K2;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.Estimator;

public class BMAEstimator
extends SimpleEstimator {
    protected boolean m_bUseK2Prior = false;

    public void estimateCPTs(BayesNet bayesNet) throws Exception {
        int n;
        this.initCPTs(bayesNet);
        Instances instances = bayesNet.m_Instances;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (bayesNet.getParentSet(i).getNrOfParents() <= 1) continue;
            throw new Exception("Cannot handle networks with nodes with more than 1 parent (yet).");
        }
        BayesNet bayesNet2 = new BayesNet();
        K2 k2 = new K2();
        k2.setInitAsNaiveBayes(false);
        k2.setMaxNrOfParents(0);
        bayesNet2.setSearchAlgorithm(k2);
        bayesNet2.buildClassifier(instances);
        BayesNet bayesNet3 = new BayesNet();
        k2.setInitAsNaiveBayes(true);
        k2.setMaxNrOfParents(1);
        bayesNet3.setSearchAlgorithm(k2);
        bayesNet3.buildClassifier(instances);
        for (n = 0; n < instances.numAttributes(); ++n) {
            int n2;
            int n3;
            int n4;
            if (n == instances.classIndex()) continue;
            double d = 0.0;
            double d2 = 0.0;
            int n5 = instances.attribute(n).numValues();
            if (this.m_bUseK2Prior) {
                for (n4 = 0; n4 < n5; ++n4) {
                    d += Statistics.lnGamma(1.0 + ((DiscreteEstimatorBayes)bayesNet2.m_Distributions[n][0]).getCount(n4)) - Statistics.lnGamma(1.0);
                }
                d += Statistics.lnGamma(n5) - Statistics.lnGamma(n5 + instances.numInstances());
                for (n4 = 0; n4 < bayesNet.getParentSet(n).getCardinalityOfParents(); ++n4) {
                    n3 = 0;
                    for (n2 = 0; n2 < n5; ++n2) {
                        double d3 = ((DiscreteEstimatorBayes)bayesNet3.m_Distributions[n][n4]).getCount(n2);
                        d2 += Statistics.lnGamma(1.0 + d3) - Statistics.lnGamma(1.0);
                        n3 = (int)((double)n3 + d3);
                    }
                    d2 += Statistics.lnGamma(n5) - Statistics.lnGamma(n5 + n3);
                }
            } else {
                for (n4 = 0; n4 < n5; ++n4) {
                    d += Statistics.lnGamma(1.0 / (double)n5 + ((DiscreteEstimatorBayes)bayesNet2.m_Distributions[n][0]).getCount(n4)) - Statistics.lnGamma(1.0 / (double)n5);
                }
                d += Statistics.lnGamma(1.0) - Statistics.lnGamma(1 + instances.numInstances());
                n4 = bayesNet.getParentSet(n).getCardinalityOfParents();
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = 0;
                    for (int i = 0; i < n5; ++i) {
                        double d4 = ((DiscreteEstimatorBayes)bayesNet3.m_Distributions[n][n3]).getCount(i);
                        d2 += Statistics.lnGamma(1.0 / (double)(n5 * n4) + d4) - Statistics.lnGamma(1.0 / (double)(n5 * n4));
                        n2 = (int)((double)n2 + d4);
                    }
                    d2 += Statistics.lnGamma(1.0) - Statistics.lnGamma(1 + n2);
                }
            }
            if (d < d2) {
                d2 -= d;
                d = 0.0;
                d = 1.0 / (1.0 + Math.exp(d2));
                d2 = Math.exp(d2) / (1.0 + Math.exp(d2));
            } else {
                d -= d2;
                d2 = 0.0;
                d2 = 1.0 / (1.0 + Math.exp(d));
                d = Math.exp(d) / (1.0 + Math.exp(d));
            }
            for (n4 = 0; n4 < bayesNet.getParentSet(n).getCardinalityOfParents(); ++n4) {
                bayesNet.m_Distributions[n][n4] = new DiscreteEstimatorFullBayes(instances.attribute(n).numValues(), d, d2, (DiscreteEstimatorBayes)bayesNet2.m_Distributions[n][0], (DiscreteEstimatorBayes)bayesNet3.m_Distributions[n][n4], this.m_fAlpha);
            }
        }
        n = instances.classIndex();
        bayesNet.m_Distributions[n][0] = bayesNet2.m_Distributions[n][0];
    }

    public void updateClassifier(BayesNet bayesNet, Instance instance) throws Exception {
        throw new Exception("updateClassifier does not apply to BMA estimator");
    }

    public void initCPTs(BayesNet bayesNet) throws Exception {
        int n = 1;
        for (int i = 0; i < bayesNet.m_Instances.numAttributes(); ++i) {
            if (bayesNet.getParentSet(i).getCardinalityOfParents() <= n) continue;
            n = bayesNet.getParentSet(i).getCardinalityOfParents();
        }
        bayesNet.m_Distributions = new Estimator[bayesNet.m_Instances.numAttributes()][n];
    }

    public boolean isUseK2Prior() {
        return this.m_bUseK2Prior;
    }

    public void setUseK2Prior(boolean bl) {
        this.m_bUseK2Prior = bl;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tWhether to use K2 prior.\n", "k2", 0, "-k2"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setUseK2Prior(Utils.getFlag("k2", stringArray));
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = super.getOptions();
        String[] stringArray2 = new String[1 + stringArray.length];
        int n = 0;
        if (this.isUseK2Prior()) {
            stringArray2[n++] = "-k2";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[n++] = stringArray[i];
        }
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }
}

