/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.J48;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;

public class OrdinalClassClassifier
extends SingleClassifierEnhancer
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -3461971774059603636L;
    private Classifier[] m_Classifiers;
    private MakeIndicator[] m_ClassFilters;
    private ZeroR m_ZeroR;

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public OrdinalClassClassifier() {
        this.m_Classifier = new J48();
    }

    public String globalInfo() {
        return "Meta classifier that allows standard classification algorithms to be applied to ordinal class problems.\n\nFor more information see: \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Mark Hall");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "A Simple Approach to Ordinal Classification");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "12th European Conference on Machine Learning");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2001");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "145-156");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAllClasses();
        capabilities.disableAllClassDependencies();
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        this.m_ZeroR = new ZeroR();
        this.m_ZeroR.buildClassifier(instances);
        int n = instances.numClasses() - 1;
        int n2 = n = n == 0 ? 1 : n;
        if (n == 1) {
            this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, 1);
            this.m_Classifiers[0].buildClassifier(instances);
        } else {
            this.m_Classifiers = Classifier.makeCopies(this.m_Classifier, n);
            this.m_ClassFilters = new MakeIndicator[n];
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                this.m_ClassFilters[i] = new MakeIndicator();
                this.m_ClassFilters[i].setAttributeIndex("" + (instances.classIndex() + 1));
                this.m_ClassFilters[i].setValueIndices("" + (i + 2) + "-last");
                this.m_ClassFilters[i].setNumeric(false);
                this.m_ClassFilters[i].setInputFormat(instances);
                Instances instances2 = Filter.useFilter(instances, this.m_ClassFilters[i]);
                this.m_Classifiers[i].buildClassifier(instances2);
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        if (this.m_Classifiers.length == 1) {
            return this.m_Classifiers[0].distributionForInstance(instance);
        }
        double[] dArray = new double[instance.numClasses()];
        double[][] dArray2 = new double[this.m_ClassFilters.length][0];
        for (n = 0; n < this.m_ClassFilters.length; ++n) {
            this.m_ClassFilters[n].input(instance);
            this.m_ClassFilters[n].batchFinished();
            dArray2[n] = this.m_Classifiers[n].distributionForInstance(this.m_ClassFilters[n].output());
        }
        for (n = 0; n < instance.numClasses(); ++n) {
            if (n == 0) {
                dArray[n] = dArray2[0][0];
                continue;
            }
            if (n == instance.numClasses() - 1) {
                dArray[n] = dArray2[n - 1][1];
                continue;
            }
            dArray[n] = dArray2[n - 1][1] - dArray2[n][1];
            if (dArray[n] > 0.0) continue;
            System.err.println("Warning: estimated probability " + dArray[n] + ". Rounding to 0.");
            dArray[n] = 0.0;
        }
        if (Utils.gr(Utils.sum(dArray), 0.0)) {
            Utils.normalize(dArray);
            return dArray;
        }
        return this.m_ZeroR.distributionForInstance(instance);
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        return super.getOptions();
    }

    public String toString() {
        if (this.m_Classifiers == null) {
            return "OrdinalClassClassifier: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OrdinalClassClassifier\n\n");
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            stringBuffer.append("Classifier ").append(i + 1);
            if (this.m_Classifiers[i] != null) {
                if (this.m_ClassFilters != null && this.m_ClassFilters[i] != null) {
                    stringBuffer.append(", using indicator values: ");
                    stringBuffer.append(this.m_ClassFilters[i].getValueRange());
                }
                stringBuffer.append('\n');
                stringBuffer.append(this.m_Classifiers[i].toString() + "\n");
                continue;
            }
            stringBuffer.append(" Skipped (no training examples)\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            OrdinalClassClassifier ordinalClassClassifier = new OrdinalClassClassifier();
            System.out.println(Evaluation.evaluateModel(ordinalClassClassifier, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

