% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transForecast_lda.R
\name{transForecast_lda}
\alias{transForecast_lda}
\title{Forecast - using Linear Discriminant Analysis}
\usage{
transForecast_lda(data, histData, predData_lda, startDate, endDate, method,
                         interval, snapshots, defind, depVar, indVars, pct, ratingCat)
}
\arguments{
\item{data}{a table containing historical credit ratings data (i.e., credit migration data). A dataframe of size \emph{nRecords} x 3 where each row contains an ID (column 1), a date (column 2), and a credit rating (column 3); The credit rating is the rating assigned to the corresponding ID on the corresponding date.}

\item{histData}{historical macroeconomic,financial and non-financial data.}

\item{predData_lda}{forecasting data.}

\item{startDate}{start date of the estimation time window, in string or numeric format.}

\item{endDate}{end date of the estimation time window, in string or numeric format.}

\item{method}{estimation algorithm, in string format. Valid values are 'duration'  or 'cohort'.}

\item{interval}{the length of the transition interval under consideration, in years. The default value is 1, \emph{i.e., 1-year transition probabilities are estimated}.}

\item{snapshots}{integer indicating the number of credit-rating snapshots per year to be considered for the estimation. Valid values are 1, 4, or 12. The default value is 1, \emph{i.e., one snapshot per year}. This parameter is only used in the 'cohort' algorithm.}

\item{defind}{Default Indicator}

\item{depVar}{dependent variable, as a string.}

\item{indVars}{list containing the independent variables.}

\item{pct}{percent of data used in training dataset.}

\item{ratingCat}{list containing the unique rating caetgories}
}
\value{
The output consists of a forecasted transition matrix.
}
\description{
This model implements a forecasting method using Linear Discriminant Analysis.
}
\examples{
\dontrun{
lda_T<-transForecast_lda(data, histData, predData_lda, startDate, endDate, 
  method, interval, snapshots, defind, depVar, indVars, pct, ratingCat)
}
}
\author{
Abdoulaye (Ab) N'Diaye
}
