% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTestCase.R
\docType{methods}
\name{readXMLInputData}
\alias{readXMLInputData}
\alias{readXMLInputData,RTestCase-method}
\title{Read Input Data of Test Case for Default XML Definitions}
\usage{
\S4method{readXMLInputData}{RTestCase}(object)
}
\arguments{
\item{object}{(\code{object}) The \code{\link{RTestCase-class}} object}
}
\value{
(\code{ANY}) If multiple datasets are defined a \code{list} will be returned 
          containing all datasets with the same order as in the XML file. Else, if only a single
          is defined, the dataset itself will be returned.
}
\description{
This functions reads the XML definitions for default RTest objects.
}
\details{
Input datasets are contained below the XML element '\code{input-data}' and can be used by any
test packages and functions of the respective test case adapter (i.e. by the functions of the
objects inheriting the class '\code{RTestCase}'). By default major R data types are predefined
under the node and can be read by this method. Thereby, the type of the imported datasets is 
determined by the XML element names. This method runs through all XML items, parses the 
item and converts it into the respective R object.\cr
The following element types are supported:\cr
\itemize{
  \item{variable}{\code{XML: variable, XSD: RTestData_variable, RTest: xmlReadData_variable}}
  \item{vector}{\code{XML: vector, XSD: RTestData_vector, RTest: xmlReadData_vector}}
  \item{data.frame}{\code{XML: data.frame, XSD: RTestData_data.frame, RTest: xmlReadData_data.frame}}
  \item{list}{\code{XML: list, XSD: RTestData_list, RTest: xmlReadData_list}}
}
}
\seealso{
\code{RTestCase-class}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
