% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_api_pkgzip.R
\name{pkgzip_build_prj_packages}
\alias{pkgzip_build_prj_packages}
\title{Builds PKGZIP out of project packages.}
\usage{
pkgzip_build_prj_packages(pkgs = NULL, prj = NULL, zip_ver = NULL,
  pkg_type = .Platform$pkgType, path = getwd(), with_deps = FALSE,
  filter_repo = NULL, skip_build_steps = NULL)
}
\arguments{
\item{pkgs}{vector of project packages which should be included in PKGZIP
or NULL to include all project packages (type: character, default: NULL)}

\item{prj}{project object to use. If not passed will init project from
working directory. (type: rsuite_project, default: NULL)}

\item{zip_ver}{if passed enforce the version of PKGZIP package to the passed value.
Expected form of version is DD.DD. (type: character, default: NULL)}

\item{pkg_type}{type of packages to build (type: character, default: platform default)}

\item{path}{folder path to put output zip into. The folder must exist.
(type: character: default:  \code{getwd()})}

\item{with_deps}{If TRUE will include dependencies pkgs dependencies into final zip.
(type: logical, default: FALSE)}

\item{filter_repo}{repository address to not include dependencies available in.
In a project, dependencies will never be filtered. If NULL will not filter
dependencies. Will be omitted if with_deps is FALSE. (type: character(1), default: NULL)}

\item{skip_build_steps}{character vector with steps to skip while building
   project packages. Can contain following entries:
\describe{
  \item{specs}{Process packages specifics}
  \item{docs}{Try build documentation with roxygen}
  \item{imps}{Perform imports validation}
  \item{tests}{Run package tests}
  \item{rcpp_attribs}{Run rppAttribs on the package}
  \item{vignettes}{Build package vignettes}
}
(type: character(N), default: NULL).}
}
\value{
created pkgzip file path (invisible).
}
\description{
Builds PKGZIP out of project packages.
}
\details{
PKGZIP will be tagged with the same way as project zip.

Logs all messages onto rsuite logger. Use  \code{logging::setLevel} to control logs
verbosity.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # start package in my_project
  prj_start_package("mypackage", skip_rc = TRUE, prj = prj)

  # build project environment and install supportives
  prj_install_deps(prj = prj, vanilla_sups = TRUE)

  # build PKGZIP
  pkgzip_fpath <- pkgzip_build_prj_packages(prj = prj, path = tempdir())

  # list content of pkgzip created
  unzip(pkgzip_fpath, list = TRUE)
}

}
\seealso{
Other in PKGZIP building: \code{\link{pkgzip_build_bioc_package}},
  \code{\link{pkgzip_build_ext_packages}},
  \code{\link{pkgzip_build_github_package}},
  \code{\link{pkgzip_build_package_files}}
}
\concept{in PKGZIP building}
