% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_api_repo.R
\name{repo_mng_start}
\alias{repo_mng_start}
\title{Starts management over the repository.}
\usage{
repo_mng_start(ra_name, ...)
}
\arguments{
\item{ra_name}{name of the repository to whose adapter will be re-initialized. (type: character)}

\item{...}{repository specific parameters. See repo_adapter_create_manager
for the concrete implementation of repo adapter for more details.}
}
\value{
repo manager object.
}
\description{
Creates object to manage the repository.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# set it to use in project repository and CRAN
prj_config_set_repo_adapters(c("Dir", "CRAN"), prj = prj)

# start managing in project repository
rmgr <- repo_mng_start("Dir", prj = prj, ix = 1)

# stop repository management
repo_mng_stop(rmgr)

}
\seealso{
Other in repository management: \code{\link{repo_mng_init}},
  \code{\link{repo_mng_list}},
  \code{\link{repo_mng_remove}},
  \code{\link{repo_mng_stop}},
  \code{\link{repo_upload_ext_packages}},
  \code{\link{repo_upload_github_package}},
  \code{\link{repo_upload_package_files}},
  \code{\link{repo_upload_pkgzip}},
  \code{\link{repo_upload_prj_packages}}
}
