% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_api_tmpl.R
\name{tmpl_start_pkg}
\alias{tmpl_start_pkg}
\title{Creates a new package template with the specified name, in the specified path.}
\usage{
tmpl_start_pkg(name, path = NULL)
}
\arguments{
\item{name}{name of the template being created. (type: character(1))}

\item{path}{path to the directory where the template should be created. If
NULL will use folder with user template. (type: character(1), default: NULL)}
}
\description{
Creates a new package template with the specified name, in the specified path.
}
\details{
Package templates are required to include a DESCRIPTION file

If there is no path argument provided. The function will create the
template in the default template folder in the user's local environment
}
\examples{
tmpl_dir <- tempfile("pkgtempl_")
tmpl_start_pkg(basename(tmpl_dir), path = tempdir())

}
\seealso{
Other in templates management: \code{\link{tmpl_get_registered}},
  \code{\link{tmpl_start_prj}}
}
