% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueueRanked.R
\name{QueueRanked}
\alias{QueueRanked}
\title{Run a Ranked Report}
\usage{
QueueRanked(reportsuite.id, date.from, date.to, metrics, elements, top = 0,
  start = 0, selected = c(), search = c(), search.type = "or",
  segment.id = "", segment.inline = "", classification = c(),
  data.current = FALSE, expedite = FALSE, interval.seconds = 5,
  max.attempts = 120, validate = TRUE)
}
\arguments{
\item{reportsuite.id}{Report suite id}

\item{date.from}{Start date for the report (YYYY-MM-DD)}

\item{date.to}{End date for the report (YYYY-MM-DD)}

\item{metrics}{List of metrics to include in the report}

\item{elements}{List of elements to include in the report}

\item{top}{List of numbers to limit the number of rows to include (top X). eg. c(10,5)}

\item{start}{Start row if you do not want to start at #1 - only applies to the first element.}

\item{selected}{List of specific items (of the first element) to include in the report - e.g. c("www:home","www:search","www:about").
this only works for the first element (API limitation).}

\item{search}{List of keywords for the first specified element - e.g. c("contact","about","shop").
search overrides anything specified using selected}

\item{search.type}{String specifying the search type: 'and', or, 'or' 'not' (defaults to 'or')}

\item{segment.id}{Id of Adobe Analytics segment to retrieve the report for}

\item{segment.inline}{Inline segment definition}

\item{classification}{SAINT classification to use in place of first element. Need to specify element AND classification.}

\item{data.current}{TRUE or FALSE - whether to include current data for reports that include today's date}

\item{expedite}{Set to TRUE to expedite the processing of this report}

\item{interval.seconds}{How long to wait between attempts}

\item{max.attempts}{Number of API attempts before stopping}

\item{validate}{Weather to submit report definition for validation before requesting the data.}
}
\value{
Data frame
}
\description{
A QueueRanked report is a report that shows the ranking of values for
one or more elements relative to a metric, aggregated over the time period selected.
}
\details{
The QueueRanked function returns a data frame equivalent to pulling
a Ranked report in Adobe Reports & Analytics. Correlations & Sub-Relations are
supported.

Because of the Reporting API structure, this function first requests the
report, then checks the reporting queue to see if the report is completed, and
when the report returns as "done" pulls the report from the API. This checking
process will occur up to the specified number of times (default 120), with a
delay between status checks (default 5 seconds). If the report does not return
as "done" after the number of tries have completed, the function will return an
error message.

Note: Because of the multiple argument types ("top" and "start" OR "selected"),
keyword arguments are generally needed towards the end of the function call instead
of just positional arguments.
}
\examples{
\dontrun{

ranked1 <- QueueRanked("your_report_suite",
                       date.from = "2014-04-01",
                       date.to = "2014-04-20",
                       metrics = "pageviews",
                       elements = c("sitesection", "page")
                       )

}

}

