% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ident.ext.R
\name{ident.ext}
\alias{ident.ext}
\title{Probe extrema in the response surface}
\usage{
ident.ext(
  RSA_object,
  model = NULL,
  acceleration = c(0, 0),
  alpha = 0.05,
  z_tested = "observed",
  alphacorrection = "none",
  n_sample = NULL,
  verbose = TRUE,
  df_out = FALSE
)
}
\arguments{
\item{RSA_object}{An RSA object}

\item{model}{The model to be probed for extrema (reversal or acceleration points)}

\item{acceleration}{Rates of accelerations along the LOC and LOIC to be inspected (0< abs(rate) < 1). Acceleration points will only appear if reversals do not exist, and if acceleration rates exist (if not, a warning will appear).}

\item{alpha}{Alpha level for the one-sided confidence interval of the outcome predictions on the extrema}

\item{z_tested}{Should significance tests be conducted on "observed" or "predicted" observation}

\item{alphacorrection}{Set "Bonferroni" to adjust the alpha level for multiple testing when testing the outcome predictions of all data points behind the extrema}

\item{n_sample}{Number of random draws to consider to find extrema. This option is used for large samples to increase speed in preliminary analyses, but it is not recommended for published results). Defaults to NULL.}

\item{verbose}{Should extra information be printed?}

\item{df_out}{Number of random draws to consider to find extrema. This option is used for large samples to increase speed in preliminary analyses, but it is not recommended for published results). Defaults to NULL.}
}
\value{
A table containing the location and percentages of observations above or below extrema
}
\description{
Identify reversal or acceleration points (generically called "extrema") in the LOC or LOIC of the response surface and test how many of them have outcome observations that significantly differ from what would be expected for predictor combinations on these points (that have the same level)
}
\details{
When testing for reversals or accelerations in nonlinear response surfaces involving quadratic or cubic polynomial families (FM4 to FM37), the \code{RSAextrema} function helps to determine the exact location of reversal or acceleration points along the lines of congruenc (LOC) or incongruence (LOIC), and the number and percentage of observations significantly affected by these reversals or accelerations (for a given probability level, alpha). This points are determined according to derivatives of the function according to rationales for combining polynomials (Núñez-Regueiro & Juhel, 2022, 2024).
}
\references{
Núñez-Regueiro, F., Juhel, J. (2022). \emph{Model-Building Strategies in Response Surface Analysis} Manuscript submitted for publication.
 
Núñez-Regueiro, F., Juhel, J. (2024). \emph{Response Surface Analysis for the Social Sciences II: Combinatory Rationales for Complex Polynomial Models} Manuscript submitted for publication.
}
\seealso{
\code{\link{plotting.ext}}, \code{\link{RSAmodel}}
}
