% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{open_help}
\alias{open_help}
\title{Access the QGIS/GRASS online help for a specific (Q)GIS geoalgorihm}
\usage{
open_help(alg = NULL, qgis_env = set_env())
}
\arguments{
\item{alg}{The name of the algorithm for which one wishes to retrieve 
arguments and default values.}

\item{qgis_env}{Environment containing all the paths to run the QGIS API. For
more information, refer to \code{\link{set_env}}.}
}
\value{
The function opens the default web browser, and displays the help for
  the specified algorithm.
}
\description{
\code{open_help} opens the online help for a specific (Q)GIS 
  geoalgorithm. This is the online help one also encounters in the QGIS GUI.
  In the case of GRASS algorithms this is actually the GRASS online
  documentation.
}
\details{
Bar a few exceptions \code{open_help} works for all QGIS, GRASS and
  SAGA geoalgorithms. The online help of other third-party providers,
  however, has not been tested so far.
}
\note{
Please note that \code{open_help} requires a \strong{working Internet 
  connection}.
}
\examples{
\dontrun{
# QGIS example
open_help(alg = "qgis:addfieldtoattributestable")
# GRASS example
open_help(alg = "grass:v.overlay")
}
}
\author{
Jannes Muenchow, Victor Olaya, QGIS core team
}

