% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{calibrationQuality,RPhosFate-method}
\alias{calibrationQuality,RPhosFate-method}
\alias{calibrationQuality}
\title{Calibration quality}
\usage{
\S4method{calibrationQuality}{RPhosFate}(x, substance, col)
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}

\item{substance}{A character string specifying the substance to calculate.}

\item{col}{A character string specifying the calibration data column with the
respective substance river loads.}
}
\value{
A named numeric vector containing the assessed metrics along with the
in-channel retention ratio (one minus sum of \emph{xxt} at catchment outlet(s)
divided by sum of \emph{xxt_inp}).
}
\description{
Assesses the model's calibration quality via the following metrics:
\itemize{
\item \emph{NSE:} Nash-Sutcliffe Efficiency
\item \emph{mNSE:} Modified Nash-Sutcliffe Efficiency (\code{j = 1})
\item \emph{KGE:} Kling-Gupta Efficiency (\verb{s = c(1, 1, 1), method = "2012"})
\item \emph{RMSE:} Root Mean Square Error
\item \emph{PBIAS:} Percent Bias
\item \emph{RSR:} Ratio of the RMSE to the standard deviation of the observations
\item \emph{RCV:} Ratio of the coefficients of variation
\item \emph{GMRAE:} Geometric Mean Relative Absolute Error
\item \emph{MdRAE:} Median Relative Absolute Error
}

In addition, a scatter plot with the observed river loads on the x- and the
modelled river loads on the y-axis is displayed and provides a visual
impression of the model performance. Other elements of this plot are an
identity line (solid) and plus/minus 30\% deviation lines (dashed).
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)
# presupposed method calls
x <- firstRun(x, "SS")
x <- snapGauges(x)

calibrationQuality(x, "SS", "SS_load")}

}
\seealso{
\code{\link{snapGauges}}, \code{\link{autoCalibrate}}, \code{\link{autoCalibrate2}},
\code{\link[hydroGOF:NSE]{hydroGOF::NSE}}, \code{\link[hydroGOF:mNSE]{hydroGOF::mNSE}}, \code{\link[hydroGOF:KGE]{hydroGOF::KGE}},
\code{\link[hydroGOF:rmse]{hydroGOF::rmse}}, \code{\link[hydroGOF:pbias]{hydroGOF::pbias}}, \code{\link[hydroGOF:rsr]{hydroGOF::rsr}}
}
