% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounds.R
\name{C_bound}
\alias{C_bound}
\alias{as.C_bound}
\alias{c.C_bound}
\alias{is.C_bound}
\title{Conic Bounds}
\usage{
C_bound(..., type = c("free", "nonneg", "soc", "psd", "expp", "expd", "powp",
  "powd"))

\method{c}{C_bound}(...)

as.C_bound(x)

is.C_bound(x)
}
\arguments{
\item{...}{arguments which give the row index in the A matrix or 
objects to be combined.}

\item{type}{an character giving the type of the bound, 
valid types are \code{"free"}, \code{"nonneg"}, \code{"soc"}, \code{"psd"}, 
\code{"expp"}, \code{"expd"}, \code{"powp"} and \code{"powd"}.}

\item{x}{an object to be coerced or tested.}
}
\value{
An S3 object of class \code{"C_bound"} containing the conic
        bounds.
}
\description{
Construct a conic bounds object.
}
\details{
The \pkg{ROI} cone formulation sticks closely to the formulation
  used by the solvers CVXOPT, ECOS and SCS.
  \deqn{minimize \ c^\top x \ \ \ s.t. \ A x + s  = b \ \ \ s \in K \ \ x \in R^n}
}
\examples{
conic_bounds <- c(C_bound(1, type="free"), C_bound(2:4, type="soc"))
cones <- list("free"=c(1), "soc"=list(2:4))
conic_bounds <- as.C_bound(cones)
cones <- list("free"=c(1, 2), "expd"=list(3:5))
bound <- as.C_bound(cones)
}
\references{
\code{[CVXOPT]}  Andersen, Martin S and Dahl, Joachim and Vandenberghe, Lieven (2016)
  CVXOPT: A Python package for convex optimization, version 1.1.8,
  \url{http://cvxopt.org/}
  \cr \cr
  \code{[ECOS]}  Domahidi, A. and Chu, E. and Boyd, S. (2013) 
  {ECOS}: {A}n {SOCP} solver for embedded systems. 
  European Control Conference (ECC), 3071-3076
  \cr \cr
  \code{[SCS]}  O'Donoghue, Brendan and Chu, Eric and Parikh, Neal and Boyd, Stephen (2016)
  Conic Optimization via Operator Splitting and Homogeneous Self-Dual Embedding
  Journal of Optimization Theory and Applications, 1-27
}

