## ROI plugin: ECOS
## based on ecos interface

make_ECOS_signatures <- function()
    ROI_plugin_make_signature( objective = c("L"),
                                constraints = c("X", "L", "C"),
                                types = c("C", "I", "B", "CI", "CB", "IB", "CIB"),
                                bounds = c("X", "V"),
                                cones = c("X", "zero", "nonneg", "soc", "expp"),
                                maximum = c(TRUE, FALSE) )

## SOLVER CONTROLS
.add_controls <- function(solver) {
    ## ECOS
    ROI_plugin_register_solver_control( solver, "VERBOSE", "verbose" )
    ROI_plugin_register_solver_control( solver, "MAXIT", "max_iter" )
    ROI_plugin_register_solver_control( solver, "FEASTOL", "tol" ) ## tolerance on the primal and dual residual
    ## ROI_plugin_register_solver_control( solver, "MAXIT", "X" )
    ## ROI_plugin_register_solver_control( solver, "FEASTOL", "X" )
    ROI_plugin_register_solver_control( solver, "RELTOL", "X" )
    ROI_plugin_register_solver_control( solver, "ABSTOL", "X" )
    ROI_plugin_register_solver_control( solver, "FEASTOL_INACC", "X" )
    ROI_plugin_register_solver_control( solver, "ABSTOL_INACC", "X" )
    ROI_plugin_register_solver_control( solver, "RELTOL_INACC", "X" )
    ## ROI_plugin_register_solver_control( solver, "VERBOSE", "X" )
    ROI_plugin_register_solver_control( solver, "MI_MAX_ITERS", "X" )
    ROI_plugin_register_solver_control( solver, "MI_INT_TOL", "X" )
    ROI_plugin_register_solver_control( solver, "MI_ABS_EPS", "X" )
    ROI_plugin_register_solver_control( solver, "MI_REL_EPS", "X" )

    invisible( TRUE )
}

.onLoad <- function( libname, pkgname ) {
    ## Solver plugin name (based on package name)
    if( ! pkgname %in% ROI_registered_solvers() ){
        ## Register solver methods here.
        ## One can assign several signatures a single solver method
        solver <- ROI_plugin_get_solver_name( pkgname )
        ROI_plugin_register_solver_method(
            signatures = make_ECOS_signatures(),
            solver = solver,
            method = getFunction( "solve_OP", where = getNamespace(pkgname)) )
        ## Finally, for status code canonicalization add status codes to data base
        .add_status_codes()
        .add_controls( solver )
    }
}

