% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocCIemp.R
\name{ciROCemp}
\alias{ciROCemp}
\title{Confidence Interval of Empirical ROC Curve}
\usage{
ciROCemp(rocit_emp, level)
}
\arguments{
\item{rocit_emp}{An object of class \code{rocit}, (\code{method = "empirical"}).}

\item{level}{Desired level of confidence to be estimated.}
}
\value{
A list object containing TPR, upper and lower bound of TPR
at certain FPR values.
}
\description{
Function \code{ciROCemp} estimates confidence interval
of empirically estimated ROC curve.
}
\section{Comment}{

\code{ciROCemp} is used internally in \code{\link{ciROC.rocit}}
of \pkg{ROCit}.
}

\examples{
set.seed(100)
score <- c(runif(20, 15, 35), runif(15, 25, 45))
class <- c(rep(1, 20), rep(0, 15))
rocit_object <- rocit(score, class)
ciROC <- ciROCemp(rocit_object, level = 0.9)
names(ciROC)
}
\seealso{
\code{\link{rocit}}, \code{\link{ciROC}}, \code{\link{plot.rocci}}
}
