/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed;

import gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed.ExtensionMapper;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed.ISSNType;
import gov.nih.nlm.ncbi.www.soap.eutils.efetch_pubmed.JournalIssueType;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.databinding.utils.writer.MTOMAwareXMLStreamWriter;

public class JournalType
implements ADBBean {
    protected ISSNType localISSN;
    protected boolean localISSNTracker = false;
    protected JournalIssueType localJournalIssue;
    protected String localTitle;
    protected boolean localTitleTracker = false;
    protected String localISOAbbreviation;
    protected boolean localISOAbbreviationTracker = false;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed")) {
            return "ns1";
        }
        return BeanUtil.getUniquePrefix();
    }

    public ISSNType getISSN() {
        return this.localISSN;
    }

    public void setISSN(ISSNType param) {
        this.localISSNTracker = param != null;
        this.localISSN = param;
    }

    public JournalIssueType getJournalIssue() {
        return this.localJournalIssue;
    }

    public void setJournalIssue(JournalIssueType param) {
        this.localJournalIssue = param;
    }

    public String getTitle() {
        return this.localTitle;
    }

    public void setTitle(String param) {
        this.localTitleTracker = param != null;
        this.localTitle = param;
    }

    public String getISOAbbreviation() {
        return this.localISOAbbreviation;
    }

    public void setISOAbbreviation(String param) {
        this.localISOAbbreviationTracker = param != null;
        this.localISOAbbreviation = param;
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    public OMElement getOMElement(QName parentQName, final OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName){

            public void serialize(MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException {
                JournalType.this.serialize(this.parentQName, factory, xmlWriter);
            }
        };
        return new OMSourcedElementImpl(parentQName, factory, (OMDataSource)dataSource);
    }

    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, factory, xmlWriter, false);
    }

    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String prefix = null;
        String namespace = null;
        prefix = parentQName.getPrefix();
        namespace = parentQName.getNamespaceURI();
        if (namespace != null && namespace.trim().length() > 0) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, parentQName.getLocalPart());
            } else {
                if (prefix == null) {
                    prefix = JournalType.generatePrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, parentQName.getLocalPart(), namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(parentQName.getLocalPart());
        }
        if (serializeType) {
            String namespacePrefix = this.registerPrefix((XMLStreamWriter)xmlWriter, "http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed");
            if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":JournalType", (XMLStreamWriter)xmlWriter);
            } else {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "JournalType", (XMLStreamWriter)xmlWriter);
            }
        }
        if (this.localISSNTracker) {
            if (this.localISSN == null) {
                throw new ADBException("ISSN cannot be null!!");
            }
            this.localISSN.serialize(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "ISSN"), factory, xmlWriter);
        }
        if (this.localJournalIssue == null) {
            throw new ADBException("JournalIssue cannot be null!!");
        }
        this.localJournalIssue.serialize(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "JournalIssue"), factory, xmlWriter);
        if (this.localTitleTracker) {
            namespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = JournalType.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "Title", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "Title");
                }
            } else {
                xmlWriter.writeStartElement("Title");
            }
            if (this.localTitle == null) {
                throw new ADBException("Title cannot be null!!");
            }
            xmlWriter.writeCharacters(this.localTitle);
            xmlWriter.writeEndElement();
        }
        if (this.localISOAbbreviationTracker) {
            namespace = "http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = JournalType.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "ISOAbbreviation", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "ISOAbbreviation");
                }
            } else {
                xmlWriter.writeStartElement("ISOAbbreviation");
            }
            if (this.localISOAbbreviation == null) {
                throw new ADBException("ISOAbbreviation cannot be null!!");
            }
            xmlWriter.writeCharacters(this.localISOAbbreviation);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname.getLocalPart() : qname.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = JournalType.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString((QName)qname));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString((QName)qname));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString((QName)qname));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = JournalType.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString((QName)qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString((QName)qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString((QName)qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            prefix = JournalType.generatePrefix(namespace);
            while (xmlWriter.getNamespaceContext().getNamespaceURI(prefix) != null) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    public XMLStreamReader getPullParser(QName qName) throws ADBException {
        ArrayList<Object> elementList = new ArrayList<Object>();
        ArrayList attribList = new ArrayList();
        if (this.localISSNTracker) {
            elementList.add(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "ISSN"));
            if (this.localISSN == null) {
                throw new ADBException("ISSN cannot be null!!");
            }
            elementList.add(this.localISSN);
        }
        elementList.add(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "JournalIssue"));
        if (this.localJournalIssue == null) {
            throw new ADBException("JournalIssue cannot be null!!");
        }
        elementList.add(this.localJournalIssue);
        if (this.localTitleTracker) {
            elementList.add(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "Title"));
            if (this.localTitle != null) {
                elementList.add(ConverterUtil.convertToString((String)this.localTitle));
            } else {
                throw new ADBException("Title cannot be null!!");
            }
        }
        if (this.localISOAbbreviationTracker) {
            elementList.add(new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "ISOAbbreviation"));
            if (this.localISOAbbreviation != null) {
                elementList.add(ConverterUtil.convertToString((String)this.localISOAbbreviation));
            } else {
                throw new ADBException("ISOAbbreviation cannot be null!!");
            }
        }
        return new ADBXMLStreamReaderImpl(qName, elementList.toArray(), attribList.toArray());
    }

    public static class Factory {
        public static JournalType parse(XMLStreamReader reader) throws Exception {
            JournalType object = new JournalType();
            Object nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                String content;
                String fullTypeName;
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null && (fullTypeName = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                    String nsPrefix = null;
                    if (fullTypeName.indexOf(":") > -1) {
                        nsPrefix = fullTypeName.substring(0, fullTypeName.indexOf(":"));
                    }
                    nsPrefix = nsPrefix == null ? "" : nsPrefix;
                    String type = fullTypeName.substring(fullTypeName.indexOf(":") + 1);
                    if (!"JournalType".equals(type)) {
                        String nsUri = reader.getNamespaceContext().getNamespaceURI(nsPrefix);
                        return (JournalType)ExtensionMapper.getTypeObject(nsUri, type, reader);
                    }
                }
                Vector handledAttributes = new Vector();
                reader.next();
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "ISSN").equals(reader.getName())) {
                    object.setISSN(ISSNType.Factory.parse(reader));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "JournalIssue").equals(reader.getName())) {
                    object.setJournalIssue(JournalIssueType.Factory.parse(reader));
                    reader.next();
                } else {
                    throw new ADBException("Unexpected subelement " + reader.getLocalName());
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "Title").equals(reader.getName())) {
                    content = reader.getElementText();
                    object.setTitle(ConverterUtil.convertToString((String)content));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("http://www.ncbi.nlm.nih.gov/soap/eutils/efetch_pubmed", "ISOAbbreviation").equals(reader.getName())) {
                    content = reader.getElementText();
                    object.setISOAbbreviation(ConverterUtil.convertToString((String)content));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement()) {
                    throw new ADBException("Unexpected subelement " + reader.getLocalName());
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

