/*
 * Decompiled with CFR 0.152.
 */
package de.hzi.infg.test;

import de.hzi.infg.RInterface;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InvocationTest {
    private RInterface ri;

    @Before
    public void setUp() throws Exception {
        this.ri = new RInterface("", true, true);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test_eInfoDbNames() {
        Object[] actualReqParameter = this.ri.getRequestParameter("einfo");
        Assert.assertNotNull((Object)actualReqParameter);
        Object[] expectedReqParameter = new String[]{"db", "tool", "email"};
        Assert.assertArrayEquals((Object[])expectedReqParameter, (Object[])actualReqParameter);
        String[] einfoReq1 = new String[]{"db", "", "tool", "", "email", ""};
        this.ri.EInfoInterface(einfoReq1);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        Assert.assertFalse((boolean)this.ri.isDbInfo());
        Assert.assertNotNull((Object)this.ri.getDbNames());
    }

    @Test
    public void test_eInfoDbInfo() {
        String[] einfoReq2 = new String[]{"db", "genome", "tool", "", "email", ""};
        this.ri.EInfoInterface(einfoReq2);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        Assert.assertTrue((boolean)this.ri.isDbInfo());
        Object[] expectedResultParameter = new String[]{"lastupdate", "false", "fieldlist", "true", "description", "false", "dbname", "false", "linklist", "true", "menuname", "false"};
        Object[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        Assert.assertArrayEquals((Object[])expectedResultParameter, (Object[])actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + (String)actualResultParameter[i + 1]);
            if (((String)actualResultParameter[i + 1]).equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType((String)actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eUtilsExampleEInfoResult_" + (String)actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType((String)actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eGQuery() {
        Object[] actualReqParameter = this.ri.getRequestParameter("egquery");
        Assert.assertNotNull((Object)actualReqParameter);
        Object[] expectedReqParameter = new String[]{"term", "tool", "email"};
        Assert.assertArrayEquals((Object[])expectedReqParameter, (Object[])actualReqParameter);
        String[] egqueryReq = new String[]{"term", "mouse", "tool", "", "email", ""};
        this.ri.EGQueryInterface(egqueryReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        Object[] expectedResultParameter = new String[]{"term", "false", "resultitem", "true"};
        Object[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        Assert.assertArrayEquals((Object[])expectedResultParameter, (Object[])actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + (String)actualResultParameter[i + 1]);
            if (((String)actualResultParameter[i + 1]).equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType((String)actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eUtilsExampleEGQueryResult_" + (String)actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType((String)actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eSearch() {
        Object[] actualReqParameter = this.ri.getRequestParameter("esearch");
        Assert.assertNotNull((Object)actualReqParameter);
        Object[] expectedReqParameter = new String[]{"db", "term", "webenv", "query_key", "usehistory", "tool", "email", "field", "reldate", "mindate", "maxdate", "datetype", "retstart", "retmax", "rettype", "sort"};
        Assert.assertArrayEquals((Object[])expectedReqParameter, (Object[])actualReqParameter);
        String[] esearchReq = new String[]{"db", "journals", "term", "stem", "webenv", "", "query_key", "", "usehistory", "", "tool", "", "email", "", "field", "", "reldate", "", "mindate", "", "maxdate", "", "datetype", "", "retstart", "", "retmax", "15", "rettype", "", "sort", ""};
        this.ri.ESearchInterface(esearchReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        Object[] expectedResultParameter = new String[]{"webenv", "false", "querykey", "false", "retstart", "false", "retmax", "false", "count", "false", "idlist", "true", "translationset", "true", "translationstack", "true", "querytranslation", "false", "errorlist", "true", "warninglist", "true"};
        Object[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        Assert.assertArrayEquals((Object[])expectedResultParameter, (Object[])actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + (String)actualResultParameter[i + 1]);
            if (((String)actualResultParameter[i + 1]).equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType((String)actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eUtilsExampleESearchResult_" + (String)actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType((String)actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eSummary() {
        Object[] actualReqParameter = this.ri.getRequestParameter("esummary");
        Assert.assertNotNull((Object)actualReqParameter);
        Object[] expectedReqParameter = new String[]{"db", "id", "webenv", "query_key", "retstart", "retmax", "tool", "email"};
        Assert.assertArrayEquals((Object[])expectedReqParameter, (Object[])actualReqParameter);
        String[] esummaryReq = new String[]{"db", "nucleotide", "id", "28864546{bw}28800981", "webenv", "", "query_key", "", "retstart", "", "retmax", "", "tool", "", "email", ""};
        this.ri.ESummaryInterface(esummaryReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        Object[] expectedResultParameter = new String[]{"docsum", "true"};
        Object[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        Assert.assertArrayEquals((Object[])expectedResultParameter, (Object[])actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + (String)actualResultParameter[i + 1]);
            if (((String)actualResultParameter[i + 1]).equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType((String)actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eUtilsExampleESummaryResult_" + (String)actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType((String)actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eLink() {
        Object[] actualReqParameter = this.ri.getRequestParameter("elink");
        Assert.assertNotNull((Object)actualReqParameter);
        Object[] expectedReqParameter = new String[]{"db", "id", "reldate", "mindate", "maxdate", "datetype", "term", "dbfrom", "webenv", "query_key", "cmd", "tool", "email", "linkname"};
        Assert.assertArrayEquals((Object[])expectedReqParameter, (Object[])actualReqParameter);
        String[] elinkReq = new String[]{"db", "", "id", "12085856{bw}12085853", "reldate", "", "mindate", "", "maxdate", "", "datetype", "", "term", "", "dbfrom", "pubmed", "webenv", "", "query_key", "", "cmd", "llinks", "tool", "", "email", "", "linkname", ""};
        this.ri.ELinkInterface(elinkReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        Object[] expectedResultParameter = new String[]{"linkset", "true"};
        Object[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        Assert.assertArrayEquals((Object[])expectedResultParameter, (Object[])actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + (String)actualResultParameter[i + 1]);
            if (((String)actualResultParameter[i + 1]).equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType((String)actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eUtilsExampleELinkResult_" + (String)actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType((String)actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eSpell() {
        Object[] actualReqParameter = this.ri.getRequestParameter("espell");
        Assert.assertNotNull((Object)actualReqParameter);
        Object[] expectedReqParameter = new String[]{"db", "term", "tool", "email"};
        Assert.assertArrayEquals((Object[])expectedReqParameter, (Object[])actualReqParameter);
        String[] eSpellReq = new String[]{"db", "pubmed", "term", "asthmaa hay fevar", "tool", "", "email", ""};
        this.ri.ESpellInterface(eSpellReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        Object[] expectedResultParameter = new String[]{"query", "false", "database", "false", "correctedquery", "false", "spelledquery", "true"};
        Object[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        Assert.assertArrayEquals((Object[])expectedResultParameter, (Object[])actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            if (((String)actualResultParameter[i + 1]).equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType((String)actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eUtilsExampleESpellResult_" + (String)actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType((String)actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_ePost() {
        Object[] actualReqParameter = this.ri.getRequestParameter("epost");
        Assert.assertNotNull((Object)actualReqParameter);
        Object[] expectedReqParameter = new String[]{"db", "id", "webenv", "tool", "email"};
        Assert.assertArrayEquals((Object[])expectedReqParameter, (Object[])actualReqParameter);
        String[] ePostReq = new String[]{"db", "pubmed", "id", "37281", "webenv", "", "tool", "", "email", ""};
        this.ri.EPostInterface(ePostReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        String[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + actualResultParameter[i + 1]);
            if (actualResultParameter[i + 1].equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType(actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eUtilsExampleEPostResult_" + actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType(actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_EfetchRequest() {
        Assert.assertNotNull((Object)RInterface.getEFetchDatabases());
    }

    @Test
    public void test_eEfetchPubmed() {
        this.ri.initEFetchOperation("pubmed");
        String[] actualReqParameter = this.ri.getRequestParameter("efetch");
        Assert.assertNotNull((Object)actualReqParameter);
        String[] eFetchPubmedReq = new String[]{"id", "12091962{bw}9997", "retstart", "", "webenv", "", "email", "", "tool", "", "rettype", "", "retmax", "", "query_key", ""};
        this.ri.EFetchInterface(eFetchPubmedReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        String[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + actualResultParameter[i + 1]);
            if (actualResultParameter[i + 1].equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType(actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eFetchExamplePubmedResult_" + actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType(actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eEfetchNlmc() {
        this.ri.initEFetchOperation("nlmc");
        String[] actualReqParameter = this.ri.getRequestParameter("efetch");
        Assert.assertNotNull((Object)actualReqParameter);
        String[] eFetchNlmcReq = new String[]{"id", "1408329", "retstart", "", "webenv", "", "email", "", "tool", "", "rettype", "", "retmax", "", "query_key", ""};
        this.ri.EFetchInterface(eFetchNlmcReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        String[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + actualResultParameter[i + 1]);
            if (actualResultParameter[i + 1].equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType(actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eFetchExampleNlmcResult_" + actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType(actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eEfetchTaxon() {
        this.ri.initEFetchOperation("taxon");
        String[] actualReqParameter = this.ri.getRequestParameter("efetch");
        Assert.assertNotNull((Object)actualReqParameter);
        String[] eFetchTaxonReq = new String[]{"id", "3702", "webenv", "", "email", "", "query_key", "", "tool", "", "report", ""};
        this.ri.EFetchInterface(eFetchTaxonReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        String[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + actualResultParameter[i + 1]);
            if (actualResultParameter[i + 1].equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType(actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eFetchExampleTaxonResult_" + actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType(actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eEfetchOmim() {
        this.ri.initEFetchOperation("omim");
        String[] actualReqParameter = this.ri.getRequestParameter("efetch");
        Assert.assertNotNull((Object)actualReqParameter);
        String[] eFetchOmimReq = new String[]{"id", "179605", "retstart", "", "webenv", "", "email", "", "tool", "", "rettype", "", "retmax", "", "query_key", ""};
        this.ri.EFetchInterface(eFetchOmimReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        String[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + actualResultParameter[i + 1]);
            if (actualResultParameter[i + 1].equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType(actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eFetchExampleOmimResult_" + actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType(actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eEfetchSnp() {
        this.ri.initEFetchOperation("snp");
        String[] actualReqParameter = this.ri.getRequestParameter("efetch");
        Assert.assertNotNull((Object)actualReqParameter);
        String[] eFetchSnpReq = new String[]{"id", "52657273{bw}52592489", "retstart", "", "webenv", "", "email", "", "query_key", "", "tool", "", "retmax", ""};
        this.ri.EFetchInterface(eFetchSnpReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        String[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + actualResultParameter[i + 1]);
            if (actualResultParameter[i + 1].equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType(actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eFetchExampleSnpResult_" + actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType(actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eEfetchSequence() {
        this.ri.initEFetchOperation("sequence");
        String[] actualReqParameter = this.ri.getRequestParameter("efetch");
        Assert.assertNotNull((Object)actualReqParameter);
        String[] eFetchSequenceReq = new String[]{"db", "nuccore", "webenv", "", "complexity", "", "tool", "", "strand", "", "seq_stop", "", "rettype", "", "id", "294612694", "retstart", "", "seq_start", "", "query_key", "", "email", "", "report", "", "retmax", ""};
        this.ri.EFetchInterface(eFetchSequenceReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        String[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + actualResultParameter[i + 1]);
            if (actualResultParameter[i + 1].equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType(actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eFetchExampleSequenceResult_" + actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType(actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eEfetchJournals() {
        this.ri.initEFetchOperation("journals");
        String[] actualReqParameter = this.ri.getRequestParameter("efetch");
        Assert.assertNotNull((Object)actualReqParameter);
        String[] eFetchJournalsReq = new String[]{"id", "20318", "retstart", "", "webenv", "", "email", "", "querykey", "", "tool", "", "rettype", "", "retmax", ""};
        this.ri.EFetchInterface(eFetchJournalsReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        String[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + actualResultParameter[i + 1]);
            if (actualResultParameter[i + 1].equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType(actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eFetchExampleJournalsResult_" + actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType(actualResultParameter[i]));
            }
            i += 2;
        }
    }

    @Test
    public void test_eEfetchGene() {
        this.ri.initEFetchOperation("gene");
        String[] actualReqParameter = this.ri.getRequestParameter("efetch");
        Assert.assertNotNull((Object)actualReqParameter);
        String[] eFetchGeneReq = new String[]{"id", "214271", "retstart", "", "webenv", "", "email", "", "tool", "", "retmax", "", "querykey", ""};
        this.ri.EFetchInterface(eFetchGeneReq);
        Assert.assertFalse((boolean)this.ri.isErrorCaused());
        String[] actualResultParameter = this.ri.getResultParameter();
        Assert.assertNotNull((Object)actualResultParameter);
        int i = 0;
        while (i < actualResultParameter.length) {
            System.out.println(String.valueOf(actualResultParameter[i]) + ": " + actualResultParameter[i + 1]);
            if (actualResultParameter[i + 1].equalsIgnoreCase("true")) {
                String[] comp = this.ri.getComplexType(actualResultParameter[i]);
                Assert.assertNotNull((Object)comp);
                String[] stringArray = comp;
                int n = comp.length;
                int n2 = 0;
                while (n2 < n) {
                    String res = stringArray[n2];
                    Assert.assertNotNull((Object)res);
                    File file = new File("ExampleOut/eFetchExampleGeneResult_" + actualResultParameter[i] + ".xml");
                    try {
                        FileUtils.writeStringToFile((File)file, (String)res);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++n2;
                }
            } else {
                Assert.assertNotNull((Object)this.ri.getSimpleType(actualResultParameter[i]));
            }
            i += 2;
        }
    }
}

