% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{plot_pca}
\alias{plot_pca}
\title{Plot results of a principal component analysis}
\usage{
plot_pca(
  obj,
  PC_x = 1,
  PC_y = 2,
  n_feats = 500,
  scale_feats = FALSE,
  na_frac = 0.3,
  metadata = NULL,
  color_by = NULL,
  shape_by = NULL,
  point_alpha = 0.7,
  point_rel_size = 2,
  show_plot = TRUE
)
}
\arguments{
\item{obj}{A (features x samples) matrix or SummarizedExperiment object}

\item{PC_x}{The PC to show on the x-axis.}

\item{PC_y}{The PC to show on the y-axis.}

\item{n_feats}{Number of top-variable features to include.}

\item{scale_feats}{Whether to scale the features.}

\item{na_frac}{Only consider features with the stated maximum fraction of NAs or NaNs. NA/NaNs will be mean-imputed for PCA.}

\item{metadata}{A data.frame used for annotating samples. \code{rownames(metadata)} must match \code{colnames(obj)}.}

\item{color_by}{Variable by which to color points. Must be a column in metadata or in \code{colData(obj)}.}

\item{shape_by}{Variable by which to color points. Must be a column in metadata or in \code{colData(obj)}.}

\item{point_alpha}{alpha value of \code{geom_point()}}

\item{point_rel_size}{relative size of \code{geom_point()}}

\item{show_plot}{Whether to show the plot or not}
}
\value{
The function displays the plot and returns invisible a list of the plot,
the data.frame to make the plot, the vector of percentages of variance explained and the loadings matrix.
}
\description{
Plot results of a principal component analysis
}
\details{
If the \code{metadata} or \code{colData} of \code{obj} contain a column \code{colname}, this colum will be removed in the \verb{$pca_data} slot,
because this column contains the colnames of the data matrix. Similarly, for the \verb{$loadings} slot, the column \code{rowname} is
reserved for the rownames of the data matrix.
}
\examples{
set.seed(1)
data <- matrix(rnorm(100*6), ncol=6)
data <- t(t(data)+c(-1, -1.1, -1.2, 1, 1.1, 1.2))
plot_pca(data)

}
