/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.ReplicaSetStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaggableReadPreference
extends ReadPreference {
    private static final List<DBObject> EMPTY = new ArrayList<DBObject>();
    final List<DBObject> _tags;

    TaggableReadPreference() {
        this._tags = EMPTY;
    }

    TaggableReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
        if (firstTagSet == null) {
            throw new IllegalArgumentException("Must have at least one tag set");
        }
        this._tags = new ArrayList<DBObject>();
        this._tags.add(firstTagSet);
        Collections.addAll(this._tags, remainingTagSets);
    }

    @Override
    public boolean isSlaveOk() {
        return true;
    }

    @Override
    public DBObject toDBObject() {
        BasicDBObject readPrefObject = new BasicDBObject("mode", this.getName());
        if (!this._tags.isEmpty()) {
            readPrefObject.put("tags", (Object)this._tags);
        }
        return readPrefObject;
    }

    public List<DBObject> getTagSets() {
        ArrayList<DBObject> tags = new ArrayList<DBObject>();
        for (DBObject tagSet : this._tags) {
            tags.add(tagSet);
        }
        return tags;
    }

    public String toString() {
        return this.getName() + this.printTags();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggableReadPreference that = (TaggableReadPreference)o;
        return this._tags.equals(that._tags);
    }

    public int hashCode() {
        int result2 = this._tags.hashCode();
        result2 = 31 * result2 + this.getName().hashCode();
        return result2;
    }

    String printTags() {
        return this._tags.isEmpty() ? "" : " : " + new BasicDBObject("tags", this._tags);
    }

    private static List<ReplicaSetStatus.Tag> getTagListFromDBObject(DBObject curTagSet) {
        ArrayList<ReplicaSetStatus.Tag> tagList = new ArrayList<ReplicaSetStatus.Tag>();
        for (String key : curTagSet.keySet()) {
            tagList.add(new ReplicaSetStatus.Tag(key, curTagSet.get(key).toString()));
        }
        return tagList;
    }

    static class PrimaryPreferredReadPreference
    extends SecondaryReadPreference {
        PrimaryPreferredReadPreference() {
        }

        PrimaryPreferredReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
            super(firstTagSet, remainingTagSets);
        }

        public String getName() {
            return "primaryPreferred";
        }

        ReplicaSetStatus.ReplicaSetNode getNode(ReplicaSetStatus.ReplicaSet set) {
            ReplicaSetStatus.ReplicaSetNode node = set.getMaster();
            return node != null ? node : super.getNode(set);
        }
    }

    static class NearestReadPreference
    extends TaggableReadPreference {
        NearestReadPreference() {
        }

        NearestReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
            super(firstTagSet, remainingTagSets);
        }

        public String getName() {
            return "nearest";
        }

        ReplicaSetStatus.ReplicaSetNode getNode(ReplicaSetStatus.ReplicaSet set) {
            if (this._tags.isEmpty()) {
                return set.getAMember();
            }
            for (DBObject curTagSet : this._tags) {
                List tagList = TaggableReadPreference.getTagListFromDBObject(curTagSet);
                ReplicaSetStatus.ReplicaSetNode node = set.getAMember(tagList);
                if (node == null) continue;
                return node;
            }
            return null;
        }
    }

    static class SecondaryPreferredReadPreference
    extends SecondaryReadPreference {
        SecondaryPreferredReadPreference() {
        }

        SecondaryPreferredReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
            super(firstTagSet, remainingTagSets);
        }

        public String getName() {
            return "secondaryPreferred";
        }

        ReplicaSetStatus.ReplicaSetNode getNode(ReplicaSetStatus.ReplicaSet set) {
            ReplicaSetStatus.ReplicaSetNode node = super.getNode(set);
            return node != null ? node : set.getMaster();
        }
    }

    static class SecondaryReadPreference
    extends TaggableReadPreference {
        SecondaryReadPreference() {
        }

        SecondaryReadPreference(DBObject firstTagSet, DBObject ... remainingTagSets) {
            super(firstTagSet, remainingTagSets);
        }

        public String getName() {
            return "secondary";
        }

        ReplicaSetStatus.ReplicaSetNode getNode(ReplicaSetStatus.ReplicaSet set) {
            if (this._tags.isEmpty()) {
                return set.getASecondary();
            }
            for (DBObject curTagSet : this._tags) {
                List tagList = TaggableReadPreference.getTagListFromDBObject(curTagSet);
                ReplicaSetStatus.ReplicaSetNode node = set.getASecondary(tagList);
                if (node == null) continue;
                return node;
            }
            return null;
        }
    }
}

