% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT_plotCrit.R
\name{plotCrit}
\alias{plotCrit}
\title{Plot BIC and ICL}
\usage{
plotCrit(output, crit = c("BIC", "ICL"), pkg = c("ggplot2", "plotly"), ...)
}
\arguments{
\item{output}{\emph{MixtCompLearn} object}

\item{crit}{criterion to plot (can be "BIC", "ICL" or  c("BIC", "ICL") (default))}

\item{pkg}{"ggplot2" or "plotly". Package used to plot}

\item{...}{arguments to be passed to plot_ly}
}
\value{
\code{ggplot2} or \code{plotly} object
}
\description{
Plot BIC and ICL with regards to the number of classes
}
\examples{
data(iris)

# define the algorithm's parameters
algo <- createAlgo()

# keep only 3 variables
model <- list(
  Petal.Width = "Gaussian", Petal.Length = "Gaussian",
  Sepal.Width = "Gaussian", Sepal.Length = "Gaussian"
)

# run RMixtComp in unsupervised clustering mode + data as matrix
res <- mixtCompLearn(iris, model, algo, nClass = 1:4, nCore = 1)

# plot
plotCrit(res)

}
\seealso{
Other plot: 
\code{\link{plot.MixtCompLearn}()}
}
\author{
Quentin Grimonprez
}
\concept{plot}
