% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{VaRSimTest}
\alias{VaRSimTest}
\title{VaR Calculation and Coverage Test}
\usage{
VaRSimTest(data, method, alpha, fun, ...)
}
\arguments{
\item{data}{vector of returns}

\item{method}{the VaR method, one of "param", "hist" and "mc"}

\item{alpha}{the VaR confidence level}

\item{fun}{function calculating VaR, limited by \code{method}}

\item{...}{the extra parameters of \code{fun}}
}
\value{
A list of VaR and coverage test outcome
}
\description{
Calculate VaR with three method and implement unconditional and conditional coverage test.
}
\examples{
swan <- rGarch(len = 30)
date <- as.Date("2015-01-01") + days(0:(length(swan) - 1))
tswan <- tibble(garch = swan, date = date)
tsswan <- as.xts(swan, date)
alpha = 0.05
num = 100000
mu = mean(tsswan)
sd = sd(tsswan)
VaRSimTest(tsswan, "mc", alpha , rnorm, 100000, mu, sd)
}
\references{
Christoffersen P. F. 1998. "Evaluating Interval Forecasts", International Economic Review, 841-862. doi: 10.2307/2527341.

Kupiec PH. 1995. "Techniques for Verifying the Accuracy of Risk Measurement Models", The Journal of Derivatives, 3(2), 73-84. doi: 10.3905/jod.1995.407942.
}
