% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/popover.R
\name{popover}
\alias{popover}
\title{Create a bootstrap button with popover}
\usage{
popover(title, content, header = NULL, html = TRUE,
  class = "btn btn-default", placement = c("right", "top", "left",
  "bottom"), trigger = c("click", "hover", "focus", "manual"))
}
\arguments{
\item{title}{\code{\link{character}} (required): Title of the button.}

\item{content}{\code{\link{character}}: Text to be displayed in the popover.}

\item{header}{\code{\link{character}}: Optional header in the popover.}

\item{html}{\code{\link{logical}} Insert HTML into the popover.}

\item{class}{\code{\link{logical}} Bootstrap button class (e.g. "btn btn-danger").}

\item{placement}{\code{\link{character}}: How to position the popover - top | bottom | left | right | auto. When "auto" is specified, it will dynamically reorient the popover. For example, if placement is "auto left", the popover will display to the left when possible, otherwise it will display right.}

\item{trigger}{\code{\link{character}}: How popover is triggered - click | hover | focus | manual.}
}
\description{
Add small overlays of content for housing secondary information.
}
\examples{
# html code
popover("title", "Some content")

# example app
\dontrun{
shinyApp(
ui = fluidPage(
  jscolorInput(inputId = "col", label = "JSColor Picker",
               value = "21BF6B", position = "right",
               mode = "HVS", close = TRUE),
  popover(title = "Help!", content = "Call 911"),
  plotOutput("plot")
),
server = function(input, output) {
  output$plot <- renderPlot({
    plot(cars, col = input$col, cex = 2, pch = 16)
 })
})
}
}

