% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci}
\alias{ci}
\title{Add confidence interval and relative frequency variables}
\usage{
ci(df, x = totalResults, N = total, conf.level = 0.95)
}
\arguments{
\item{df}{table with columns for absolute and total frequencies.}

\item{x}{column with the observed absolute frequency.}

\item{N}{column with the total frequencies}

\item{conf.level}{confidence level of the returned confidence interval. Must
be a single number between 0 and 1.}
}
\description{
Using \code{\link{prop.test}}, \code{ci} adds three columns to a data frame:
1. relative frequency (\code{f})
2. lower bound of a confidence interval (\code{ci.low})
3. upper bound of a confidence interval
}
\examples{
\donttest{
library(ggplot2)
kco <- new("KorAPConnection", verbose=TRUE)
expand_grid(year=2015:2018, alternatives=c("Hate Speech", "Hatespeech")) \%>\%
  bind_cols(corpusQuery(kco, .$alternatives, sprintf("pubDate in \%d", .$year))) \%>\%
  mutate(total=corpusStats(kco, vc=vc)$tokens) \%>\%
  ci() \%>\%
  ggplot(aes(x=year, y=f, fill=query, color=query, ymin=conf.low, ymax=conf.high)) +
    geom_point() + geom_line() + geom_ribbon(alpha=.3)
}
}
\seealso{
\code{ci} is already included in \code{\link{frequencyQuery}}
}
