% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{queryStringToLabel}
\alias{queryStringToLabel}
\title{Convert query or vc strings to plot labels}
\usage{
queryStringToLabel(data, pubDateOnly = FALSE, excludePubDate = FALSE)
}
\arguments{
\item{data}{string or vector of query or vc definition strings}

\item{pubDateOnly}{discard all but the publication date}

\item{excludePubDate}{discard publication date constraints}
}
\value{
string or vector of strings with clipped off common prefixes and suffixes
}
\description{
Converts a vector of query or vc strings to typically appropriate legend labels
by clipping off prefixes and suffixes that are common to all query strings.
}
\examples{
queryStringToLabel(paste("textType = /Zeit.*/ & pubDate in", c(2010:2019)))
queryStringToLabel(c("[marmot/m=mood:subj]", "[marmot/m=mood:ind]"))
queryStringToLabel(c("wegen dem [tt/p=NN]", "wegen des [tt/p=NN]"))

}
